/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.block.custom;

import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.item.ItemsObs;
import org.jetbrains.annotations.Nullable;

public class ObsidianTablet
extends Block {
    private static final VoxelShape SHAPE_NORTH_SOUTH = Block.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)23.0, (double)10.0);
    private static final VoxelShape SHAPE_EAST_WEST = Block.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)23.0, (double)14.0);
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty EXPERIENCED = BooleanProperty.m_61465_((String)"experienced");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static final Random random = new Random();

    public ObsidianTablet(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)EXPERIENCED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NORTH_SOUTH : SHAPE_EAST_WEST;
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        super.m_6256_(pState, pLevel, pPos, pPlayer);
        if (!((Boolean)pState.m_61143_((Property)EXPERIENCED)).booleanValue()) {
            pLevel.m_254849_(null, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 3.0f, Level.ExplosionInteraction.TNT);
            int lightningCount = 1 + random.nextInt(6);
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            for (int i = 0; i < lightningCount; ++i) {
                int index = i;
                long initialDelay = (long)(index == 0 ? random.nextInt(10) : 10) * 50L;
                executor.schedule(() -> this.spawnLightning(pLevel, pPos), initialDelay, TimeUnit.MILLISECONDS);
                long initialDelay2 = (long)(index == 0 ? random.nextInt(10) : 20) * 50L;
                executor.schedule(() -> this.spawnLightning(pLevel, pPos), initialDelay2, TimeUnit.MILLISECONDS);
                long initialDelay3 = (long)(index == 0 ? random.nextInt(10) : 25) * 50L;
                executor.schedule(() -> this.spawnLightning(pLevel, pPos), initialDelay3, TimeUnit.MILLISECONDS);
                long initialDelay4 = (long)(index == 0 ? random.nextInt(10) : 35) * 50L;
                executor.schedule(() -> this.spawnLightning(pLevel, pPos), initialDelay4, TimeUnit.MILLISECONDS);
            }
            pLevel.m_7731_(pPos, Blocks.f_50016_.m_49966_(), 3);
            executor.shutdown();
        }
    }

    private void spawnLightning(Level pLevel, BlockPos pPos) {
        double offsetX = (double)pPos.m_123341_() + (random.nextDouble() * 12.0 - 6.0);
        double offsetY = pPos.m_123342_();
        double offsetZ = (double)pPos.m_123343_() + (random.nextDouble() * 12.0 - 6.0);
        LightningBolt lightning = new LightningBolt(EntityType.f_20465_, pLevel);
        lightning.m_6027_(offsetX, offsetY, offsetZ);
        pLevel.m_7967_((Entity)lightning);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            int customModelData = tag.m_128451_("CustomModelData");
            boolean experienced = customModelData == 1 || customModelData == 2;
            boolean active = customModelData == 2;
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)EXPERIENCED, (Comparable)Boolean.valueOf(experienced))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, EXPERIENCED, ACTIVE});
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean result = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!player.m_7500_() && result && this.canHarvestBlock(state, (BlockGetter)level, pos, player)) {
            ItemStack itemStack = new ItemStack((ItemLike)this.m_5456_());
            ItemStack tool = player.m_21205_();
            boolean hasSilkTouch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0;
            CompoundTag compoundTag = new CompoundTag();
            itemStack.m_41751_(compoundTag);
            if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && hasSilkTouch) {
                compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
                compoundTag.m_128379_("active", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
                itemStack.m_41784_().m_128405_("CustomModelData", 2);
            } else if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && hasSilkTouch) {
                compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
                itemStack.m_41784_().m_128405_("CustomModelData", 1);
            } else if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !hasSilkTouch) {
                compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
                itemStack.m_41784_().m_128405_("CustomModelData", 1);
            } else if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !hasSilkTouch) {
                compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
                itemStack.m_41784_().m_128405_("CustomModelData", 1);
            }
            ObsidianTablet.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        return result;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this.m_5456_());
        CompoundTag compoundTag = new CompoundTag();
        itemStack.m_41751_(compoundTag);
        itemStack.m_41784_().m_128405_("CustomModelData", 0);
        if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
            compoundTag.m_128379_("active", ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue());
            itemStack.m_41784_().m_128405_("CustomModelData", 2);
        } else if (((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue()) {
            compoundTag.m_128379_("experienced", ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue());
            itemStack.m_41784_().m_128405_("CustomModelData", 1);
        }
        return itemStack;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        ItemStack tool = player.m_21205_();
        if (tool.m_41720_() instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)tool.m_41720_();
            int toolLevel = tieredItem.m_43314_().m_6604_();
            return toolLevel >= 3;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.f_46443_) {
            ItemStack itemInHand = player.m_21120_(hand);
            if (itemInHand.m_41720_() == ItemsObs.OBSIDIAN_TEAR.get() && ((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue() && !((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11860_, player.m_5720_(), 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    for (int i = 0; i < 10; ++i) {
                        double offsetX = world.f_46441_.m_188583_() * 0.5;
                        double offsetY = world.f_46441_.m_188583_() * 0.5;
                        double offsetZ = world.f_46441_.m_188583_() * 0.5;
                        serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 5, offsetX, offsetY, offsetZ, 1.0);
                    }
                }
                itemInHand.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (hand == InteractionHand.MAIN_HAND && !((Boolean)state.m_61143_((Property)EXPERIENCED)).booleanValue()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)EXPERIENCED, (Comparable)Boolean.valueOf(true)), 3);
                LightningBolt lightning = new LightningBolt(EntityType.f_20465_, world);
                lightning.m_6027_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                world.m_7967_((Entity)lightning);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.m_186460_(pos, (Block)this, 25);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)ACTIVE) != false ? 6.0f : 0.0f;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockBelow = world.m_8055_(blockpos);
        return Block.m_49918_((VoxelShape)blockBelow.m_60812_((BlockGetter)world, blockpos), (Direction)Direction.UP);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        if (pStack.m_41782_() && pStack.m_41783_().m_128471_("experienced") && pStack.m_41783_().m_128471_("active")) {
            if (Screen.m_96638_()) {
                pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
                pTooltip.add((Component)Component.m_237115_((String)"item.obsidian_tablet.description.active").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else if (pStack.m_41782_() && pStack.m_41783_().m_128471_("experienced") && !pStack.m_41783_().m_128471_("active")) {
            if (Screen.m_96638_()) {
                pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
                pTooltip.add((Component)Component.m_237115_((String)"item.obsidian_tablet.description.crashed").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
            }
        } else if (Screen.m_96638_()) {
            pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            pTooltip.add((Component)Component.m_237115_((String)"item.obsidian_tablet.description.ancient").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            pTooltip.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        if (((Boolean)pState.m_61143_((Property)EXPERIENCED)).booleanValue()) {
            ExperienceOrb.m_147082_((ServerLevel)pLevel, (Vec3)Vec3.m_82512_((Vec3i)pPos), (int)1100);
        }
    }
}

