/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.entity.gart;

import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Gart
extends Monster {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public Gart(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        } else {
            this.checkPlayerLook();
        }
    }

    private void checkPlayerLook() {
        if (this.m_9236_() != null) {
            for (Player player : this.m_9236_().m_6907_()) {
                Vec3 toEntity;
                Vec3 playerLook;
                double angle;
                double radianAngle;
                double degreeAngle;
                if (!player.m_142582_((Entity)this) || !((degreeAngle = Math.toDegrees(radianAngle = Math.acos(Math.min(Math.max(angle = (playerLook = player.m_20154_()).m_82526_(toEntity = this.m_20182_().m_82546_(player.m_20182_()).m_82541_()) / (playerLook.m_82553_() * toEntity.m_82553_()), -1.0), 1.0)))) < 20.0)) continue;
                this.despawn();
                this.dealFlashToPlayer();
                break;
            }
        }
    }

    private void despawn() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void dealFlashToPlayer() {
        this.m_9236_().m_6907_().forEach(player -> {
            if (player.m_142582_((Entity)this)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60));
            }
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Gart.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22285_, 0.4).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22283_, 4.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private boolean isMoving() {
        return this.m_20184_().m_82556_() > 0.01;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(40) + 80;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isMoving()) {
            this.walkAnimationState.m_216977_(this.f_19797_);
        } else {
            this.walkAnimationState.m_216973_();
        }
    }
}

