/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.entity.gart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.rezolv.obsidanum.entity.gart.Gart;
import net.rezolv.obsidanum.entity.gart.GartAnimation;

public class GartModel<T extends Entity>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("obsidanum", "gart"), "main");
    private final ModelPart bone;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public GartModel(ModelPart root) {
        this.bone = root.m_171324_("bone");
        this.body = this.bone.m_171324_("body");
        this.head = this.bone.m_171324_("head");
        this.right_arm = this.bone.m_171324_("right_arm");
        this.left_arm = this.bone.m_171324_("left_arm");
        this.right_leg = this.bone.m_171324_("right_leg");
        this.left_leg = this.bone.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bone = partdefinition.m_171599_("bone", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)11.2f, (float)-1.0f));
        PartDefinition body = bone.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.8f, (float)1.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-3.0f, -4.0f, -1.5f, 6.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.7f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition head = bone.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-3.0f, -6.0f, -3.5f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-3.0f, -6.0f, -3.5f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)-0.2f, (float)-0.2f));
        PartDefinition right_arm = bone.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-3.0f, -1.0f, -1.75f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)0.8f, (float)0.25f));
        PartDefinition left_arm = bone.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(18, 12).m_171488_(0.0f, -1.0f, -1.75f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.8f, (float)0.25f));
        PartDefinition right_leg = bone.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(24, 23).m_171488_(-1.0f, 0.0f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.9f, (float)7.8f, (float)0.5f));
        PartDefinition left_leg = bone.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(12, 23).m_171488_(-2.0f, 0.0f, -1.75f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.9f, (float)7.8f, (float)0.75f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)48);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch, ageInTicks);
        this.m_267799_(GartAnimation.walk, limbSwing, limbSwingAmount, 2.0f, 2.5f);
        this.m_233385_(((Gart)((Object)entity)).idleAnimationState, GartAnimation.idle, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float pNetHeadYaw, float pHeadPitch, float pAgeInTicks) {
        pNetHeadYaw = Mth.m_14036_((float)pNetHeadYaw, (float)-30.0f, (float)30.0f);
        pHeadPitch = Mth.m_14036_((float)pHeadPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bone.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.bone;
    }
}

