/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ObsidanHoe
extends HoeItem {
    private boolean activated = false;
    private long lastActivationTime = 0L;
    private static final long COOLDOWN_DURATION = 200L;
    private static final double BREAK_RADIUS_SQUARED = 400.0;
    private static final long ACTIVATION_DURATION = 100L;
    private static final BlockState[] TARGET_BLOCKS = new BlockState[]{Blocks.f_50034_.m_49966_(), Blocks.f_50359_.m_49966_(), Blocks.f_50035_.m_49966_(), Blocks.f_50036_.m_49966_(), Blocks.f_50654_.m_49966_(), Blocks.f_50693_.m_49966_(), Blocks.f_50083_.m_49966_(), Blocks.f_50360_.m_49966_(), Blocks.f_50694_.m_49966_()};

    public ObsidanHoe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean isActivated() {
        return this.activated;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        long currentTime = worldIn.m_46467_();
        ItemStack itemStack = playerIn.m_21120_(handIn);
        if (!this.activated && currentTime - this.lastActivationTime >= 200L) {
            if (!worldIn.f_46443_) {
                this.activate();
                this.lastActivationTime = currentTime;
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!level.f_46443_ && this.activated) {
            for (BlockState targetBlock : TARGET_BLOCKS) {
                if (state.m_60734_() != targetBlock.m_60734_()) continue;
                int radiusSquared = (int)Math.sqrt(400.0);
                BlockPos playerPos = entity.m_20183_();
                for (int x = -radiusSquared; x <= radiusSquared; ++x) {
                    for (int y = -radiusSquared; y <= radiusSquared; ++y) {
                        block3: for (int z = -radiusSquared; z <= radiusSquared; ++z) {
                            BlockPos blockPos = playerPos.m_7918_(x, y, z);
                            if (!level.m_46749_(blockPos)) continue;
                            for (BlockState grassBlock : TARGET_BLOCKS) {
                                if (level.m_8055_(blockPos).m_60734_() != grassBlock.m_60734_()) continue;
                                level.m_46961_(blockPos, true);
                                continue block3;
                            }
                        }
                    }
                }
                this.deactivate((Player)entity);
                break;
            }
        }
        return super.m_6813_(stack, level, state, pos, entity);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.hoe").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.activated && world.m_46467_() - this.lastActivationTime >= 100L && entity instanceof Player) {
            this.deactivate((Player)entity);
        }
    }

    public void deactivate(Player player) {
        this.activated = false;
        player.m_36335_().m_41524_((Item)this, 200);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = context.m_43722_();
        BlockState state = world.m_8055_(pos);
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(pos.m_121945_(context.m_43719_()), context.m_43719_(), stack)) {
            return InteractionResult.FAIL;
        }
        if (state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_50440_) || state.m_60713_(Blocks.f_152481_) || state.m_60713_(Blocks.f_50546_)) {
            world.m_5594_(player, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.f_46443_) {
                for (BlockPos targetPos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, 0, 1))) {
                    BlockState targetState = world.m_8055_(targetPos);
                    if (!targetState.m_204336_(BlockTags.f_144274_) && !targetState.m_60713_(Blocks.f_50440_) && !targetState.m_60713_(Blocks.f_152481_) && !targetState.m_60713_(Blocks.f_50546_)) continue;
                    world.m_7731_(targetPos, Blocks.f_50093_.m_49966_(), 11);
                    world.m_46796_(2001, targetPos, Block.m_49956_((BlockState)targetState));
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

