/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ObsidanShovel
extends ShovelItem {
    private boolean activated = false;
    private long lastActivationTime = 0L;
    private static final long COOLDOWN_DURATION = 1000L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanShovel(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.activated && world.m_46467_() - this.lastActivationTime >= 100L && entity instanceof Player) {
            this.deactivate((Player)entity, world);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        long currentTime = worldIn.m_46467_();
        if (!this.activated && currentTime - this.lastActivationTime >= 1000L) {
            if (!worldIn.f_46443_) {
                this.activate();
                this.lastActivationTime = currentTime;
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.activated) {
            double knockbackY = 4.0;
            target.m_20334_(target.m_20184_().f_82479_, knockbackY, target.m_20184_().f_82481_);
            this.deactivate((Player)attacker, attacker.m_9236_());
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.shovel").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void activate() {
        this.activated = true;
    }

    public void deactivate(Player player, Level world) {
        this.activated = false;
        player.m_36335_().m_41524_((Item)this, 1000);
    }
}

