/*
 * Decompiled with CFR 0.152.
 */
package net.acidpop.steam_powered.init;

import net.acidpop.steam_powered.entity.BogDwellerEntity;
import net.acidpop.steam_powered.entity.CogbotEntity;
import net.acidpop.steam_powered.entity.GiantCrabEntity;
import net.acidpop.steam_powered.entity.LostDiverEntity;
import net.acidpop.steam_powered.entity.SurfaceCrawlerEntity;
import net.acidpop.steam_powered.entity.TriWheelerEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SteamPoweredModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"steam_powered");
    public static final RegistryObject<EntityType<SurfaceCrawlerEntity>> SURFACE_CRAWLER = SteamPoweredModEntities.register("surface_crawler", EntityType.Builder.m_20704_(SurfaceCrawlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SurfaceCrawlerEntity::new).m_20719_().m_20699_(1.0f, 3.0f));
    public static final RegistryObject<EntityType<BogDwellerEntity>> BOG_DWELLER = SteamPoweredModEntities.register("bog_dweller", EntityType.Builder.m_20704_(BogDwellerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(BogDwellerEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<TriWheelerEntity>> TRI_WHEELER = SteamPoweredModEntities.register("tri_wheeler", EntityType.Builder.m_20704_(TriWheelerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TriWheelerEntity::new).m_20719_().m_20699_(2.0f, 1.5f));
    public static final RegistryObject<EntityType<CogbotEntity>> COGBOT = SteamPoweredModEntities.register("cogbot", EntityType.Builder.m_20704_(CogbotEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CogbotEntity::new).m_20699_(0.6f, 1.3f));
    public static final RegistryObject<EntityType<LostDiverEntity>> LOST_DIVER = SteamPoweredModEntities.register("lost_diver", EntityType.Builder.m_20704_(LostDiverEntity::new, (MobCategory)MobCategory.UNDERGROUND_WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(LostDiverEntity::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<GiantCrabEntity>> GIANT_CRAB = SteamPoweredModEntities.register("giant_crab", EntityType.Builder.m_20704_(GiantCrabEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(GiantCrabEntity::new).m_20699_(1.5f, 1.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SurfaceCrawlerEntity.init();
            BogDwellerEntity.init();
            TriWheelerEntity.init();
            CogbotEntity.init();
            LostDiverEntity.init();
            GiantCrabEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SURFACE_CRAWLER.get(), SurfaceCrawlerEntity.createAttributes().m_22265_());
        event.put((EntityType)BOG_DWELLER.get(), BogDwellerEntity.createAttributes().m_22265_());
        event.put((EntityType)TRI_WHEELER.get(), TriWheelerEntity.createAttributes().m_22265_());
        event.put((EntityType)COGBOT.get(), CogbotEntity.createAttributes().m_22265_());
        event.put((EntityType)LOST_DIVER.get(), LostDiverEntity.createAttributes().m_22265_());
        event.put((EntityType)GIANT_CRAB.get(), GiantCrabEntity.createAttributes().m_22265_());
    }
}

