/*
 * Decompiled with CFR 0.152.
 */
package net.acidpop.steam_powered.world.features.treedecorators;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WetlandsLeaveDecorator
extends LeaveVineDecorator {
    public static Codec<LeaveVineDecorator> CODEC = Codec.unit(WetlandsLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.TREE_DECORATOR_TYPES, registerHelper -> registerHelper.register("wetlands_tree_leave_decorator", DECORATOR_TYPE));
    }

    public WetlandsLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> m_6663_() {
        return DECORATOR_TYPE;
    }

    public void m_214187_(TreeDecorator.Context context) {
        context.m_226069_().forEach(blockpos -> {
            BlockPos pos;
            if (context.m_226067_().m_188501_() < 0.25f && context.m_226059_(pos = blockpos.m_122024_())) {
                WetlandsLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.m_226067_().m_188501_() < 0.25f && context.m_226059_(pos = blockpos.m_122029_())) {
                WetlandsLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.m_226067_().m_188501_() < 0.25f && context.m_226059_(pos = blockpos.m_122012_())) {
                WetlandsLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.m_226067_().m_188501_() < 0.25f && context.m_226059_(pos = blockpos.m_122019_())) {
                WetlandsLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.m_226061_(pos, Blocks.f_50191_.m_49966_());
        BlockPos blockpos = pos.m_7495_();
        for (int i = 4; context.m_226059_(blockpos) && i > 0; --i) {
            context.m_226061_(blockpos, WetlandsLeaveDecorator.oriented(Blocks.f_50191_.m_49966_(), direction));
            blockpos = blockpos.m_7495_();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.m_60734_().m_6843_(blockstate, Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.m_60734_().m_6843_(blockstate, Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.m_60734_().m_6843_(blockstate, Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

