/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.block.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.silverfishstone.silversnifferupgrade.block.ModBlocks;

public class AncientFarmBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    public static final int MAX_MOISTURE = 7;

    public AncientFarmBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return !this.m_49966_().m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) ? ((Block)ModBlocks.ANCIENT_SOIL.get()).m_49966_() : super.m_5573_(pContext);
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            AncientFarmBlock.turnToDirt(null, pState, (Level)pLevel, pPos);
        }
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i = (Integer)pState.m_61143_((Property)MOISTURE);
        if (!AncientFarmBlock.isNearWater((LevelReader)pLevel, pPos) && !pLevel.m_46758_(pPos.m_7494_())) {
            if (i > 0) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!AncientFarmBlock.shouldMaintainFarmland((BlockGetter)pLevel, pPos)) {
                AncientFarmBlock.turnToDirt(null, pState, (Level)pLevel, pPos);
            }
        } else if (i < 7) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level pLevel, BlockState pState, BlockPos pPos, Entity pEntity, float pFallDistance) {
        if (!pLevel.f_46443_ && ForgeHooks.onFarmlandTrample((Level)pLevel, (BlockPos)pPos, (BlockState)((Block)ModBlocks.ANCIENT_SOIL.get()).m_49966_(), (float)pFallDistance, (Entity)pEntity)) {
            AncientFarmBlock.turnToDirt(pEntity, pState, pLevel, pPos);
        }
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public static void turnToDirt(@Nullable Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = AncientFarmBlock.m_49897_((BlockState)pState, (BlockState)((Block)ModBlocks.ANCIENT_SOIL.get()).m_49966_(), (LevelAccessor)pLevel, (BlockPos)pPos);
        pLevel.m_46597_(pPos, blockstate);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter pLevel, BlockPos pPos) {
        BlockState plant = pLevel.m_8055_(pPos.m_7494_());
        BlockState state = pLevel.m_8055_(pPos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(pLevel, pPos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, 0, -4), (BlockPos)pPos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)pLevel, pPos, pLevel.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)pLevel, (BlockPos)pPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter getter, BlockPos pos, Direction direction, IPlantable plantable) {
        BlockState plant = plantable.getPlant(getter, pos.m_121945_(direction));
        PlantType type = plantable.getPlantType(getter, pos.m_121945_(direction));
        if (PlantType.CROP.equals(type)) {
            return true;
        }
        return PlantType.PLAINS.equals(type);
    }
}

