/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.silverfishstone.silversnifferupgrade.block.ModBlocks;
import net.silverfishstone.silversnifferupgrade.block.properties.CarpetSide;

public class PaintedCarpetBlock
extends CarpetBlock {
    public static final EnumProperty<CarpetSide> EAST_EDGE = EnumProperty.m_61587_((String)"east_edge", CarpetSide.class);
    public static final EnumProperty<CarpetSide> NORTH_EDGE = EnumProperty.m_61587_((String)"north_edge", CarpetSide.class);
    public static final EnumProperty<CarpetSide> SOUTH_EDGE = EnumProperty.m_61587_((String)"south_edge", CarpetSide.class);
    public static final EnumProperty<CarpetSide> WEST_EDGE = EnumProperty.m_61587_((String)"west_edge", CarpetSide.class);
    public static final BooleanProperty MIDDLE = BooleanProperty.m_61465_((String)"middle");

    public PaintedCarpetBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MIDDLE, (Comparable)Boolean.valueOf(true))).m_61124_(NORTH_EDGE, (Comparable)((Object)CarpetSide.NONE))).m_61124_(EAST_EDGE, (Comparable)((Object)CarpetSide.NONE))).m_61124_(SOUTH_EDGE, (Comparable)((Object)CarpetSide.NONE))).m_61124_(WEST_EDGE, (Comparable)((Object)CarpetSide.NONE)));
    }

    private ImmutableMap<Object, Object> makeShapes(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : MIDDLE.m_6908_()) {
            for (CarpetSide carpetSide : EAST_EDGE.m_6908_()) {
                for (CarpetSide wallside1 : NORTH_EDGE.m_6908_()) {
                    for (CarpetSide wallside2 : WEST_EDGE.m_6908_()) {
                        for (CarpetSide wallside3 : SOUTH_EDGE.m_6908_()) {
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MIDDLE, (Comparable)obool)).m_61124_(EAST_EDGE, (Comparable)((Object)carpetSide))).m_61124_(WEST_EDGE, (Comparable)((Object)wallside2))).m_61124_(NORTH_EDGE, (Comparable)((Object)wallside1))).m_61124_(SOUTH_EDGE, (Comparable)((Object)wallside3));
                            builder.put((Map.Entry)blockstate.m_61124_((Property)MIDDLE, (Comparable)Boolean.valueOf(false)));
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate = levelreader.m_8055_(blockpos1);
        BlockState blockstate1 = levelreader.m_8055_(blockpos2);
        BlockState blockstate2 = levelreader.m_8055_(blockpos3);
        BlockState blockstate3 = levelreader.m_8055_(blockpos4);
        BlockState blockstate4 = levelreader.m_8055_(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = this.m_49966_();
        return this.updateShape((LevelReader)levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    private boolean connectsTo(BlockState pState, boolean pside, Direction pDirection) {
        Block block = pState.m_60734_();
        return pState.m_60713_((Block)ModBlocks.SNIFFER_CARPET.get());
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            return pFacing == Direction.UP ? this.topUpdate((LevelReader)pLevel, pState, pFacingPos, pFacingState) : this.sideUpdate((LevelReader)pLevel, pCurrentPos, pState, pFacingPos, pFacingState, pFacing);
        }
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : this.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    private static boolean isConnected(BlockState pState, Property<CarpetSide> pHeightProperty) {
        return pState.m_61143_(pHeightProperty) != CarpetSide.NONE;
    }

    private BlockState topUpdate(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pSecondState) {
        boolean flag = PaintedCarpetBlock.isConnected(pState, NORTH_EDGE);
        boolean flag1 = PaintedCarpetBlock.isConnected(pState, EAST_EDGE);
        boolean flag2 = PaintedCarpetBlock.isConnected(pState, SOUTH_EDGE);
        boolean flag3 = PaintedCarpetBlock.isConnected(pState, WEST_EDGE);
        return this.updateShape(pLevel, pState, pPos, pSecondState, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader pLevel, BlockPos pFirstPos, BlockState pFirstState, BlockPos pSecondPos, BlockState pSecondState, Direction pDir) {
        Direction direction = pDir.m_122424_();
        boolean flag = pDir == Direction.NORTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : PaintedCarpetBlock.isConnected(pFirstState, NORTH_EDGE);
        boolean flag1 = pDir == Direction.EAST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : PaintedCarpetBlock.isConnected(pFirstState, EAST_EDGE);
        boolean flag2 = pDir == Direction.SOUTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : PaintedCarpetBlock.isConnected(pFirstState, SOUTH_EDGE);
        boolean flag3 = pDir == Direction.WEST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : PaintedCarpetBlock.isConnected(pFirstState, WEST_EDGE);
        BlockPos blockpos = pFirstPos.m_7494_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return this.updateShape(pLevel, pFirstState, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pNeighbour, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        BlockState blockstate = this.updateSides(pState, pNorthConnection, pEastConnection, pSouthConnection, pWestConnection);
        return (BlockState)blockstate.m_61124_((Property)MIDDLE, (Comparable)Boolean.valueOf(String.valueOf(MIDDLE)));
    }

    private BlockState updateSides(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH_EDGE, (Comparable)((Object)this.makeCarpetState(pNorthConnection)))).m_61124_(EAST_EDGE, (Comparable)((Object)this.makeCarpetState(pEastConnection)))).m_61124_(SOUTH_EDGE, (Comparable)((Object)this.makeCarpetState(pSouthConnection)))).m_61124_(WEST_EDGE, (Comparable)((Object)this.makeCarpetState(pWestConnection)));
    }

    private CarpetSide makeCarpetState(boolean pAllowConnection) {
        if (pAllowConnection) {
            return CarpetSide.BASE;
        }
        return CarpetSide.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH_EDGE, SOUTH_EDGE, EAST_EDGE, WEST_EDGE, MIDDLE});
    }
}

