/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.block.custom;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.ITeleporter;
import net.silverfishstone.silversnifferupgrade.potions.ModMobEffects;
import net.silverfishstone.silversnifferupgrade.sounds.SnifferSounds;
import net.silverfishstone.silversnifferupgrade.worldgen.dimension.ModDimensions;
import net.silverfishstone.silversnifferupgrade.worldgen.portal.AncientTeleporter;

public class SnifferPedestalBlock
extends Block {
    public static final BooleanProperty ACTIVE = BlockStateProperties.f_61443_;

    public SnifferPedestalBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockPos blockpos = pPos.m_7949_();
        if (pPlayer.m_21055_(Item.m_41445_((int)Item.m_41393_((Item)Items.f_276468_)))) {
            if (pLevel.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)pState.m_61122_((Property)ACTIVE);
            pLevel.m_7731_(pPos, blockstate, 4);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            pLevel.m_6263_((Player)null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)SnifferSounds.SNIFFER_PEDESTAL_ACTIVATE.get(), SoundSource.NEUTRAL, 0.2f, 0.3f);
            pPlayer.m_21120_(pHand).m_41774_(1);
            return InteractionResult.CONSUME;
        }
        if (((Boolean)pState.m_61143_((Property)ACTIVE)).booleanValue()) {
            if (pPlayer.m_6072_()) {
                if (pPlayer.m_21023_((MobEffect)ModMobEffects.OXYGENATED.get()) || pPlayer.m_9236_().m_46472_() == ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("silversnifferupgrade:ancient_fields")) || this.checkCreative((Entity)pPlayer)) {
                    this.handleAncientPortal((Entity)pPlayer, pPos);
                    return InteractionResult.SUCCESS;
                }
                pPlayer.m_5661_((Component)Component.m_237113_((String)"Cannot enter dimension. Not acclimated. Please brew an Oxygenated Potion and return."), true);
                return InteractionResult.PASS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    private void handleAncientPortal(Entity player, BlockPos pPos) {
        ResourceKey<Level> resourcekey;
        ServerLevel serverlevel;
        MinecraftServer minecraftserver;
        ServerLevel portalDimension;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (portalDimension = (minecraftserver = (serverlevel = (ServerLevel)level).m_7654_()).m_129880_(resourcekey = player.m_9236_().m_46472_() == ModDimensions.ANCIENT_FIELDS_LEVEL_KEY ? Level.f_46428_ : ModDimensions.ANCIENT_FIELDS_LEVEL_KEY)) != null && !player.m_20159_()) {
            if (resourcekey == ModDimensions.ANCIENT_FIELDS_LEVEL_KEY) {
                player.changeDimension(portalDimension, (ITeleporter)new AncientTeleporter(pPos, true));
            } else {
                player.changeDimension(portalDimension, (ITeleporter)new AncientTeleporter(pPos, false));
            }
        }
    }

    public boolean checkCreative(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.f_8941_.m_9290_() == GameType.CREATIVE;
        }
        if (entity.m_9236_().m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            return Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_104949_(player.m_36316_().getId()) != null && Objects.requireNonNull(Minecraft.m_91087_().m_91403_().m_104949_(player.m_36316_().getId())).m_105325_() == GameType.CREATIVE;
        }
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{ACTIVE});
    }
}

