/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.datagen;

import java.util.LinkedHashMap;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.silverfishstone.silversnifferupgrade.block.ModBlocks;
import net.silverfishstone.silversnifferupgrade.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, "silversnifferupgrade", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.ANCIENT_APPLE);
        this.simpleItem(ModItems.BIOMIC_SLUDGE);
        this.simpleItem(ModItems.BIOMITE_GEM);
        this.simpleItem(ModItems.ROTTEN_APPLE);
        this.simpleItem(ModItems.BIOMITE_CRYSTAL);
        this.simpleItem(ModItems.BIOMIC_SLUDGE_VIAL);
        this.simpleItem(ModItems.BIOMITE_FRUIT);
        this.simpleItem(ModItems.BIOMIC_CAPSULE);
        this.simpleItem(ModItems.HORSETAIL_SPORES);
        this.simpleItem(ModItems.ROASTED_DODO_MEAT);
        this.simpleItem(ModItems.RAW_DODO_MEAT);
        this.simpleItem(ModItems.DODO_FEATHER);
        this.simpleItem(ModItems.MAGIGIANS_BOOK);
        this.simpleItem(ModItems.NAUTILUS_BUCKET);
        this.simpleItem(ModItems.CONESHELL_BUCKET);
        this.simpleItem(ModItems.ARTHROPOD_ARMOR);
        this.simpleItem(ModItems.SNIFFER_FUR);
        this.simpleItem(ModItems.BORSCH);
        this.simpleItem(ModItems.STRANIP);
        this.simpleItem(ModItems.STRANIP_LEAVES);
        this.simpleItem(ModItems.STRANIP_ROOT);
        this.simpleItem(ModItems.SNIFFER_BAG);
        this.simpleItem(ModItems.FLAMIPEDE_FANG);
        this.simpleItem(ModItems.SPICY_CLAW_SOUP);
        this.simpleItem(ModItems.CLAW_SOUP);
        this.withExistingParent(ModItems.GREATER_DODO_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.ANCIENT_ZOMBIE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.NAUTILUS_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.CONESHELL_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.AMPHIBIMUS_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.ARMISOR_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.EURYPTERUS_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent(ModItems.FLAMIPEDE_SPAWN_EGG.getId().m_135815_(), this.mcLoc("item/template_spawn_egg"));
        this.handheldItem(ModItems.BIOMIC_SHOVEL);
        this.handheldItem(ModItems.BIOMIC_SWORD);
        this.handheldItem(ModItems.BIOMIC_HOE);
        this.handheldItem(ModItems.BIOMIC_AXE);
        this.handheldItem(ModItems.BIOMIC_PICKAXE);
        this.handheldItem(ModItems.BROKEN_TRIDENT);
        this.simpleItem(ModItems.GINKGO_HANGING_SIGN);
        this.simpleItem(ModItems.GINKGO_SIGN);
        this.simpleItem(ModItems.GINKGO_BOAT);
        this.simpleItem(ModItems.GINKGO_CHEST_BOAT);
        this.simpleBlockItem(ModBlocks.GINKGO_DOOR);
        this.fenceItem(ModBlocks.GINKGO_FENCE, ModBlocks.GINKGO_PLANKS);
        this.buttonItem(ModBlocks.GINKGO_BUTTON, ModBlocks.GINKGO_PLANKS);
        this.evenSimplerBlockItem(ModBlocks.GINKGO_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.GINKGO_SLAB);
        this.evenSimplerBlockItem(ModBlocks.GINKGO_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.GINKGO_FENCE_GATE);
        this.trapdoorItem(ModBlocks.GINKGO_TRAPDOOR);
        this.simpleItem(ModItems.SPIKETIP_HANGING_SIGN);
        this.simpleItem(ModItems.SPIKETIP_SIGN);
        this.simpleItem(ModItems.SPIKETIP_BOAT);
        this.simpleItem(ModItems.SPIKETIP_CHEST_BOAT);
        this.simpleBlockItem(ModBlocks.SPIKETIP_DOOR);
        this.fenceItem(ModBlocks.SPIKETIP_FENCE, ModBlocks.SPIKETIP_PLANKS);
        this.buttonItem(ModBlocks.SPIKETIP_BUTTON, ModBlocks.SPIKETIP_PLANKS);
        this.evenSimplerBlockItem(ModBlocks.SPIKETIP_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.SPIKETIP_SLAB);
        this.evenSimplerBlockItem(ModBlocks.SPIKETIP_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.SPIKETIP_FENCE_GATE);
        this.trapdoorItem(ModBlocks.SPIKETIP_TRAPDOOR);
        this.simpleItem(ModItems.TREE_FERN_HANGING_SIGN);
        this.simpleItem(ModItems.TREE_FERN_SIGN);
        this.simpleItem(ModItems.TREE_FERN_BOAT);
        this.simpleItem(ModItems.TREE_FERN_CHEST_BOAT);
        this.simpleBlockItem(ModBlocks.TREE_FERN_DOOR);
        this.fenceItem(ModBlocks.TREE_FERN_FENCE, ModBlocks.TREE_FERN_PLANKS);
        this.buttonItem(ModBlocks.TREE_FERN_BUTTON, ModBlocks.TREE_FERN_PLANKS);
        this.evenSimplerBlockItem(ModBlocks.TREE_FERN_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.TREE_FERN_SLAB);
        this.evenSimplerBlockItem(ModBlocks.TREE_FERN_PRESSURE_PLATE);
        this.evenSimplerBlockItem(ModBlocks.TREE_FERN_FENCE_GATE);
        this.trapdoorItem(ModBlocks.TREE_FERN_TRAPDOOR);
        this.evenSimplerBlockItem(ModBlocks.BOULDERSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.BOULDERSTONE_SLAB);
        this.wallItem(ModBlocks.BOULDERSTONE_WALL, ModBlocks.BOULDERSTONE);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_POWDERSTONE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_POWDERSTONE_SLAB);
        this.wallItem(ModBlocks.POLISHED_POWDERSTONE_WALL, ModBlocks.POLISHED_POWDERSTONE);
        this.evenSimplerBlockItem(ModBlocks.BOULDERSTONE_BRICK_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.BOULDERSTONE_BRICK_SLAB);
        this.wallItem(ModBlocks.BOULDERSTONE_BRICK_WALL, ModBlocks.BOULDERSTONE_BRICKS);
        this.evenSimplerBlockItem(ModBlocks.CHLORITE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.CHLORITE_SLAB);
        this.wallItem(ModBlocks.CHLORITE_WALL, ModBlocks.CHLORITE);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_CHLORITE_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_CHLORITE_SLAB);
        this.wallItem(ModBlocks.POLISHED_CHLORITE_WALL, ModBlocks.POLISHED_CHLORITE);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_CHLORITE_BRICK_STAIRS);
        this.evenSimplerBlockItem(ModBlocks.POLISHED_CHLORITE_BRICK_SLAB);
        this.wallItem(ModBlocks.POLISHED_CHLORITE_BRICK_WALL, ModBlocks.POLISHED_CHLORITE_BRICKS);
        this.evenSimplerBlockItem(ModBlocks.PETRIFIED_WOOD);
        this.saplingItem(ModBlocks.GINKGO_SAPLING);
        this.saplingItem(ModBlocks.SPIKETIP_SAPLING);
        this.saplingItem(ModBlocks.TREE_FERN_SAPLING);
        this.trimmedArmorItem(ModItems.CHITIN_BOOTS);
        this.trimmedArmorItem(ModItems.CHITIN_CHESTPLATE);
        this.trimmedArmorItem(ModItems.CHITIN_HELMET);
        this.trimmedArmorItem(ModItems.CHITIN_LEGGINGS);
        this.trimmedArmorItem(ModItems.CHITIN_SEGMENT);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "silversnifferupgrade";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = new ResourceLocation("silversnifferupgrade", armorItemPath);
                ResourceLocation trimResLoc = new ResourceLocation(trimPath);
                ResourceLocation trimNameResLoc = new ResourceLocation("silversnifferupgrade", currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", new ResourceLocation("silversnifferupgrade", "item/" + itemRegistryObject.getId().m_135815_()));
            });
        }
    }

    private ItemModelBuilder saplingItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("silversnifferupgrade", "block/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("silversnifferupgrade", "item/" + item.getId().m_135815_()));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("silversnifferupgrade:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("silversnifferupgrade", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("silversnifferupgrade", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("silversnifferupgrade", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("silversnifferupgrade", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("silversnifferupgrade", "item/" + item.getId().m_135815_()));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

