/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.entity.custom;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.silverfishstone.silversnifferupgrade.entity.ModEntities;
import net.silverfishstone.silversnifferupgrade.entity.ai.AmphibimusAttackGoal;
import net.silverfishstone.silversnifferupgrade.entity.custom.NautilusEntity;

public class AmphibimusEntity
extends Animal {
    protected RandomStrollGoal randomStrollGoal;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(AmphibimusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Ingredient TEMPTATION_ITEM = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_});
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    public final AnimationState swimIdleAnimationState = new AnimationState();
    public final AnimationState crawlAnimationState = new AnimationState();

    public AmphibimusEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new AmphibiousControl(this);
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public int m_21529_() {
        return 35;
    }

    public int m_8085_() {
        return 5;
    }

    public boolean m_6040_() {
        return true;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.swimIdleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(50) + 50;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    @Nullable
    public AmphibimusEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AmphibimusEntity)((EntityType)ModEntities.AMPHIBIMUS.get()).m_20615_((Level)pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 0.05).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        this.randomStrollGoal = new RandomStrollGoal((PathfinderMob)this, 0.3, 80);
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)this.randomStrollGoal);
        this.randomStrollGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 0.2));
        this.f_21345_.m_25352_(9, (Goal)new BreedGoal((Animal)this, 1.15));
        this.f_21345_.m_25352_(8, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42580_}), false));
        this.f_21345_.m_25352_(10, (Goal)new AmphibimusAttackGoal(this, 0.3, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, NautilusEntity.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_20096_() {
        return super.m_20096_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_215690_;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_215693_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_215691_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_(SoundEvents.f_215696_, 0.15f, 1.0f);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(1.0f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.3));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return TEMPTATION_ITEM.test(pStack);
    }

    public static boolean checkSalamanderSpawnRules(EntityType<? extends Animal> salamander, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_144283_) && AmphibimusEntity.m_186209_((BlockAndTintGetter)pLevel, (BlockPos)pPos);
    }

    static class AmphibiousControl
    extends MoveControl {
        private final AmphibimusEntity amphibimus;

        AmphibiousControl(AmphibimusEntity pTurtle) {
            super((Mob)pTurtle);
            this.amphibimus = pTurtle;
        }

        private void updateSpeed() {
            if (this.amphibimus.m_20069_()) {
                this.amphibimus.m_20256_(this.amphibimus.m_20184_().m_82520_(0.0, 0.005, 0.0));
            } else if (this.amphibimus.m_20096_()) {
                this.amphibimus.m_7910_(Math.max(this.amphibimus.m_6113_() + 0.04f, 0.2f));
            }
        }

        public void m_8126_() {
            if (this.amphibimus.m_20096_()) {
                this.updateSpeed();
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.amphibimus.m_21573_().m_26571_()) {
                    double d2;
                    double d1;
                    double d0 = this.f_24975_ - this.amphibimus.m_20185_();
                    double d3 = Math.sqrt(d0 * d0 + (d1 = this.f_24976_ - this.amphibimus.m_20186_()) * d1 + (d2 = this.f_24977_ - this.amphibimus.m_20189_()) * d2);
                    if (d3 < (double)1.0E-5f) {
                        this.f_24974_.m_7910_(0.0f);
                    } else {
                        d1 /= d3;
                        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                        this.amphibimus.m_146922_(this.m_24991_(this.amphibimus.m_146908_(), f, 90.0f));
                        this.amphibimus.f_20883_ = this.amphibimus.m_146908_();
                        float f1 = (float)(this.f_24978_ * this.amphibimus.m_21133_(Attributes.f_22279_));
                        this.amphibimus.m_7910_(Mth.m_14179_((float)0.125f, (float)this.amphibimus.m_6113_(), (float)f1));
                        this.amphibimus.m_20256_(this.amphibimus.m_20184_().m_82520_(0.0, (double)this.amphibimus.m_6113_() * d1 * 0.1, 0.0));
                    }
                } else {
                    this.amphibimus.m_7910_(0.0f);
                }
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.amphibimus.m_21573_().m_26571_()) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.amphibimus.m_20185_(), this.f_24976_ - this.amphibimus.m_20186_(), this.f_24977_ - this.amphibimus.m_20189_());
                double d0 = vec3.m_82553_();
                double d1 = vec3.f_82479_ / d0;
                double d2 = vec3.f_82480_ / d0;
                double d3 = vec3.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.2957763671875) - 90.0f;
                this.amphibimus.m_146922_(this.m_24991_(this.amphibimus.m_146908_(), f, 90.0f));
                this.amphibimus.f_20883_ = this.amphibimus.m_146908_();
                float f1 = (float)(this.f_24978_ * this.amphibimus.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.amphibimus.m_6113_(), (float)f1);
                this.amphibimus.m_7910_(f2);
                double d4 = Math.sin((double)(this.amphibimus.f_19797_ + this.amphibimus.m_19879_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.amphibimus.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.amphibimus.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.amphibimus.f_19797_ + this.amphibimus.m_19879_()) * 0.75) * 0.05;
                this.amphibimus.m_20256_(this.amphibimus.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontrol = this.amphibimus.m_21563_();
                double d8 = this.amphibimus.m_20185_() + d1 * 2.0;
                double d9 = this.amphibimus.m_20188_() + d2 / d0;
                double d10 = this.amphibimus.m_20189_() + d3 * 2.0;
                double d11 = lookcontrol.m_24969_();
                double d12 = lookcontrol.m_24970_();
                double d13 = lookcontrol.m_24971_();
                if (!lookcontrol.m_186069_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.amphibimus.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
            } else {
                this.amphibimus.m_7910_(0.0f);
            }
        }
    }
}

