/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.entity.custom;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.silverfishstone.silversnifferupgrade.entity.ModEntities;
import net.silverfishstone.silversnifferupgrade.entity.custom.NautilusEntity;
import org.jetbrains.annotations.Nullable;

public class ArmisorEntity
extends Monster
implements Enemy {
    protected static final int ATTACK_TIME = 80;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(ArmisorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_MOVING = SynchedEntityData.m_135353_(ArmisorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_ATTACK_TARGET = SynchedEntityData.m_135353_(ArmisorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float clientSideSwimAnimation;
    private float clientSideSwimAnimationSpeed;
    public int posPointer = -1;
    public final double[][] positions = new double[64][3];
    @javax.annotation.Nullable
    private LivingEntity clientSideCachedAttackTarget;
    private int clientSideAttackTime;
    private boolean clientSideTouchedGround;
    @javax.annotation.Nullable
    protected RandomStrollGoal randomStrollGoal;
    public float yRotA;
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public static final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;
    @Nullable
    private Player unlimitedLastHurtByPlayer = null;
    public final AnimationState swimIdleAnimationState = new AnimationState();

    public ArmisorEntity(EntityType<? extends ArmisorEntity> pEntityType, Level pLevel) {
        super((EntityType)ModEntities.ARMISOR.get(), pLevel);
        this.f_21364_ = 10;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new ArmisorMoveControl(this);
        this.clientSideSwimAnimation = this.f_19796_.m_188501_();
        this.m_21153_(this.m_21233_());
    }

    float onHurt(DamageSource pDamageSource, float pAmount) {
        return 5.0f;
    }

    protected void m_8099_() {
        this.randomStrollGoal = new RandomStrollGoal((PathfinderMob)this, 1.0, 80);
        this.f_21345_.m_25352_(4, (Goal)new ArmisorAttackGoal(this, 2.0, true));
        this.f_21345_.m_25352_(7, (Goal)this.randomStrollGoal);
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.randomStrollGoal.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, NautilusEntity.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean okTarget(@javax.annotation.Nullable LivingEntity p_32396_) {
        if (p_32396_ != null) {
            return p_32396_.m_20069_();
        }
        return false;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.swimIdleAnimationState.m_246184_(this.m_20072_() && !this.f_267362_.m_267780_(), this.f_19797_);
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(50) + 50;
            idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_MOVING, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_ATTACK_TARGET, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 60.0);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_MOVING);
    }

    void setMoving(boolean pMoving) {
        this.f_19804_.m_135381_(DATA_ID_MOVING, (Object)pMoving);
    }

    public int getAttackDuration() {
        return 80;
    }

    public boolean hasActiveAttackTarget() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET) != 0;
    }

    @javax.annotation.Nullable
    public LivingEntity getActiveAttackTarget() {
        if (!this.hasActiveAttackTarget()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            if (this.clientSideCachedAttackTarget != null) {
                return this.clientSideCachedAttackTarget;
            }
            Entity entity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(DATA_ID_ATTACK_TARGET)).intValue());
            if (entity instanceof LivingEntity) {
                this.clientSideCachedAttackTarget = (LivingEntity)entity;
                return this.clientSideCachedAttackTarget;
            }
            return null;
        }
        return this.m_5448_();
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return pLevel.m_6425_(pPos).m_205070_(FluidTags.f_13131_) ? 10.0f + pLevel.m_220419_(pPos) : super.m_5610_(pPos, pLevel);
    }

    public void m_8107_() {
        if (this.f_20888_ != null) {
            this.unlimitedLastHurtByPlayer = this.f_20888_;
        }
        if (this.unlimitedLastHurtByPlayer != null && this.unlimitedLastHurtByPlayer.m_213877_()) {
            this.unlimitedLastHurtByPlayer = null;
        }
        if (this.m_21224_()) {
            this.swimIdleAnimationState.m_216977_(this.f_19797_);
        } else if (this.m_21525_()) {
            this.swimIdleAnimationState.m_216977_(this.f_19797_);
        } else {
            if (this.m_9236_().f_46443_) {
                if (!this.m_20069_()) {
                    this.clientSideSwimAnimationSpeed = 2.0f;
                    Vec3 vec3 = this.m_20184_();
                    if (vec3.f_82480_ > 0.0 && this.clientSideTouchedGround && !this.m_20067_()) {
                        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getFlopSound(), this.m_5720_(), 1.0f, 1.0f, false);
                    }
                    this.clientSideTouchedGround = vec3.f_82480_ < 0.0 && this.m_9236_().m_46575_(this.m_20183_().m_7495_(), (Entity)this);
                } else if (this.isMoving()) {
                    this.swimIdleAnimationState.m_216977_(this.f_19797_);
                } else {
                    this.clientSideSwimAnimationSpeed += (0.125f - this.clientSideSwimAnimationSpeed) * 0.2f;
                }
                this.clientSideSwimAnimation += this.clientSideSwimAnimationSpeed;
                if (this.isMoving() && this.m_20069_()) {
                    Vec3 vec31 = this.m_20252_(0.0f);
                    for (int i = 0; i < 2; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5) - vec31.f_82479_ * 1.5, this.m_20187_() - vec31.f_82480_ * 1.5, this.m_20262_(0.5) - vec31.f_82481_ * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.hasActiveAttackTarget()) {
                    LivingEntity livingentity;
                    if (this.clientSideAttackTime < this.getAttackDuration()) {
                        ++this.clientSideAttackTime;
                    }
                    if ((livingentity = this.getActiveAttackTarget()) != null) {
                        this.m_21563_().m_24960_((Entity)livingentity, 90.0f, 90.0f);
                        this.m_21563_().m_8128_();
                        double d5 = this.getAttackAnimationScale(0.0f);
                        double d0 = livingentity.m_20185_() - this.m_20185_();
                        double d1 = livingentity.m_20227_(0.5) - this.m_20188_();
                        double d2 = livingentity.m_20189_() - this.m_20189_();
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.f_19796_.m_188500_();
                        while (d4 < d3) {
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + d0 * (d4 += 1.8 - d5 + this.f_19796_.m_188500_() * (1.7 - d5)), this.m_20188_() + d1 * d4, this.m_20189_() + d2 * d4, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.m_20072_()) {
                this.m_20301_(300);
            } else if (this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.4f)));
                this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
                this.m_6853_(false);
                this.f_19812_ = true;
            }
            if (this.hasActiveAttackTarget()) {
                this.m_146922_(this.f_20885_);
            }
        }
        super.m_8107_();
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_12004_;
    }

    public float getSwimAnimation(float pPartialTick) {
        return Mth.m_14179_((float)pPartialTick, (float)this.swimIdleAnimationState.m_216981_(), (float)this.swimIdleAnimationState.m_216981_());
    }

    public float getAttackAnimationScale(float pPartialTick) {
        return ((float)this.clientSideAttackTime + pPartialTick) / (float)this.getAttackDuration();
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public int m_8132_() {
        return 5;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(0.1f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMoving() && this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (DATA_ID_ATTACK_TARGET.equals(pKey)) {
            this.clientSideAttackTime = 0;
            this.clientSideCachedAttackTarget = null;
        }
    }

    public int m_8100_() {
        return 160;
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? SoundEvents.f_11999_ : SoundEvents.f_12000_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.m_20072_() ? SoundEvents.f_12005_ : SoundEvents.f_12006_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? SoundEvents.f_12002_ : SoundEvents.f_12003_;
    }

    static class ArmisorMoveControl
    extends MoveControl {
        private final ArmisorEntity armisor;

        public ArmisorMoveControl(ArmisorEntity armisor) {
            super((Mob)armisor);
            this.armisor = armisor;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.armisor.m_21573_().m_26571_()) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.armisor.m_20185_(), this.f_24976_ - this.armisor.m_20186_(), this.f_24977_ - this.armisor.m_20189_());
                double d0 = vec3.m_82553_();
                double d1 = vec3.f_82479_ / d0;
                double d2 = vec3.f_82480_ / d0;
                double d3 = vec3.f_82481_ / d0;
                float f = (float)(Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.2957763671875) - 90.0f;
                this.armisor.m_146922_(this.m_24991_(this.armisor.m_146908_(), f, 90.0f));
                this.armisor.f_20883_ = this.armisor.m_146908_();
                float f1 = (float)(this.f_24978_ * this.armisor.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.armisor.m_6113_(), (float)f1);
                this.armisor.m_7910_(f2);
                double d4 = Math.sin((double)(this.armisor.f_19797_ + this.armisor.m_19879_()) * 0.5) * 0.05;
                double d5 = Math.cos(this.armisor.m_146908_() * ((float)Math.PI / 180));
                double d6 = Math.sin(this.armisor.m_146908_() * ((float)Math.PI / 180));
                double d7 = Math.sin((double)(this.armisor.f_19797_ + this.armisor.m_19879_()) * 0.75) * 0.05;
                this.armisor.m_20256_(this.armisor.m_20184_().m_82520_(d4 * d5, d7 * (d6 + d5) * 0.25 + (double)f2 * d2 * 0.1, d4 * d6));
                LookControl lookcontrol = this.armisor.m_21563_();
                double d8 = this.armisor.m_20185_() + d1 * 2.0;
                double d9 = this.armisor.m_20188_() + d2 / d0;
                double d10 = this.armisor.m_20189_() + d3 * 2.0;
                double d11 = lookcontrol.m_24969_();
                double d12 = lookcontrol.m_24970_();
                double d13 = lookcontrol.m_24971_();
                if (!lookcontrol.m_186069_()) {
                    d11 = d8;
                    d12 = d9;
                    d13 = d10;
                }
                this.armisor.m_21563_().m_24950_(Mth.m_14139_((double)0.125, (double)d11, (double)d8), Mth.m_14139_((double)0.125, (double)d12, (double)d9), Mth.m_14139_((double)0.125, (double)d13, (double)d10), 10.0f, 40.0f);
                this.armisor.setMoving(true);
            } else {
                this.armisor.m_7910_(0.0f);
                this.armisor.setMoving(false);
                idleAnimationState.m_216973_();
            }
        }
    }

    static class ArmisorAttackGoal
    extends MeleeAttackGoal {
        private final ArmisorEntity armisor;

        public ArmisorAttackGoal(ArmisorEntity armisor, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)armisor, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.armisor = armisor;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.armisor.okTarget(this.armisor.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.armisor.okTarget(this.armisor.m_5448_());
        }
    }
}

