/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.entity.custom;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.silverfishstone.silversnifferupgrade.entity.ModEntities;
import net.silverfishstone.silversnifferupgrade.item.ModItems;
import org.jetbrains.annotations.NotNull;

public class ConeshellEntity
extends Animal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(ConeshellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_, Items.f_42526_, Items.f_42527_});
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;

    public ConeshellEntity(EntityType<? extends ConeshellEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new NautilusControl(this);
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader pLevel) {
        return pLevel.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    public boolean m_6063_() {
        return false;
    }

    protected void handleAirSupply(int pAirSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(pAirSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new WaterBoundPathNavigation((Mob)this, pLevel);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_216990_(SoundEvents.f_12438_);
        }
        super.m_8107_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(50) + 50;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(3, (Goal)new NautilusSwimGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.3, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return this.m_6162_() ? pSize.f_20378_ * 0.2f : pSize.f_20378_ * 0.4f;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return Bucketable.m_148828_((Player)pPlayer, (InteractionHand)pHand, (LivingEntity)this).orElse(super.m_6071_(pPlayer, pHand));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(ItemStack pStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)pStack);
    }

    public void m_142278_(CompoundTag pTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)pTag);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_27497_(pCompound.m_128471_("FromBucket"));
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ModItems.CONESHELL_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    @Nullable
    public ConeshellEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (ConeshellEntity)((EntityType)ModEntities.CONESHELL.get()).m_20615_((Level)pLevel);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    static class NautilusControl
    extends MoveControl {
        private final ConeshellEntity nautilus;

        NautilusControl(ConeshellEntity pFish) {
            super((Mob)pFish);
            this.nautilus = pFish;
        }

        public void m_8126_() {
            if (this.nautilus.m_204029_(FluidTags.f_13131_)) {
                this.nautilus.m_20256_(this.nautilus.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.nautilus.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.nautilus.m_21133_(Attributes.f_22279_));
                this.nautilus.m_7910_(Mth.m_14179_((float)0.125f, (float)this.nautilus.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.nautilus.m_20185_();
                double d1 = this.f_24976_ - this.nautilus.m_20186_();
                double d2 = this.f_24977_ - this.nautilus.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.nautilus.m_20256_(this.nautilus.m_20184_().m_82520_(0.0, (double)this.nautilus.m_6113_() * (d1 / d3) * 0.2, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.nautilus.m_146922_(this.m_24991_(this.nautilus.m_146908_(), f1, 90.0f));
                    this.nautilus.f_20883_ = this.nautilus.m_146908_();
                }
            } else {
                this.nautilus.m_7910_(0.3f);
            }
        }
    }

    static class NautilusSwimGoal
    extends RandomSwimmingGoal {
        private final ConeshellEntity nautilus;

        public NautilusSwimGoal(ConeshellEntity pFish) {
            super((PathfinderMob)pFish, 1.0, 40);
            this.nautilus = pFish;
        }

        public boolean m_8036_() {
            return this.nautilus.canRandomSwim() && super.m_8036_();
        }
    }
}

