/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.entity.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.silverfishstone.silversnifferupgrade.entity.ai.FlamipedeAttackGoal;

public class FlamipedeEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(FlamipedeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final AnimationState attackAnimationState = new AnimationState();
    public int attackAnimationTimeout = 0;
    public final AnimationState idleAnimationState = new AnimationState();
    public int idleAnimationTimeout = 0;

    public FlamipedeEntity(EntityType<? extends FlamipedeEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new FlamipedeAttackGoal(this, 1.0, false));
        super.m_8099_();
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        super.m_8119_();
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.f_19796_.m_188503_(50) + 50;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isAttacking() && this.attackAnimationTimeout <= 0) {
            this.attackAnimationTimeout = 20;
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.attackAnimationTimeout;
        }
        if (!this.isAttacking()) {
            this.attackAnimationState.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12559_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12435_;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 1.0f;
    }

    public boolean m_7327_(Entity pEntity) {
        if (!super.m_7327_(pEntity)) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            ((LivingEntity)pEntity).m_20254_(3);
        }
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public static boolean checkSpawnRules(EntityType<? extends PathfinderMob> pMob, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return FlamipedeEntity.isBrightEnoughToSpawn((BlockAndTintGetter)pLevel, pPos);
    }

    protected static boolean isBrightEnoughToSpawn(BlockAndTintGetter pLevel, BlockPos pPos) {
        return pLevel.m_45524_(pPos, 0) > 4;
    }
}

