/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.entity.custom;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.silverfishstone.silversnifferupgrade.block.ModBlocks;
import net.silverfishstone.silversnifferupgrade.block.custom.FloatingBlock;
import net.silverfishstone.silversnifferupgrade.block.properties.Floatable;
import net.silverfishstone.silversnifferupgrade.entity.ModEntities;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class FloatingBlockEntity
extends Entity {
    private BlockState blockState = ((Block)ModBlocks.PUMICE.get()).m_49966_();
    private boolean cancelDrop;
    private static final Logger LOGGER = LogUtils.getLogger();
    public int time;
    public boolean dropItem = true;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    private FloatingBlockEntity(Level pLevel, double pX, double pY, double pZ, BlockState pState) {
        this((EntityType<? extends FloatingBlockEntity>)((EntityType)ModEntities.FLOATING_BLOCK.get()), pLevel);
        this.blockState = pState;
        this.f_19850_ = true;
        this.m_6034_(pX, pY, pZ);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
        this.setStartPos(this.m_20183_());
    }

    public static FloatingBlockEntity setFloat(Level pLevel, BlockPos pPos, BlockState pBlockState) {
        FloatingBlockEntity floatingBlockEntity = new FloatingBlockEntity(pLevel, (double)pPos.m_123341_() + 0.5, pPos.m_123342_(), (double)pPos.m_123343_() + 0.5, pBlockState.m_61138_((Property)BlockStateProperties.f_61362_) ? (BlockState)pBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)) : pBlockState);
        pLevel.m_7731_(pPos, pBlockState.m_60819_().m_76188_(), 3);
        pLevel.m_7967_((Entity)floatingBlockEntity);
        return floatingBlockEntity;
    }

    public void disableDrop() {
        this.cancelDrop = true;
    }

    @NotNull
    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.blockState);
        if (blockstate == null) {
            this.cancelDrop = true;
        } else {
            this.blockState = blockstate;
        }
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public void setStartPos(BlockPos pStartPos) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pStartPos);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        if (this.blockState.m_60795_()) {
            this.m_146870_();
        } else {
            Block block = this.blockState.m_60734_();
            ++this.time;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.m_9236_().f_46443_) {
                BlockPos blockpos = this.m_20183_();
                BlockState blockstateE = this.m_9236_().m_8055_(blockpos.m_6630_(1));
                if (blockstateE.m_60713_(Blocks.f_49990_)) {
                    if (!(this.m_9236_().f_46443_ || (this.time <= 100 || blockpos.m_123342_() > this.m_9236_().m_141937_() && blockpos.m_123342_() <= this.m_9236_().m_151558_()) && this.time <= 600)) {
                        if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19998_((ItemLike)block);
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockstate.m_60713_(Blocks.f_50110_)) {
                        if (!this.cancelDrop) {
                            boolean flag4;
                            boolean flag3 = FloatingBlock.isFloating(this.m_9236_().m_8055_(blockpos.m_7494_()));
                            boolean bl = flag4 = this.blockState.m_60710_((LevelReader)this.m_9236_(), blockpos) && !flag3;
                            if (flag4) {
                                if (this.blockState.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockpos).m_76152_() == Fluids.f_76193_) {
                                    this.blockState = (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.m_9236_().m_7731_(blockpos, this.blockState, 3)) {
                                    BlockEntity blockentity;
                                    ((ServerLevel)this.m_9236_()).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockpos, this.m_9236_().m_8055_(blockpos)));
                                    this.m_146870_();
                                    if (block instanceof Floatable) {
                                        ((Floatable)block).inWater(this.m_9236_(), blockpos, this.blockState, blockstate, this);
                                    }
                                    if (this.blockData != null && this.blockState.m_155947_() && (blockentity = this.m_9236_().m_7702_(blockpos)) != null) {
                                        CompoundTag compoundtag = blockentity.m_187482_();
                                        for (String s : this.blockData.m_128431_()) {
                                            compoundtag.m_128365_(s, this.blockData.m_128423_(s).m_6426_());
                                        }
                                        try {
                                            blockentity.m_142466_(compoundtag);
                                        }
                                        catch (Exception exception) {
                                            LOGGER.error("Failed to load block entity from floating block", (Throwable)exception);
                                        }
                                        blockentity.m_6596_();
                                    }
                                } else if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.callOnBrokenAfterFloat(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            } else {
                                this.m_146870_();
                                if (this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.callOnBrokenAfterFloat(block, blockpos);
                                    this.m_19998_((ItemLike)block);
                                }
                            }
                        } else {
                            this.m_146870_();
                            this.callOnBrokenAfterFloat(block, blockpos);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public void callOnBrokenAfterFloat(Block pBlock, BlockPos pPos) {
        if (pBlock instanceof Floatable) {
            ((Floatable)pBlock).onBrokenAfterFloat(this.m_9236_(), pPos, this);
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        pCompound.m_128405_("Time", this.time);
        pCompound.m_128379_("DropItem", this.dropItem);
        pCompound.m_128379_("HurtEntities", this.hurtEntities);
        pCompound.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        pCompound.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            pCompound.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        pCompound.m_128379_("CancelDrop", this.cancelDrop);
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)pCompound.m_128469_("BlockState"));
        this.time = pCompound.m_128451_("Time");
        if (pCompound.m_128425_("DropItem", 99)) {
            this.dropItem = pCompound.m_128471_("DropItem");
        }
        if (pCompound.m_128425_("TileEntityData", 10)) {
            this.blockData = pCompound.m_128469_("TileEntityData");
        }
        this.cancelDrop = pCompound.m_128471_("CancelDrop");
        if (this.blockState.m_60713_(Blocks.f_49990_)) {
            this.blockState = ((Block)ModBlocks.PUMICE.get()).m_49966_();
        }
    }
}

