/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.silverfishstone.silversnifferupgrade.item.ModItems;

public class CrabClaw
extends SwordItem {
    protected static final UUID BASE_ATTACK_REACH_DAMAGE_UUID = UUID.fromString("CB7F77D3-777C-4F78-A497-9C13A33DB5CF");
    protected static final UUID BASE_MINE_REACH_DAMAGE_UUID = UUID.fromString("FA777E7C-7777-7777-B01B-BCCE9785ACA3");
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final float attackreach;
    private final float minereach;

    public CrabClaw(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, float pAttackReach, float pMineReach, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        this.attackreach = pAttackReach;
        this.minereach = pMineReach;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ATTACK_REACH_DAMAGE_UUID, "Weapon modifier", (double)this.attackreach, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(BASE_MINE_REACH_DAMAGE_UUID, "Weapon modifier", (double)this.minereach, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getAttackReach() {
        return this.attackreach;
    }

    public float getMineReach() {
        return this.minereach;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pToRepair.m_150930_((Item)ModItems.TROPICAL_CRAB_CLAW.get()) ? pRepair.m_150930_((Item)ModItems.TROPICAL_CRAB_CLAW.get()) : pRepair.m_150930_((Item)ModItems.ROASTED_TROPICAL_CRAB_CLAW.get());
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND || pEquipmentSlot == EquipmentSlot.OFFHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        if (pState.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return pState.m_204336_(BlockTags.f_278398_) ? 1.5f : 1.0f;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(2, pEntityLiving, p_43276_ -> p_43276_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_60713_(Blocks.f_50033_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }
}

