/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.DarkOakTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.silverfishstone.silversnifferupgrade.block.ModBlocks;
import net.silverfishstone.silversnifferupgrade.util.ModTags;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.GreatCaneFoliagePlacer;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.PetrifiedLogPlacer;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.PetrifiedTrunkPlacer;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.SpiketipFoliagePlacer;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.TreeFernFoliagePlacer;
import net.silverfishstone.silversnifferupgrade.worldgen.tree.custom.TreeFernTrunkPlacer;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_FIELDS_BIOMITE_ORE_KEY = ModConfiguredFeatures.registerKey("biomite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GINKGO_KEY = ModConfiguredFeatures.registerKey("ginkgo_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GREAT_CANE_KEY = ModConfiguredFeatures.registerKey("great_cane_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LARGE_GINKGO_KEY = ModConfiguredFeatures.registerKey("large_ginkgo_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIKETIP_KEY = ModConfiguredFeatures.registerKey("spiketip_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TREE_FERN_KEY = ModConfiguredFeatures.registerKey("tree_fern_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PETRIFIED_TREE_KEY = ModConfiguredFeatures.registerKey("petrified_tree_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> PETRIFIED_LOG_KEY = ModConfiguredFeatures.registerKey("petrified_log_key");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SAND_FOREST_PATCH = ModConfiguredFeatures.registerKey("sand_forest_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> STRANIP_FLOWER_PATCH = ModConfiguredFeatures.registerKey("stranip_flower_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CRATERWEED_PATCH = ModConfiguredFeatures.registerKey("craterweed_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ANCIENT_FIELDS_GRASS = ModConfiguredFeatures.registerKey("ancient_fields_grass_patch");
    public static final ResourceKey<ConfiguredFeature<?, ?>> CHLORITE_ORE = ModConfiguredFeatures.registerKey("chlorite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MAGMA_DELTA = ModConfiguredFeatures.registerKey("magma_delta");

    private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int pTries) {
        return FeatureUtils.m_206470_((int)pTries, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest boulderstoneReplaceable = new TagMatchTest(ModTags.Blocks.BOULDERSTONE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> ancientFieldBiomiteOres = List.of(OreConfiguration.m_161021_((RuleTest)boulderstoneReplaceable, (BlockState)((Block)ModBlocks.BIOMITE_ORE.get()).m_49966_()));
        ModConfiguredFeatures.register(context, ANCIENT_FIELDS_BIOMITE_ORE_KEY, Feature.f_65731_, new OreConfiguration(ancientFieldBiomiteOres, 10));
        ModConfiguredFeatures.register(context, GINKGO_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GINKGO_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(3, 3, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GINKGO_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(0, 0, 1)).m_68251_());
        ModConfiguredFeatures.register(context, LARGE_GINKGO_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GINKGO_LOG.get())), (TrunkPlacer)new DarkOakTrunkPlacer(5, 4, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GINKGO_LEAVES.get())), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_());
        ModConfiguredFeatures.register(context, SPIKETIP_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SPIKETIP_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(5, 4, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.SPIKETIP_LEAVES.get())), (FoliagePlacer)new SpiketipFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_());
        ModConfiguredFeatures.register(context, TREE_FERN_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.TREE_FERN_STEM.get())), (TrunkPlacer)new TreeFernTrunkPlacer(1, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.TREE_FERN_LEAVES.get())), (FoliagePlacer)new TreeFernFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)2), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_());
        ModConfiguredFeatures.register(context, GREAT_CANE_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GREAT_CANE_LOG.get())), (TrunkPlacer)new StraightTrunkPlacer(9, 4, 3), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.GREAT_CANE_LEAVES.get())), (FoliagePlacer)new GreatCaneFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)1), 4), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_());
        ModConfiguredFeatures.register(context, PETRIFIED_TREE_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.PETRIFIED_LOG.get())), (TrunkPlacer)new PetrifiedTrunkPlacer(1, 1, 1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (FoliagePlacer)new TreeFernFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)2), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68251_());
        ModConfiguredFeatures.register(context, PETRIFIED_LOG_KEY, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.PETRIFIED_LOG.get())), (TrunkPlacer)new PetrifiedLogPlacer(1, 2, 0), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (FoliagePlacer)new TreeFernFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)2), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1)).m_68251_());
        FeatureUtils.m_254977_(context, SAND_FOREST_PATCH, (Feature)Feature.f_65763_, (FeatureConfiguration)FeatureUtils.m_206473_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_49992_))));
        FeatureUtils.m_254977_(context, STRANIP_FLOWER_PATCH, (Feature)Feature.f_65763_, (FeatureConfiguration)ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.STRANIP_FLOWER.get())), 5));
        FeatureUtils.m_254977_(context, CRATERWEED_PATCH, (Feature)Feature.f_65763_, (FeatureConfiguration)ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ModBlocks.CRATERWEED.get())), 21));
        FeatureUtils.m_254977_(context, ANCIENT_FIELDS_GRASS, (Feature)Feature.f_65763_, (FeatureConfiguration)ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50034_), 32));
        FeatureUtils.m_254977_(context, CHLORITE_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration((RuleTest)boulderstoneReplaceable, ((Block)ModBlocks.CHLORITE.get()).m_49966_(), 64));
        FeatureUtils.m_254977_(context, MAGMA_DELTA, (Feature)Feature.f_65748_, (FeatureConfiguration)new DeltaFeatureConfiguration(Blocks.f_50450_.m_49966_(), Blocks.f_50450_.m_49966_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7), (IntProvider)UniformInt.m_146622_((int)0, (int)2)));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

