/*
 * Decompiled with CFR 0.152.
 */
package net.silverfishstone.silversnifferupgrade.worldgen.biome;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.silverfishstone.silversnifferupgrade.entity.ModEntities;
import net.silverfishstone.silversnifferupgrade.worldgen.ModPlacedFeatures;
import net.silverfishstone.silversnifferupgrade.worldgen.feature.SUBiomeDefaultFeatures;

public class ModBiomes {
    public static final ResourceKey<Biome> ANCIENT_GINKGO_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "ancient_ginkgo_forest"));
    public static final ResourceKey<Biome> LITTLE_MOUNTAINS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "little_mountains"));
    public static final ResourceKey<Biome> ANCIENT_JUNGLE = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "ancient_jungle"));
    public static final ResourceKey<Biome> PETRIFIED_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "petrified_forest"));
    public static final ResourceKey<Biome> PRIMAL_OCEAN = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "primal_ocean"));
    public static final ResourceKey<Biome> MYSTERIOUS_SEA = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "mysterious_sea"));
    public static final ResourceKey<Biome> RUMBLING_PEAKS = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "rumbling_ridges"));
    public static final ResourceKey<Biome> GREAT_CANE_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("silversnifferupgrade", "great_cane_forest"));

    public static void bootstrap(BootstapContext<Biome> context) {
        context.m_255272_(ANCIENT_GINKGO_FOREST, (Object)ModBiomes.ancientGinkgoForest(context));
        context.m_255272_(LITTLE_MOUNTAINS, (Object)ModBiomes.littleMountains(context));
        context.m_255272_(ANCIENT_JUNGLE, (Object)ModBiomes.ancientJungle(context));
        context.m_255272_(PETRIFIED_FOREST, (Object)ModBiomes.petrifiedForest(context));
        context.m_255272_(PRIMAL_OCEAN, (Object)ModBiomes.primalOcean(context));
        context.m_255272_(MYSTERIOUS_SEA, (Object)ModBiomes.mysteriousSea(context));
        context.m_255272_(RUMBLING_PEAKS, (Object)ModBiomes.rumblingPeaks(context));
        context.m_255272_(GREAT_CANE_FOREST, (Object)ModBiomes.greatCaneForest(context));
    }

    public static void globalAncientFieldsGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome ancientGinkgoForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GREATERDODO.get(), 5, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_271264_, 5, 1, 3));
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126826_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.GINKGO_PLACED_KEY);
        SUBiomeDefaultFeatures.addStranipFlowers(biomeBuilder);
        SUBiomeDefaultFeatures.addAFGrass(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.LARGE_GINKGO_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195452_);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SPIKETIP_PLACED_KEY);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(9361396).m_48037_(7060958).m_48045_(4704546).m_48043_(4704546).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome ancientJungle(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GREATERDODO.get(), 5, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 2, 1, 2));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_271264_, 5, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.NAUTILUS.get(), 1, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 3, 2, 6));
        spawnBuilder.m_48376_(MobCategory.MISC, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.AMPHIBIMUS.get(), 10, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TREE_FERN_PLACED_KEY);
        BiomeDefaultFeatures.m_126836_((BiomeGenerationSettings.Builder)biomeBuilder);
        SUBiomeDefaultFeatures.addStranipFlowers(biomeBuilder);
        SUBiomeDefaultFeatures.addAFGrass(biomeBuilder);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(718296).m_48037_(1893579).m_48045_(53781).m_48043_(53781).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome littleMountains(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GREATERDODO.get(), 5, 3, 5));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        SUBiomeDefaultFeatures.addStranipFlowers(biomeBuilder);
        SUBiomeDefaultFeatures.addAFGrass(biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(20670).m_48037_(25321).m_48045_(1412701).m_48043_(897104).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome petrifiedForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 5, 1, 3));
        BiomeDefaultFeatures.m_126800_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126816_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.SAND_FOREST_PATCH_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PETRIFIED_LOG_PLACED_KEY);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126747_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PETRIFIED_TREE_PLACED_KEY);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(20670).m_48037_(25321).m_48045_(1412701).m_48043_(897104).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome primalOcean(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)4, (int)2);
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.NAUTILUS.get(), 6, 1, 6));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.CONESHELL.get(), 6, 2, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.EURYPTERUS.get(), 3, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195219_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195227_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195230_);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126761_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(0x3AAEE3).m_48037_(5224440).m_48045_(3778914).m_48043_(3778914).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome mysteriousSea(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)4, (int)2);
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.NAUTILUS.get(), 6, 1, 6));
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.CONESHELL.get(), 6, 2, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.EURYPTERUS.get(), 3, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195219_);
        BiomeDefaultFeatures.m_126763_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126761_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(-0.5f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(0x442494).m_48037_(3226290).m_48045_(3778914).m_48043_(3778914).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome rumblingPeaks(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FLAMIPEDE.get(), 5, 1, 2));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.MAGMA_DELTA_PLACED);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.CRATERWEED_PATCH_PLACED);
        BiomeDefaultFeatures.m_126716_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(1.3f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(20670).m_48037_(25321).m_48045_(1412701).m_48043_(897104).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }

    public static Biome greatCaneForest(BootstapContext<Biome> context) {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GREATERDODO.get(), 5, 3, 5));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 2, 1, 2));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_271264_, 5, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.NAUTILUS.get(), 1, 1, 3));
        spawnBuilder.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 3, 2, 6));
        spawnBuilder.m_48376_(MobCategory.MISC, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.AMPHIBIMUS.get(), 10, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(context.m_255420_(Registries.f_256988_), context.m_255420_(Registries.f_257003_));
        ModBiomes.globalAncientFieldsGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126706_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ANCIENT_FIELDS_BIOMITE_ORE_PLACED_KEY);
        biomeBuilder.m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, ModPlacedFeatures.ORE_CHLORITE_PLACED);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TREE_FERN_PLACED_KEY);
        SUBiomeDefaultFeatures.addStranipFlowers(biomeBuilder);
        SUBiomeDefaultFeatures.addAFGrass(biomeBuilder);
        biomeBuilder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.GREAT_CANE_PLACED_KEY);
        BiomeDefaultFeatures.m_198927_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        return new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.8f).m_47609_(0.7f).m_47601_(biomeBuilder.m_255380_()).m_47605_(spawnBuilder.m_48381_()).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(718296).m_48037_(1893579).m_48045_(53781).m_48043_(53781).m_48019_(15333631).m_48040_(11787519).m_48027_(AmbientMoodSettings.f_47387_).m_48018_()).m_47592_();
    }
}

