/*
 * Decompiled with CFR 0.152.
 */
package net.hayden.distinctshields.datagen;

import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.hayden.distinctshields.items.VanillaItems;
import net.hayden.distinctshields.items.compats.DeeperDarkerItems;
import net.hayden.distinctshields.items.compats.NaturesSpiritItems;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ModLanguageGenerator
extends FabricLanguageProvider {
    private static final String[] DYE_COLORS = new String[]{"Red", "Orange", "Yellow", "Lime", "Green", "Light Blue", "Cyan", "Blue", "Purple", "Magenta", "Pink", "Brown", "White", "Light Gray", "Gray", "Dark Gray", "Black"};

    public ModLanguageGenerator(FabricDataOutput dataOutput) {
        super(dataOutput);
    }

    public static String generateItemDisplayName(class_1792 item) {
        class_2960 name = class_7923.field_41178.method_10221((Object)item);
        String itemName = name.method_12832();
        String[] parts = itemName.split("_");
        StringBuilder displayName = new StringBuilder();
        for (String part : parts) {
            displayName.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1)).append(" ");
        }
        return displayName.toString().trim();
    }

    private String generateItemDisplayName(class_1792 item, String color) {
        return color + " " + ModLanguageGenerator.generateItemDisplayName(item);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (class_1792 item : VanillaItems.MOD_SHIELDS.values()) {
            translationBuilder.add(item, ModLanguageGenerator.generateItemDisplayName(item));
            for (String color : DYE_COLORS) {
                translationBuilder.add("item.distinctshields." + String.valueOf(item) + "." + color.toLowerCase(), this.generateItemDisplayName(item, color));
            }
        }
        if (FabricLoader.getInstance().isModLoaded("natures_spirit")) {
            for (class_1792 item : NaturesSpiritItems.NS_SHIELDS.values()) {
                translationBuilder.add(item, ModLanguageGenerator.generateItemDisplayName(item));
                for (String color : DYE_COLORS) {
                    translationBuilder.add("item.distinctshields." + String.valueOf(item) + "." + color.toLowerCase(), this.generateItemDisplayName(item, color));
                }
            }
        }
        if (FabricLoader.getInstance().isModLoaded("deeperdarker")) {
            for (class_1792 item : DeeperDarkerItems.DD_SHIELDS.values()) {
                translationBuilder.add(item, ModLanguageGenerator.generateItemDisplayName(item));
                for (String color : DYE_COLORS) {
                    translationBuilder.add("item.distinctshields." + String.valueOf(item) + "." + color.toLowerCase(), this.generateItemDisplayName(item, color));
                }
            }
        }
        translationBuilder.add("distinctshields.resourcepacks", "Rename Shield to Oak");
        translationBuilder.add("distinctshields.item_group", "Distinct Shields");
        translationBuilder.add("distinctshields.cooldown", "Cooldown");
    }
}

