/*
 * Decompiled with CFR 0.152.
 */
package jpxl.atheneum.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.annotation.Serializer;
import blue.endless.jankson.api.SyntaxError;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class AtheneumConfig {
    public List<LibraryComponent> libraryComponents = new ArrayList<LibraryComponent>(List.of(new LibraryComponent(new HashSet<String>(Set.of("minecraft:bookshelf")), new LibraryBonuses().put(TableBonuses.maxPower, 1), ComponentCategories.bookshelf), new LibraryComponent(new HashSet<String>(Set.of("minecraft:lantern")), new LibraryBonuses().put(TableBonuses.insight, 3), ComponentCategories.artifact), new LibraryComponent(new HashSet<String>(Set.of("minecraft:soul_lantern")), new LibraryBonuses().put(TableBonuses.insight, 7), ComponentCategories.artifact), new LibraryComponent(new HashSet<String>(Set.of("minecraft:wither_skeleton_skull", "minecraft:wither_skeleton_wall_skull")), new LibraryBonuses().put(TableBonuses.chaos, 12), ComponentCategories.artifact), new LibraryComponent(new HashSet<String>(Set.of("minecraft:candle", "minecraft:white_candle", "minecraft:orange_candle", "minecraft:magenta_candle", "minecraft:light_blue_candle", "minecraft:yellow_candle", "minecraft:lime_candle", "minecraft:pink_candle", "minecraft:gray_candle", "minecraft:ligt_gray_candle", "minecraft:cyan_candle", "minecraft:purple_candle", "minecraft:blue_candle", "minecraft:brown_candle", "minecraft:green_candle", "minecraft:red_candle", "minecraft:black_candle")), new LibraryBonuses().put(TableBonuses.synergy, 3), ComponentCategories.artifact), new LibraryComponent(new HashSet<String>(Set.of("atheneum:oak_tomeshelf")), ComponentTypes.data, new LibraryBonuses(), ComponentCategories.tomeshelf)));
    public List<TomeBonus> tomeBonuses = new ArrayList<TomeBonus>(List.of(new TomeBonus(new HashSet<String>(Set.of("atheneum:ancient_tome")), new LibraryBonuses().put(TableBonuses.power, 3)), new TomeBonus(new HashSet<String>(Set.of("atheneum:dreamers_tome")), new LibraryBonuses().put(TableBonuses.insight, 3)), new TomeBonus(new HashSet<String>(Set.of("atheneum:verdant_tome")), new LibraryBonuses().put(TableBonuses.synergy, 3)), new TomeBonus(new HashSet<String>(Set.of("atheneum:shadowborne_tome")), new LibraryBonuses().put(TableBonuses.chaos, 3))));
    public List<Catalyst> catalysts = new ArrayList<Catalyst>(List.of(new Catalyst(new HashSet<String>(Set.of("minecraft:lapis_lazuli")), new LibraryBonuses()), new Catalyst(new HashSet<String>(Set.of("atheneum:lapis_tenebris")), new LibraryBonuses().put(TableBonuses.canCurselift, true))));

    public static AtheneumConfig loadConfig() {
        Jankson jankson = Jankson.builder().build();
        try {
            File configFile = new File(FabricLoader.getInstance().getConfigDir().resolve("atheneum.json5").toString());
            JsonObject configJson = jankson.load(configFile);
            String normalized = configJson.toJson(false, false);
            AtheneumConfig config = (AtheneumConfig)new Gson().fromJson(normalized, AtheneumConfig.class);
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new AtheneumConfig();
        }
        catch (SyntaxError e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public File saveConfig() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().resolve("atheneum.json5").toString());
        Jankson jankson = Jankson.builder().build();
        String result = jankson.toJson((Object)this).toJson(true, true);
        try {
            boolean fileIsUsable;
            boolean bl = fileIsUsable = configFile.exists() || configFile.createNewFile();
            if (!fileIsUsable) {
                return null;
            }
            FileOutputStream out = new FileOutputStream(configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configFile;
    }

    public static class LibraryComponent {
        public Set<String> ids;
        public ComponentTypes type;
        public ComponentCategories category;
        public LibraryBonuses bonuses;

        public LibraryComponent() {
        }

        public LibraryComponent(Set<String> ids, ComponentTypes type) {
            this(ids, type, new LibraryBonuses(), ComponentCategories.artifact);
        }

        public LibraryComponent(Set<String> ids, LibraryBonuses bonuses, ComponentCategories category) {
            this(ids, ComponentTypes.simple, bonuses, category);
        }

        public LibraryComponent(Set<String> ids, ComponentTypes type, LibraryBonuses bonuses, ComponentCategories category) {
            this.ids = ids;
            this.type = type;
            this.bonuses = bonuses;
            this.category = category;
        }
    }

    public static class LibraryBonuses
    implements Cloneable {
        public int power = 0;
        public int maxPower = 0;
        public int insight = 0;
        public int maxInsight = 0;
        public int synergy = 0;
        public int maxSynergy = 0;
        public int chaos = 0;
        public int minQuantity = 0;
        public int rarityBonus = 0;
        public boolean allowTreasure = false;
        public boolean canCurselift = false;

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public LibraryBonuses put(TableBonuses bonusType, int level) {
            switch (bonusType.ordinal()) {
                case 0: {
                    this.power = level;
                    break;
                }
                case 1: {
                    this.maxPower = level;
                    break;
                }
                case 2: {
                    this.insight = level;
                    break;
                }
                case 3: {
                    this.maxInsight = level;
                    break;
                }
                case 4: {
                    this.synergy = level;
                    break;
                }
                case 5: {
                    this.maxSynergy = level;
                    break;
                }
                case 6: {
                    this.chaos = level;
                    break;
                }
                case 7: {
                    this.minQuantity = level;
                    break;
                }
                case 8: {
                    this.rarityBonus = level;
                }
            }
            return this;
        }

        public LibraryBonuses multiply(int factor) throws CloneNotSupportedException {
            return ((LibraryBonuses)this.clone()).doMultiply(factor);
        }

        private LibraryBonuses doMultiply(int factor) {
            this.power *= factor;
            this.maxPower *= factor;
            this.insight *= factor;
            this.maxInsight *= factor;
            this.synergy *= factor;
            this.maxSynergy *= factor;
            this.chaos *= factor;
            this.minQuantity *= factor;
            this.rarityBonus *= factor;
            return this;
        }

        public LibraryBonuses put(TableBonuses bonusType, boolean bool) {
            if (bonusType == TableBonuses.allowTreasure) {
                this.allowTreasure = bool;
            } else if (bonusType == TableBonuses.canCurselift) {
                this.canCurselift = bool;
            }
            return this;
        }

        public boolean isActive() {
            return this.power != 0 || this.maxPower != 0 || this.insight != 0 || this.maxInsight != 0 || this.synergy != 0 || this.maxSynergy != 0 || this.rarityBonus != 0 || this.minQuantity != 0 || this.chaos != 0 || this.canCurselift || this.allowTreasure;
        }

        public int totalBonus() {
            return this.power + this.maxPower + this.insight + this.maxInsight + this.synergy + this.maxSynergy + this.rarityBonus + this.minQuantity + this.chaos + (this.canCurselift ? 3 : 0) + (this.allowTreasure ? 3 : 0);
        }

        @Serializer
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            if (this.power != 0) {
                json.put("power", (JsonElement)new JsonPrimitive((Object)this.power));
            }
            if (this.maxPower != 0) {
                json.put("maxPower", (JsonElement)new JsonPrimitive((Object)this.maxPower));
            }
            if (this.insight != 0) {
                json.put("insight", (JsonElement)new JsonPrimitive((Object)this.insight));
            }
            if (this.maxInsight != 0) {
                json.put("maxInsight", (JsonElement)new JsonPrimitive((Object)this.maxInsight));
            }
            if (this.synergy != 0) {
                json.put("synergy", (JsonElement)new JsonPrimitive((Object)this.synergy));
            }
            if (this.maxSynergy != 0) {
                json.put("maxSynergy", (JsonElement)new JsonPrimitive((Object)this.maxSynergy));
            }
            if (this.chaos != 0) {
                json.put("chaos", (JsonElement)new JsonPrimitive((Object)this.chaos));
            }
            if (this.minQuantity != 0) {
                json.put("minQuantity", (JsonElement)new JsonPrimitive((Object)this.minQuantity));
            }
            if (this.rarityBonus != 0) {
                json.put("rarityBonus", (JsonElement)new JsonPrimitive((Object)this.rarityBonus));
            }
            if (this.allowTreasure) {
                json.put("allowTreasure", (JsonElement)new JsonPrimitive((Object)this.allowTreasure));
            }
            if (this.canCurselift) {
                json.put("canCurselift", (JsonElement)new JsonPrimitive((Object)this.canCurselift));
            }
            return json;
        }
    }

    public static enum TableBonuses {
        power,
        maxPower,
        insight,
        maxInsight,
        synergy,
        maxSynergy,
        chaos,
        minQuantity,
        rarityBonus,
        allowTreasure,
        canCurselift;

    }

    public static enum ComponentCategories {
        bookshelf,
        tomeshelf,
        artifact;

    }

    public static enum ComponentTypes {
        simple,
        data;

    }

    public static class TomeBonus {
        public Set<String> ids;
        public LibraryBonuses bonusesPerLevel;

        public TomeBonus() {
        }

        public TomeBonus(Set<String> ids, LibraryBonuses bonuses) {
            this.ids = ids;
            this.bonusesPerLevel = bonuses;
        }
    }

    public static class Catalyst {
        public Set<String> ids;
        public LibraryBonuses bonuses;

        public Catalyst() {
        }

        public Catalyst(Set<String> ids, LibraryBonuses bonuses) {
            this.ids = ids;
            this.bonuses = bonuses;
        }
    }
}

