/*
 * Decompiled with CFR 0.152.
 */
package jpxl.atheneum.ench.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jpxl.atheneum.config.AtheneumConfig;
import jpxl.atheneum.ench.table.NewEnchantmentLevelEntry;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_6880;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public abstract class NewEnchantmentHelper {
    public static final int DEFAULT_POWER = 1;
    public static final int DEFAULT_RARITY = 0;
    public static final int DEFAULT_INSIGHT = 1;
    public static final int DEFAULT_CHAOS = 10;
    public static final int DEFAULT_SYNERGY = 1;
    public static final int DEFAULT_QUANTITY = 1;
    public static final List<class_2338> POWER_PROVIDER_OFFSETS = class_2338.method_17962((int)-3, (int)0, (int)-3, (int)3, (int)2, (int)3).filter(pos -> Math.abs(pos.method_10263()) == 2 || Math.abs(pos.method_10263()) == 3 || Math.abs(pos.method_10260()) == 2 || Math.abs(pos.method_10260()) == 3).map(class_2338::method_10062).toList();

    public static int getEnchantmentStatsPerLevel(TableLevelStats stat, int level) {
        return switch (stat.ordinal()) {
            case 0 -> 5 + level * 5;
            case 1 -> 5 + level * 5;
            case 2 -> 5 + level * 5;
            case 6 -> Math.min(10, level);
            case 5 -> Math.clamp((long)(level / 2), 1, 5);
            case 4 -> Math.clamp((long)(level / 2), 1, 5);
            case 3 -> Math.min(level + 2, 10);
            default -> 0;
        };
    }

    public static int getEnchLevelXpPerLevel(int level) {
        return 10 + Math.round((float)(level - 1) * ((float)(level - 1) / 2.0f));
    }

    public static class_124 getRarityColor(class_1887 enchantment) {
        if (enchantment.method_58445() == 1) {
            return class_124.field_1075;
        }
        if (enchantment.method_58445() < 3) {
            return class_124.field_1078;
        }
        if (enchantment.method_58445() < 6) {
            return class_124.field_1065;
        }
        return class_124.field_1060;
    }

    public static boolean hasEnchantments(class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8598)) {
            return !Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)).method_57543();
        }
        return itemStack.method_7942();
    }

    public static List<class_1887> getEnchantments(class_1799 itemStack) {
        ArrayList<class_1887> enchantments = new ArrayList<class_1887>();
        if (itemStack.method_31574(class_1802.field_8598)) {
            for (class_6880 entry : Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)).method_57534()) {
                enchantments.add((class_1887)class_7923.field_41176.method_29107((class_5321)entry.method_40230().get()));
            }
        }
        class_9304.class_9305 builder = new class_9304.class_9305(itemStack.method_58657());
        for (class_6880 entry : builder.method_57545()) {
            enchantments.add((class_1887)class_7923.field_41176.method_29107((class_5321)entry.method_40230().get()));
        }
        return enchantments;
    }

    public static List<class_1887> getEnchantments(List<NewEnchantmentLevelEntry> enchantmentList) {
        return enchantmentList.stream().map(e -> e == null ? null : e.enchantment).filter(Objects::nonNull).toList();
    }

    public static List<NewEnchantmentLevelEntry> enchantmentEntryListFromItemStack(class_1799 sourceItemStack) {
        class_1887 enchantment;
        ArrayList<NewEnchantmentLevelEntry> enchantments = new ArrayList<NewEnchantmentLevelEntry>(10);
        if (sourceItemStack.method_31574(class_1802.field_8598)) {
            class_9304.class_9305 builder1 = new class_9304.class_9305(Objects.requireNonNull((class_9304)sourceItemStack.method_57824(class_9334.field_49643)));
            for (class_6880 entry : builder1.method_57545()) {
                enchantment = (class_1887)class_7923.field_41176.method_29107((class_5321)entry.method_40230().get());
                if (enchantment == null) continue;
                enchantments.add(new NewEnchantmentLevelEntry(enchantment, builder1.method_57546(enchantment)));
            }
        }
        class_9304.class_9305 builder = new class_9304.class_9305(sourceItemStack.method_58657());
        for (class_6880 entry : builder.method_57545()) {
            enchantment = (class_1887)class_7923.field_41176.method_29107((class_5321)entry.method_40230().get());
            if (enchantment == null) continue;
            enchantments.add(new NewEnchantmentLevelEntry(enchantment, builder.method_57546(enchantment)));
        }
        return enchantments;
    }

    public static int getLevel(class_1799 itemStack, class_1887 enchantment) {
        if (itemStack.method_31574(class_1802.field_8598)) {
            class_9304 component = (class_9304)itemStack.method_57824(class_9334.field_49643);
            if (component == null) {
                return 0;
            }
            return component.method_57536(enchantment);
        }
        return itemStack.method_58657().method_57536(enchantment);
    }

    public static int getAveragePower(class_1887 enchantment, int level) {
        return (enchantment.method_8182(level) + enchantment.method_20742(level)) / 2;
    }

    public static List<NewEnchantmentLevelEntry> pickRandomEnchants(class_5819 random, int targetQuantity, @Nullable List<NewEnchantmentLevelEntry> listToChooseFrom) {
        Optional entryToAdd;
        if (listToChooseFrom == null) {
            listToChooseFrom = NewEnchantmentHelper.getCompatibleEnchantmentList(-1, -1, class_7699.method_45397(), true, false, false, true, 255, null, null);
        }
        ArrayList<NewEnchantmentLevelEntry> chosenList = new ArrayList<NewEnchantmentLevelEntry>();
        ArrayList<NewEnchantmentLevelEntry> remainingList = new ArrayList<NewEnchantmentLevelEntry>(listToChooseFrom);
        int m = 0;
        while (!(entryToAdd = class_6011.method_34986((class_5819)random, remainingList)).isEmpty()) {
            chosenList.add((NewEnchantmentLevelEntry)((Object)entryToAdd.get()));
            if (++m >= targetQuantity) break;
            remainingList.removeIf(e -> !e.enchantment.method_8188(((NewEnchantmentLevelEntry)((Object)((Object)entryToAdd.get()))).enchantment));
        }
        return chosenList;
    }

    public static List<NewEnchantmentLevelEntry> getCompatibleEnchantmentList(int power, int rarity, class_7699 enabledFeatures, boolean treasureAllowed, boolean allowCurses, boolean onlyCurses, boolean requirePrimary, int levelsPerEnchantment, @Nullable class_1799 targetItemStack, @Nullable List<class_1887> compatibleEnchList) {
        if (compatibleEnchList == null) {
            compatibleEnchList = new ArrayList<class_1887>();
        }
        ArrayList<NewEnchantmentLevelEntry> filteredList = new ArrayList<NewEnchantmentLevelEntry>();
        block0: for (class_1887 enchantment : class_7923.field_41176) {
            if (!enchantment.method_45382(enabledFeatures) || !allowCurses && enchantment.method_8195() || onlyCurses && !enchantment.method_8195() || enchantment.method_8193() && !treasureAllowed || !enchantment.method_25950() || !compatibleEnchList.stream().filter(ench -> !ench.method_8188(enchantment)).toList().isEmpty() || targetItemStack != null && !targetItemStack.method_31574(class_1802.field_8529) && !targetItemStack.method_31574(class_1802.field_8598) && (!enchantment.method_8192(targetItemStack) || requirePrimary && !enchantment.method_58444(targetItemStack))) continue;
            int m = 0;
            for (int i = enchantment.method_8183(); i > enchantment.method_8187() - 1; --i) {
                if (power >= 0 && (power < enchantment.method_8182(i) || power > enchantment.method_20742(i))) continue;
                filteredList.add(rarity >= 0 ? new NewEnchantmentLevelEntry(enchantment, i, rarity) : new NewEnchantmentLevelEntry(enchantment, i));
                if (m >= levelsPerEnchantment) continue block0;
                ++m;
            }
        }
        filteredList.removeIf(e -> e.method_34979().method_34976() == 0);
        return filteredList;
    }

    public static class_1799 applyEnchantments(class_1799 itemStack, List<NewEnchantmentLevelEntry> enchantmentsToApply) {
        if (itemStack.method_31574(class_1802.field_8529) && enchantmentsToApply.stream().anyMatch(Objects::nonNull)) {
            itemStack = itemStack.method_56701((class_1935)class_1802.field_8598, 1);
        }
        if (itemStack.method_31574(class_1802.field_8598)) {
            class_9304.class_9305 builder = new class_9304.class_9305(Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)));
            for (NewEnchantmentLevelEntry entryToApply : enchantmentsToApply) {
                if (entryToApply == null) continue;
                if (NewEnchantmentHelper.canCombineToUpgrade(itemStack, entryToApply)) {
                    builder.method_57547(entryToApply.enchantment, entryToApply.level + 1);
                    continue;
                }
                if (!builder.method_57545().stream().allMatch(e -> Objects.requireNonNull((class_1887)class_7923.field_41176.method_29107((class_5321)e.method_40230().get())).method_8188(entryToApply.enchantment))) continue;
                builder.method_57550(entryToApply.enchantment, entryToApply.level);
            }
            itemStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
        } else {
            class_9304.class_9305 builder = new class_9304.class_9305(itemStack.method_58657());
            for (NewEnchantmentLevelEntry entryToApply : enchantmentsToApply) {
                if (NewEnchantmentHelper.canCombineToUpgrade(itemStack, entryToApply)) {
                    builder.method_57547(entryToApply.enchantment, entryToApply.level + 1);
                    continue;
                }
                if (!builder.method_57545().stream().allMatch(e -> Objects.requireNonNull((class_1887)class_7923.field_41176.method_29107((class_5321)e.method_40230().get())).method_8188(entryToApply.enchantment))) continue;
                builder.method_57550(entryToApply.enchantment, entryToApply.level);
            }
            itemStack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        }
        return itemStack;
    }

    public static class_1799 removeEnchantments(class_1799 itemStack, List<NewEnchantmentLevelEntry> enchantmentsToRemove) {
        if (itemStack.method_31574(class_1802.field_8598)) {
            class_9304.class_9305 builder = new class_9304.class_9305(Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)));
            builder.method_57548(e -> enchantmentsToRemove.stream().anyMatch(r -> r != null && r.enchantment == class_7923.field_41176.method_29107((class_5321)e.method_40230().get())));
            itemStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
            if (builder.method_57545().isEmpty()) {
                itemStack = itemStack.method_56701((class_1935)class_1802.field_8529, 1);
            }
        } else {
            class_9304.class_9305 builder = new class_9304.class_9305(itemStack.method_58657());
            builder.method_57548(e -> enchantmentsToRemove.stream().anyMatch(r -> r != null && r.enchantment == class_7923.field_41176.method_29107((class_5321)e.method_40230().get())));
            itemStack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        }
        return itemStack;
    }

    public static class_1799 replaceEnchantments(class_1799 itemStack, List<NewEnchantmentLevelEntry> newEnchantmentList) {
        if (itemStack.method_31574(class_1802.field_8598)) {
            class_9304.class_9305 builder = new class_9304.class_9305(Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)));
            builder.method_57548(e -> newEnchantmentList.stream().noneMatch(j -> j != null && j.enchantment == class_7923.field_41176.method_29107((class_5321)e.method_40230().get())));
            for (NewEnchantmentLevelEntry entry : newEnchantmentList) {
                if (entry == null) continue;
                int thisLevel = builder.method_57546(entry.enchantment);
                if (thisLevel == 0) {
                    builder.method_57550(entry.enchantment, entry.level);
                    continue;
                }
                if (thisLevel == entry.level) continue;
                builder.method_57547(entry.enchantment, entry.level);
            }
            itemStack.method_57379(class_9334.field_49643, (Object)builder.method_57549());
            if (builder.method_57545().isEmpty()) {
                itemStack = itemStack.method_56701((class_1935)class_1802.field_8529, 1);
            }
        } else {
            class_9304.class_9305 builder = new class_9304.class_9305(itemStack.method_58657());
            builder.method_57548(e -> newEnchantmentList.stream().noneMatch(j -> j != null && j.enchantment == class_7923.field_41176.method_29107((class_5321)e.method_40230().get())));
            for (NewEnchantmentLevelEntry entry : newEnchantmentList) {
                if (entry == null) continue;
                int thisLevel = builder.method_57546(entry.enchantment);
                if (thisLevel == 0) {
                    builder.method_57550(entry.enchantment, entry.level);
                    continue;
                }
                if (thisLevel == entry.level) continue;
                builder.method_57547(entry.enchantment, entry.level);
            }
            itemStack.method_57379(class_9334.field_49633, (Object)builder.method_57549());
        }
        return itemStack;
    }

    public static boolean canApplyToItemStack(class_1799 itemStack, NewEnchantmentLevelEntry entry) {
        return itemStack.method_31574(class_1802.field_8529) || itemStack.method_31574(class_1802.field_8598) && NewEnchantmentHelper.getEnchantments(itemStack).stream().allMatch(e -> e.method_8188(entry.enchantment)) || entry.enchantment.method_8192(itemStack) && NewEnchantmentHelper.getEnchantments(itemStack).stream().allMatch(e -> e.method_8188(entry.enchantment)) || NewEnchantmentHelper.canCombineToUpgrade(itemStack, entry);
    }

    public static boolean canCombineToUpgrade(class_1799 targetItemStack, NewEnchantmentLevelEntry entry) {
        return NewEnchantmentHelper.getEnchantments(targetItemStack).stream().anyMatch(e -> e == entry.enchantment && NewEnchantmentHelper.getLevel(targetItemStack, e) == entry.level);
    }

    public static enum TableLevelStats {
        MAX_POWER,
        MAX_STABILITY,
        MAX_INSIGHT,
        MAX_BOOKSHELVES,
        MAX_ARTIFACTS,
        MAX_TOMES,
        MAX_LAPIS;

    }

    public static enum TableStats {
        POWER,
        MAX_POWER,
        MIN_QUANTITY,
        MAX_INSIGHT,
        RARITY_BONUS,
        MAX_SYNERGY,
        CHAOS,
        SYNERGY,
        INSIGHT,
        TREASURE_ALLOWED,
        CAN_CURSELIFT,
        ENCH_LEVEL,
        ENCH_XP,
        SCREEN_INDEX,
        XP_COST,
        MIN_LEVEL,
        TOME_COUNT,
        BOOKSHELF_COUNT,
        ARTIFACT_COUNT;

    }

    public static enum TableScreens {
        NONE,
        GENERATE,
        TRANSFER,
        CURSED;

    }

    public static class LibraryBonusWithCategory {
        public AtheneumConfig.LibraryBonuses bonuses;
        public AtheneumConfig.ComponentCategories category;

        public LibraryBonusWithCategory(AtheneumConfig.LibraryBonuses bonuses, AtheneumConfig.ComponentCategories category) {
            this.bonuses = bonuses;
            this.category = category;
        }
    }
}

