/*
 * Decompiled with CFR 0.152.
 */
package jpxl.atheneum.ench.table;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import jpxl.atheneum.Atheneum;
import jpxl.atheneum.config.AtheneumConfig;
import jpxl.atheneum.ench.table.NewEnchantmentHelper;
import jpxl.atheneum.ench.table.NewEnchantmentLevelEntry;
import jpxl.atheneum.util.EnchantLevelData;
import jpxl.atheneum.util.IEnchantingBlock;
import jpxl.atheneum.util.IEntityDataSaver;
import jpxl.atheneum.util.PlayerEnchantLevelEntry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5819;
import net.minecraft.class_6011;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class NewEnchantmentScreenHandler
extends class_1703 {
    private final class_1263 inventory = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            NewEnchantmentScreenHandler.this.method_7609((class_1263)this);
        }
    };
    private final class_3914 context;
    private final class_5819 random = class_5819.method_43047();
    private final class_3915 seed = class_3915.method_17403();
    public boolean treasureAllowed;
    public boolean canCurselift;
    public int enchantingLevel;
    public int enchantingXP;
    public int chaos;
    public int minQuantity;
    public int rarityBonus;
    public int bookshelfCount;
    public int artifactCount;
    public int tomeCount;
    public int power;
    public int maxPower;
    public int insight;
    public int maxInsight;
    public int synergy;
    public int maxSynergy;
    public int screenIndex = NewEnchantmentHelper.TableScreens.NONE.ordinal();
    public int minLevel = -1;
    public int xpCost = -1;
    public int[] outputIds = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public int[] outputLevels = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public int[] clueAccuracy = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public int[] selectedEnchants = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final class_3913 outputIdsPropertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return NewEnchantmentScreenHandler.this.outputIds[index];
        }

        public void method_17391(int index, int value) {
            NewEnchantmentScreenHandler.this.outputIds[index] = value;
        }

        public int method_17389() {
            return 10;
        }
    };
    private final class_3913 outputLevelsPropertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return NewEnchantmentScreenHandler.this.outputLevels[index];
        }

        public void method_17391(int index, int value) {
            NewEnchantmentScreenHandler.this.outputLevels[index] = value;
        }

        public int method_17389() {
            return 10;
        }
    };
    private final class_3913 clueAccuracyPropertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return NewEnchantmentScreenHandler.this.clueAccuracy[index];
        }

        public void method_17391(int index, int value) {
            NewEnchantmentScreenHandler.this.clueAccuracy[index] = value;
        }

        public int method_17389() {
            return 10;
        }
    };
    private final class_3913 selectedEnchantsPropertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return NewEnchantmentScreenHandler.this.selectedEnchants[index];
        }

        public void method_17391(int index, int value) {
            NewEnchantmentScreenHandler.this.selectedEnchants[index] = value;
        }

        public int method_17389() {
            return 10;
        }
    };
    private final class_3913 tableStatsPropertyDelegate = new class_3913(){

        public int method_17390(int index) {
            NewEnchantmentHelper.TableStats statsValue = NewEnchantmentHelper.TableStats.values()[index];
            return switch (statsValue) {
                case NewEnchantmentHelper.TableStats.POWER -> NewEnchantmentScreenHandler.this.power;
                case NewEnchantmentHelper.TableStats.MAX_POWER -> NewEnchantmentScreenHandler.this.maxPower;
                case NewEnchantmentHelper.TableStats.RARITY_BONUS -> NewEnchantmentScreenHandler.this.rarityBonus;
                case NewEnchantmentHelper.TableStats.MAX_SYNERGY -> NewEnchantmentScreenHandler.this.maxSynergy;
                case NewEnchantmentHelper.TableStats.MIN_QUANTITY -> NewEnchantmentScreenHandler.this.minQuantity;
                case NewEnchantmentHelper.TableStats.MAX_INSIGHT -> NewEnchantmentScreenHandler.this.maxInsight;
                case NewEnchantmentHelper.TableStats.CHAOS -> NewEnchantmentScreenHandler.this.chaos;
                case NewEnchantmentHelper.TableStats.INSIGHT -> NewEnchantmentScreenHandler.this.insight;
                case NewEnchantmentHelper.TableStats.SYNERGY -> NewEnchantmentScreenHandler.this.synergy;
                case NewEnchantmentHelper.TableStats.ENCH_LEVEL -> NewEnchantmentScreenHandler.this.enchantingLevel;
                case NewEnchantmentHelper.TableStats.ENCH_XP -> NewEnchantmentScreenHandler.this.enchantingXP;
                case NewEnchantmentHelper.TableStats.SCREEN_INDEX -> NewEnchantmentScreenHandler.this.screenIndex;
                case NewEnchantmentHelper.TableStats.MIN_LEVEL -> NewEnchantmentScreenHandler.this.minLevel;
                case NewEnchantmentHelper.TableStats.TREASURE_ALLOWED -> {
                    if (NewEnchantmentScreenHandler.this.treasureAllowed) {
                        yield 1;
                    }
                    yield 0;
                }
                case NewEnchantmentHelper.TableStats.CAN_CURSELIFT -> {
                    if (NewEnchantmentScreenHandler.this.canCurselift) {
                        yield 1;
                    }
                    yield 0;
                }
                case NewEnchantmentHelper.TableStats.XP_COST -> NewEnchantmentScreenHandler.this.xpCost;
                case NewEnchantmentHelper.TableStats.ARTIFACT_COUNT -> NewEnchantmentScreenHandler.this.artifactCount;
                case NewEnchantmentHelper.TableStats.BOOKSHELF_COUNT -> NewEnchantmentScreenHandler.this.bookshelfCount;
                case NewEnchantmentHelper.TableStats.TOME_COUNT -> NewEnchantmentScreenHandler.this.tomeCount;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            NewEnchantmentHelper.TableStats statsValue = NewEnchantmentHelper.TableStats.values()[index];
            switch (statsValue) {
                case POWER: {
                    NewEnchantmentScreenHandler.this.power = value;
                    break;
                }
                case MAX_POWER: {
                    NewEnchantmentScreenHandler.this.maxPower = value;
                    break;
                }
                case RARITY_BONUS: {
                    NewEnchantmentScreenHandler.this.rarityBonus = value;
                    break;
                }
                case MAX_SYNERGY: {
                    NewEnchantmentScreenHandler.this.maxSynergy = value;
                    break;
                }
                case MIN_QUANTITY: {
                    NewEnchantmentScreenHandler.this.minQuantity = value;
                    break;
                }
                case MAX_INSIGHT: {
                    NewEnchantmentScreenHandler.this.maxInsight = value;
                    break;
                }
                case CHAOS: {
                    NewEnchantmentScreenHandler.this.chaos = value;
                    break;
                }
                case INSIGHT: {
                    NewEnchantmentScreenHandler.this.insight = value;
                    break;
                }
                case SYNERGY: {
                    NewEnchantmentScreenHandler.this.synergy = value;
                    break;
                }
                case ENCH_LEVEL: {
                    NewEnchantmentScreenHandler.this.enchantingLevel = value;
                    break;
                }
                case ENCH_XP: {
                    NewEnchantmentScreenHandler.this.enchantingXP = value;
                    break;
                }
                case SCREEN_INDEX: {
                    NewEnchantmentScreenHandler.this.screenIndex = value;
                    break;
                }
                case MIN_LEVEL: {
                    NewEnchantmentScreenHandler.this.minLevel = value;
                    break;
                }
                case XP_COST: {
                    NewEnchantmentScreenHandler.this.xpCost = value;
                    break;
                }
                case TREASURE_ALLOWED: {
                    NewEnchantmentScreenHandler.this.treasureAllowed = value == 1;
                    break;
                }
                case CAN_CURSELIFT: {
                    NewEnchantmentScreenHandler.this.canCurselift = value == 1;
                    break;
                }
                case TOME_COUNT: {
                    NewEnchantmentScreenHandler.this.tomeCount = value;
                    break;
                }
                case BOOKSHELF_COUNT: {
                    NewEnchantmentScreenHandler.this.bookshelfCount = value;
                    break;
                }
                case ARTIFACT_COUNT: {
                    NewEnchantmentScreenHandler.this.artifactCount = value;
                }
            }
        }

        public int method_17389() {
            return 19;
        }
    };
    private final class_1661 playerInventory;

    public NewEnchantmentScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public NewEnchantmentScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(Atheneum.NEW_ENCHANTMENT_SCREEN_HANDLER, syncId);
        int i;
        this.context = context;
        this.method_7621(new class_1735(this, this.inventory, 0, 8, 47){

            public int method_7675() {
                return 1;
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 1, 28, 47){

            public boolean method_7680(class_1799 stack) {
                for (AtheneumConfig.Catalyst catalyst : Atheneum.config.catalysts) {
                    if (!catalyst.ids.stream().anyMatch(id -> class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12833(new class_2960(id)) == 0)) continue;
                    return true;
                }
                return false;
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 2, 48, 47){

            public int method_7675() {
                return 1;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 115 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 173));
        }
        this.playerInventory = playerInventory;
        this.resetEnchantStats();
        this.generateTableStats();
        this.method_17362(this.seed).method_17404(playerInventory.field_7546.method_7278());
        this.method_17360(this.tableStatsPropertyDelegate);
        this.method_17360(this.outputIdsPropertyDelegate);
        this.method_17360(this.outputLevelsPropertyDelegate);
        this.method_17360(this.clueAccuracyPropertyDelegate);
        this.method_17360(this.selectedEnchantsPropertyDelegate);
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.inventory) {
            class_1799 itemStack = inventory.method_5438(0);
            if (itemStack.method_7960()) {
                this.resetOutput(true);
                this.generateTableStats();
                this.screenIndex = NewEnchantmentHelper.TableScreens.NONE.ordinal();
            } else if (itemStack.method_7923()) {
                this.context.method_17393((world, pos) -> {
                    this.screenIndex = NewEnchantmentHelper.TableScreens.GENERATE.ordinal();
                    this.resetOutput(true);
                    this.generateTableStats();
                    this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                    this.random.method_43052((long)this.seed.method_17407());
                    int usableLapisCount = this.getUsableLapisCount();
                    int adjustedPower = this.power / 2 + this.random.method_43048(Math.max(5, (int)((double)(this.power / 2))));
                    int targetQuantity = Math.clamp((long)this.random.method_43048((int)Math.sqrt((double)(usableLapisCount * 8) + (double)itemStack.method_7909().method_7837())), this.minQuantity, 10);
                    List<NewEnchantmentLevelEntry> totalList = NewEnchantmentHelper.getCompatibleEnchantmentList(adjustedPower, this.rarityBonus, world.method_45162(), this.treasureAllowed, false, false, true, 255, itemStack, null);
                    List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.pickRandomEnchants(this.random, targetQuantity, totalList);
                    List<NewEnchantmentLevelEntry> returnList = this.corruptEnchantmentsInList((class_1937)world, itemStack, targetList, totalList, this.treasureAllowed, true);
                    this.generateClues(returnList, targetList, (class_1937)world, adjustedPower, this.treasureAllowed, itemStack);
                    this.xpCost = Math.max(1, Math.round(((float)this.power + (float)this.rarityBonus + (float)(this.getUsableLapisCount() * 2)) / 8.0f));
                    this.minLevel = Math.max(5, Math.round(((float)this.power + (float)this.rarityBonus + (float)(this.getUsableLapisCount() * 2)) / 2.0f));
                    this.method_7623();
                });
            } else if (NewEnchantmentHelper.hasEnchantments(itemStack)) {
                if (NewEnchantmentHelper.getEnchantments(itemStack).stream().anyMatch(class_1887::method_8195)) {
                    this.context.method_17393((world, blockPos) -> {
                        this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.CURSED.ordinal());
                        this.screenIndex = NewEnchantmentHelper.TableScreens.CURSED.ordinal();
                        this.generateTableStats();
                        class_1799 itemStack1 = this.inventory.method_5438(0);
                        this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                        this.random.method_43052((long)this.seed.method_17407());
                        if (this.canCurselift) {
                            List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack1);
                            List<NewEnchantmentLevelEntry> returnList = this.getCurseliftResults((class_1937)world, itemStack, targetList, this.treasureAllowed, false);
                            this.generateCurseliftClues(returnList, targetList);
                            ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>(10);
                            for (int i = 0; i < 10; ++i) {
                                if (this.selectedEnchants[i] < 0 || targetList.size() <= i || targetList.get(i) == null) continue;
                                selectedList.add(targetList.get(i));
                            }
                            if (!selectedList.isEmpty()) {
                                this.xpCost = this.generateTransferXpCost(selectedList);
                                this.minLevel = this.generateTransferLevelCost(selectedList);
                            } else {
                                this.xpCost = 0;
                                this.minLevel = 0;
                            }
                        }
                        this.method_7623();
                    });
                } else {
                    this.context.method_17393((world, blockPos) -> {
                        this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.TRANSFER.ordinal());
                        this.screenIndex = NewEnchantmentHelper.TableScreens.TRANSFER.ordinal();
                        this.generateTableStats();
                        class_1799 itemStack1 = this.inventory.method_5438(0);
                        class_1799 itemStack3 = this.inventory.method_5438(2);
                        this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                        this.random.method_43052((long)this.seed.method_17407());
                        if (!itemStack3.method_7960() && (itemStack3.method_7923() || NewEnchantmentHelper.hasEnchantments(itemStack3))) {
                            List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack1);
                            List<NewEnchantmentLevelEntry> returnList = this.corruptEnchantmentsInList((class_1937)world, itemStack3, targetList, null, this.treasureAllowed, false);
                            this.generateTransferClues(returnList, targetList);
                            ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>(10);
                            for (int i = 0; i < 10; ++i) {
                                if (this.selectedEnchants[i] < 0 || targetList.size() <= i || targetList.get(i) == null) continue;
                                selectedList.add(targetList.get(i));
                            }
                            if (!selectedList.isEmpty()) {
                                this.xpCost = this.generateTransferXpCost(selectedList);
                                this.minLevel = this.generateTransferLevelCost(selectedList);
                            } else {
                                this.xpCost = 0;
                                this.minLevel = 0;
                            }
                        }
                        this.method_7623();
                    });
                }
            } else {
                this.screenIndex = NewEnchantmentHelper.TableScreens.NONE.ordinal();
                this.resetOutput(true);
                this.generateTableStats();
                this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                this.random.method_43052((long)this.seed.method_17407());
                this.method_7623();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_7604(class_1657 player, int id) {
        if (id < 0 || id > 11) {
            class_156.method_33559((String)(String.valueOf(player.method_5477()) + " pressed invalid button id: " + id));
            return false;
        }
        if (id < 10) {
            class_1799 itemStack = ((class_1735)this.field_7761.get(0)).method_7677();
            class_1799 itemStack3 = ((class_1735)this.field_7761.get(2)).method_7677();
            if (!NewEnchantmentHelper.hasEnchantments(itemStack)) return false;
            if (NewEnchantmentHelper.getEnchantments(itemStack).stream().anyMatch(class_1887::method_8195)) {
                List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack);
                if (targetList.size() <= id) {
                    return false;
                }
                if (targetList.get((int)id).enchantment.method_8195()) {
                    this.selectedEnchants[id] = this.selectedEnchants[id] == -2 ? 0 : (this.selectedEnchants[id] == -1 ? 1 : (this.selectedEnchants[id] == 0 ? -2 : -1));
                }
                this.context.method_17393((world, blockPos) -> {
                    this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.CURSED.ordinal());
                    this.screenIndex = NewEnchantmentHelper.TableScreens.CURSED.ordinal();
                    this.generateTableStats();
                    this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                    this.random.method_43052((long)this.seed.method_17407());
                    if (this.canCurselift) {
                        List<NewEnchantmentLevelEntry> returnList = this.getCurseliftResults((class_1937)world, itemStack, targetList, this.treasureAllowed, false);
                        this.generateCurseliftClues(returnList, targetList);
                        ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>(10);
                        for (int i = 0; i < 10; ++i) {
                            if (this.selectedEnchants[i] < 0 || targetList.size() <= i || targetList.get(i) == null) continue;
                            selectedList.add((NewEnchantmentLevelEntry)((Object)((Object)targetList.get(i))));
                        }
                        if (!selectedList.isEmpty()) {
                            this.xpCost = this.generateTransferXpCost(selectedList);
                            this.minLevel = this.generateTransferLevelCost(selectedList);
                        } else {
                            this.xpCost = 0;
                            this.minLevel = 0;
                        }
                    }
                    this.method_7623();
                });
                return true;
            }
            List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack);
            if (targetList.size() <= id) {
                return false;
            }
            if (NewEnchantmentHelper.canApplyToItemStack(itemStack3, targetList.get(id))) {
                this.selectedEnchants[id] = this.selectedEnchants[id] == -2 ? 0 : (this.selectedEnchants[id] == -1 ? 1 : (this.selectedEnchants[id] == 0 ? -2 : -1));
            }
            this.context.method_17393((world, blockPos) -> {
                this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.TRANSFER.ordinal());
                this.screenIndex = NewEnchantmentHelper.TableScreens.TRANSFER.ordinal();
                this.generateTableStats();
                this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                this.random.method_43052((long)this.seed.method_17407());
                if (!itemStack3.method_7960() && (itemStack3.method_7923() || NewEnchantmentHelper.hasEnchantments(itemStack3))) {
                    List<NewEnchantmentLevelEntry> returnList = this.corruptEnchantmentsInList((class_1937)world, itemStack3, targetList, null, this.treasureAllowed, false);
                    this.generateTransferClues(returnList, targetList);
                    ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>(10);
                    for (int i = 0; i < 10; ++i) {
                        if (this.selectedEnchants[i] < 0 || targetList.size() <= i || targetList.get(i) == null) continue;
                        selectedList.add((NewEnchantmentLevelEntry)((Object)((Object)targetList.get(i))));
                    }
                    if (!selectedList.isEmpty()) {
                        this.xpCost = this.generateTransferXpCost(selectedList);
                        this.minLevel = this.generateTransferLevelCost(selectedList);
                    } else {
                        this.xpCost = 0;
                        this.minLevel = 0;
                    }
                }
                this.method_7623();
            });
            return true;
        }
        if (id == 10) {
            if (this.screenIndex == NewEnchantmentHelper.TableScreens.GENERATE.ordinal()) {
                class_1799 itemStack = this.inventory.method_5438(0);
                class_1799 itemStack2 = this.inventory.method_5438(1);
                this.generateTableStats();
                if ((itemStack2.method_7960() || itemStack2.method_7947() < this.getUsableLapisCount()) && !player.method_56992()) {
                    return false;
                }
                if (itemStack.method_7960() || !itemStack.method_7923()) return false;
                this.context.method_17393((world, pos) -> {
                    class_1799 itemStack3 = itemStack;
                    this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                    this.random.method_43052((long)this.seed.method_17407());
                    boolean treasureAllowed = true;
                    int usableLapisCount = this.getUsableLapisCount();
                    int adjustedPower = this.power / 2 + this.random.method_43048(Math.max(5, (int)((double)(this.power / 2))));
                    int targetQuantity = Math.clamp((long)this.random.method_43048((int)Math.sqrt((double)(usableLapisCount * 8) + (double)itemStack.method_7909().method_7837())), this.minQuantity, 10);
                    List<NewEnchantmentLevelEntry> totalList = NewEnchantmentHelper.getCompatibleEnchantmentList(adjustedPower, this.rarityBonus, world.method_45162(), treasureAllowed, false, false, true, 255, itemStack3, null);
                    List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.pickRandomEnchants(this.random, targetQuantity, totalList);
                    List<NewEnchantmentLevelEntry> returnList = this.corruptEnchantmentsInList((class_1937)world, itemStack3, targetList, totalList, treasureAllowed, true);
                    if (!returnList.isEmpty() && (player.field_7520 >= this.xpCost && player.field_7520 >= this.minLevel || player.method_31549().field_7477)) {
                        player.method_7286(itemStack3, this.xpCost);
                        EnchantLevelData.addEnchantmentXP((IEntityDataSaver)player, this.xpCost);
                        this.inventory.method_5447(0, NewEnchantmentHelper.applyEnchantments(itemStack3, returnList));
                        if (!player.method_56992()) {
                            itemStack2.method_7934(usableLapisCount);
                            if (itemStack2.method_7960()) {
                                this.inventory.method_5447(1, class_1799.field_8037);
                            }
                        }
                        player.method_7281(class_3468.field_15420);
                        if (player instanceof class_3222) {
                            class_174.field_1181.method_8870((class_3222)player, itemStack3, this.xpCost);
                        }
                        this.resetEnchantStats();
                        this.resetOutput(true);
                        this.inventory.method_5431();
                        this.method_7609(this.inventory);
                        world.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    }
                });
                return true;
            }
            if (this.screenIndex == NewEnchantmentHelper.TableScreens.TRANSFER.ordinal()) {
                class_1799 itemStack = ((class_1735)this.field_7761.get(0)).method_7677();
                class_1799 itemStack2 = ((class_1735)this.field_7761.get(1)).method_7677();
                if (!itemStack.method_7942() && Objects.requireNonNull((class_9304)itemStack.method_57824(class_9334.field_49643)).method_57543()) return false;
                if (NewEnchantmentHelper.getEnchantments(itemStack).stream().anyMatch(class_1887::method_8195)) {
                    return false;
                }
                this.context.method_17393((world, blockPos) -> {
                    this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.TRANSFER.ordinal());
                    this.screenIndex = NewEnchantmentHelper.TableScreens.TRANSFER.ordinal();
                    this.generateTableStats();
                    class_1799 itemStack1 = ((class_1735)this.field_7761.get(0)).method_7677();
                    class_1799 itemStack3 = ((class_1735)this.field_7761.get(2)).method_7677();
                    this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                    this.random.method_43052((long)this.seed.method_17407());
                    if (!itemStack3.method_7960() && (itemStack3.method_7923() || NewEnchantmentHelper.hasEnchantments(itemStack3))) {
                        List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack1);
                        List<NewEnchantmentLevelEntry> returnList = this.corruptEnchantmentsInList((class_1937)world, itemStack3, targetList, null, this.treasureAllowed, false);
                        this.generateTransferClues(returnList, targetList);
                        ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>();
                        ArrayList<NewEnchantmentLevelEntry> selectedReturnList = new ArrayList<NewEnchantmentLevelEntry>();
                        for (int i = 0; i < 10; ++i) {
                            if (this.selectedEnchants[i] < 0 || targetList.size() <= i || !NewEnchantmentHelper.canApplyToItemStack(itemStack3, targetList.get(i))) continue;
                            selectedList.add(targetList.get(i));
                            selectedReturnList.add(returnList.get(i));
                        }
                        if (!selectedList.isEmpty()) {
                            this.xpCost = this.generateTransferXpCost(selectedList);
                            this.minLevel = this.generateTransferLevelCost(selectedList);
                        } else {
                            this.xpCost = 0;
                            this.minLevel = 0;
                        }
                        if (!selectedList.isEmpty() && itemStack2.method_7947() >= selectedList.size() && (player.field_7520 >= this.xpCost && player.field_7520 >= this.minLevel || player.method_31549().field_7477)) {
                            player.method_7286(itemStack3, this.xpCost);
                            EnchantLevelData.addEnchantmentXP((IEntityDataSaver)player, (int)((double)(this.xpCost / 2)));
                            this.inventory.method_5447(2, NewEnchantmentHelper.applyEnchantments(itemStack3, selectedReturnList));
                            this.inventory.method_5447(0, NewEnchantmentHelper.removeEnchantments(itemStack1, selectedList));
                            if (!player.method_56992()) {
                                itemStack2.method_7934(selectedList.size());
                                if (itemStack2.method_7960()) {
                                    this.inventory.method_5447(1, class_1799.field_8037);
                                }
                            }
                            this.resetEnchantStats();
                            this.resetOutput(true);
                            this.inventory.method_5431();
                            this.method_7609(this.inventory);
                            world.method_8396(null, blockPos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                        }
                    }
                    this.method_7623();
                });
                return true;
            }
            if (this.screenIndex != NewEnchantmentHelper.TableScreens.CURSED.ordinal()) return false;
            class_1799 itemStack = ((class_1735)this.field_7761.get(0)).method_7677();
            class_1799 itemStack2 = ((class_1735)this.field_7761.get(1)).method_7677();
            if (!NewEnchantmentHelper.getEnchantments(itemStack).stream().anyMatch(class_1887::method_8195)) return false;
            this.context.method_17393((world, blockPos) -> {
                this.resetOutput(this.screenIndex != NewEnchantmentHelper.TableScreens.CURSED.ordinal());
                this.screenIndex = NewEnchantmentHelper.TableScreens.CURSED.ordinal();
                this.generateTableStats();
                class_1799 itemStack1 = ((class_1735)this.field_7761.getFirst()).method_7677();
                this.seed.method_17404(this.playerInventory.field_7546.method_7278());
                this.random.method_43052((long)this.seed.method_17407());
                if (this.canCurselift) {
                    List<NewEnchantmentLevelEntry> targetList = NewEnchantmentHelper.enchantmentEntryListFromItemStack(itemStack1);
                    List<NewEnchantmentLevelEntry> returnList = this.getCurseliftResults((class_1937)world, itemStack1, targetList, this.treasureAllowed, false);
                    this.generateCurseliftClues(returnList, targetList);
                    ArrayList<NewEnchantmentLevelEntry> selectedList = new ArrayList<NewEnchantmentLevelEntry>();
                    for (int i = 0; i < 10; ++i) {
                        if (this.selectedEnchants[i] < 0 || targetList.size() <= i) continue;
                        selectedList.add(targetList.get(i));
                    }
                    if (!selectedList.isEmpty()) {
                        this.xpCost = this.generateTransferXpCost(selectedList);
                        this.minLevel = this.generateTransferLevelCost(selectedList);
                    } else {
                        this.xpCost = 0;
                        this.minLevel = 0;
                    }
                    if (!selectedList.isEmpty() && itemStack2.method_7947() >= selectedList.size() && (player.field_7520 >= this.xpCost && player.field_7520 >= this.minLevel || player.method_31549().field_7477)) {
                        player.method_7286(itemStack1, this.xpCost);
                        this.inventory.method_5447(0, NewEnchantmentHelper.replaceEnchantments(itemStack1, returnList));
                        if (!player.method_56992()) {
                            itemStack2.method_7934(selectedList.size());
                            if (itemStack2.method_7960()) {
                                this.inventory.method_5447(1, class_1799.field_8037);
                            }
                        }
                        this.resetEnchantStats();
                        this.resetOutput(true);
                        this.inventory.method_5431();
                        this.method_7609(this.inventory);
                        world.method_8396(null, blockPos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    }
                }
                this.method_7623();
            });
            return true;
        }
        if (id != 11) return false;
        if (player.field_7520 < 1) {
            return false;
        }
        this.context.method_17393((world, pos) -> {
            player.method_7286(class_1799.field_8037, 1);
            this.method_7609(this.inventory);
        });
        return true;
    }

    public int getLapisCount() {
        class_1799 itemStack = this.inventory.method_5438(1);
        if (itemStack.method_7960()) {
            return 0;
        }
        return itemStack.method_7947();
    }

    public int getUsableLapisCount() {
        return Math.min(NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_LAPIS, this.enchantingLevel), this.getLapisCount());
    }

    public int getSeed() {
        return this.seed.method_17407();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7597(class_1657 player) {
        return NewEnchantmentScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)class_2246.field_10485);
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = (class_1735)this.field_7761.get(slot);
        if (slot2 != null && slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot == 0) {
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (slot == 1) {
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (slot == 2) {
                if (!this.method_7616(itemStack2, 2, 38, true)) {
                    return class_1799.field_8037;
                }
            } else if (itemStack2.method_31574(class_1802.field_8759)) {
                if (!this.method_7616(itemStack2, 1, 2, true)) {
                    return class_1799.field_8037;
                }
            } else if (!((class_1735)this.field_7761.getFirst()).method_7681() && ((class_1735)this.field_7761.getFirst()).method_7680(itemStack2)) {
                class_1799 itemStack3 = itemStack2.method_46651(1);
                itemStack2.method_7934(1);
                ((class_1735)this.field_7761.getFirst()).method_53512(itemStack3);
            } else if (!((class_1735)this.field_7761.get(2)).method_7681() && ((class_1735)this.field_7761.get(2)).method_7680(itemStack2)) {
                class_1799 itemStack3 = itemStack2.method_46651(1);
                itemStack2.method_7934(1);
                ((class_1735)this.field_7761.get(2)).method_53512(itemStack3);
            } else {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_53512(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot2.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    private List<NewEnchantmentLevelEntry> corruptEnchantmentsInList(class_1937 world, class_1799 itemStack, List<NewEnchantmentLevelEntry> targetList, @Nullable List<NewEnchantmentLevelEntry> passedTotalList, boolean treasureAllowed, boolean spareFirst) {
        ArrayList<NewEnchantmentLevelEntry> returnList = new ArrayList<NewEnchantmentLevelEntry>();
        for (int i = 0; i < targetList.size(); ++i) {
            if (i == 0 && spareFirst) {
                returnList.add(targetList.getFirst());
                continue;
            }
            NewEnchantmentLevelEntry entry = targetList.get(i);
            if (this.random.method_43048(100) < this.chaos) {
                List<NewEnchantmentLevelEntry> totalList;
                int REROLL_WEIGHT = 50 + this.synergy;
                int LOST_WEIGHT = 50;
                int CURSE_WEIGHT = Math.round(8.0f * (float)(100 / Math.max(this.synergy, 1)));
                int chaosRandom = this.random.method_43048(REROLL_WEIGHT + LOST_WEIGHT + CURSE_WEIGHT);
                int sum = REROLL_WEIGHT + LOST_WEIGHT + CURSE_WEIGHT;
                List<NewEnchantmentLevelEntry> list = totalList = passedTotalList == null ? NewEnchantmentHelper.getCompatibleEnchantmentList(Math.max(5, NewEnchantmentHelper.getAveragePower(targetList.get((int)i).enchantment, targetList.get((int)i).level) + this.random.method_43048(Math.max(1, this.synergy)) - this.random.method_43048(this.chaos)), -1, world.method_45162(), treasureAllowed, false, false, false, 255, itemStack, NewEnchantmentHelper.getEnchantments(targetList)) : passedTotalList;
                if (chaosRandom < REROLL_WEIGHT && !totalList.isEmpty()) {
                    Optional addedEnchantment = class_6011.method_34986((class_5819)this.random, totalList);
                    if (addedEnchantment.isEmpty()) {
                        returnList.add(null);
                        continue;
                    }
                    returnList.add((NewEnchantmentLevelEntry)((Object)addedEnchantment.get()));
                    continue;
                }
                if (chaosRandom < REROLL_WEIGHT + LOST_WEIGHT) {
                    returnList.add(null);
                    continue;
                }
                int cursePower = Math.max(5, (targetList.get((int)i).enchantment.method_8182(targetList.get((int)i).level) + targetList.get((int)i).enchantment.method_20742(targetList.get((int)i).level)) / 2 - this.random.method_43048(this.synergy + 1));
                List<NewEnchantmentLevelEntry> totalCurseList = NewEnchantmentHelper.getCompatibleEnchantmentList(cursePower, -1, world.method_45162(), treasureAllowed, true, true, false, 255, itemStack, NewEnchantmentHelper.getEnchantments(targetList));
                if (totalCurseList.isEmpty()) {
                    returnList.add(null);
                    continue;
                }
                NewEnchantmentLevelEntry addedCurse = NewEnchantmentHelper.pickRandomEnchants(this.random, 1, totalCurseList).getFirst();
                returnList.add(addedCurse);
                continue;
            }
            returnList.add(entry);
        }
        return returnList;
    }

    private List<NewEnchantmentLevelEntry> getCurseliftResults(class_1937 world, class_1799 itemStack, List<NewEnchantmentLevelEntry> targetList, boolean treasureAllowed, boolean spareFirst) {
        ArrayList<NewEnchantmentLevelEntry> returnList = new ArrayList<NewEnchantmentLevelEntry>();
        for (int i = 0; i < targetList.size(); ++i) {
            NewEnchantmentLevelEntry entry = targetList.get(i);
            if (i == 0 && spareFirst || !entry.enchantment.method_8195()) {
                returnList.add(entry);
                continue;
            }
            if (this.random.method_43048(100) < this.chaos) {
                returnList.add(null);
                continue;
            }
            List<NewEnchantmentLevelEntry> totalList = NewEnchantmentHelper.getCompatibleEnchantmentList(Math.max(5, NewEnchantmentHelper.getAveragePower(entry.enchantment, entry.level) - this.random.method_43048(Math.max(1, this.synergy)) + this.random.method_43048(this.chaos)), -1, world.method_45162(), treasureAllowed, true, true, false, 255, itemStack, NewEnchantmentHelper.getEnchantments(targetList));
            if (totalList.isEmpty()) {
                returnList.add(entry);
                continue;
            }
            Optional addedCurse = class_6011.method_34986((class_5819)this.random, totalList);
            if (addedCurse.isEmpty()) {
                returnList.add(entry);
                continue;
            }
            returnList.add((NewEnchantmentLevelEntry)((Object)addedCurse.get()));
        }
        return returnList;
    }

    private void generateClues(List<NewEnchantmentLevelEntry> returnList, List<NewEnchantmentLevelEntry> targetList, class_1937 world, int adjustedPower, boolean treasureAllowed, class_1799 itemStack) {
        int q = 0;
        int lastHit = 0;
        int currentInsight = this.insight;
        for (NewEnchantmentLevelEntry entry2 : returnList) {
            int totalPower;
            if (currentInsight < 2 && q != 0) break;
            int accuracy = Math.max(1, currentInsight / 2) + this.random.method_43048(currentInsight);
            int n = totalPower = entry2 == null ? NewEnchantmentHelper.getAveragePower(targetList.get((int)q).enchantment, targetList.get((int)q).level) : NewEnchantmentHelper.getAveragePower(entry2.enchantment, entry2.level);
            if (accuracy >= totalPower) {
                this.clueAccuracy[q] = 100;
                if (entry2 == null) {
                    this.outputIds[q] = -1;
                    this.outputLevels[q] = -1;
                } else {
                    this.outputIds[q] = class_7923.field_41176.method_10206((Object)entry2.enchantment);
                    this.outputLevels[q] = entry2.level;
                    lastHit = q;
                }
            } else {
                float accuracyChance = (float)accuracy / (float)totalPower;
                this.clueAccuracy[q] = Math.round(accuracyChance * 100.0f);
                if (this.random.method_43057() < accuracyChance) {
                    if (entry2 == null) {
                        this.outputIds[q] = -1;
                        this.outputLevels[q] = -1;
                    } else {
                        this.outputIds[q] = class_7923.field_41176.method_10206((Object)entry2.enchantment);
                        this.outputLevels[q] = entry2.level;
                        lastHit = q;
                    }
                } else {
                    if (Math.round(accuracyChance * 100.0f) < 25) {
                        this.outputIds[q] = -2;
                        this.outputLevels[q] = -1;
                        lastHit = q;
                        break;
                    }
                    boolean accurateCorruption = this.random.method_43056();
                    boolean previousCorrupted = entry2 == null ? this.random.method_43056() : entry2.enchantment != targetList.get((int)q).enchantment;
                    boolean guessIsCorrupted = accurateCorruption == previousCorrupted;
                    int guessPower = entry2 == null ? adjustedPower : NewEnchantmentHelper.getAveragePower(entry2.enchantment, entry2.level);
                    List<NewEnchantmentLevelEntry> totalWrongEnchantmentList = NewEnchantmentHelper.getCompatibleEnchantmentList(guessPower, -1, world.method_45162(), treasureAllowed, guessIsCorrupted, guessIsCorrupted, false, 255, itemStack, NewEnchantmentHelper.getEnchantments(returnList));
                    if (totalWrongEnchantmentList.isEmpty()) {
                        this.outputIds[q] = -1;
                        this.outputLevels[q] = -1;
                    } else {
                        NewEnchantmentLevelEntry addedWrongEnchantment = NewEnchantmentHelper.pickRandomEnchants(this.random, 1, totalWrongEnchantmentList).getFirst();
                        this.outputIds[q] = class_7923.field_41176.method_10206((Object)addedWrongEnchantment.enchantment);
                        this.outputLevels[q] = addedWrongEnchantment.level;
                        lastHit = q;
                    }
                }
            }
            currentInsight -= this.random.method_43048(currentInsight) + 1;
            ++q;
        }
        for (int p = lastHit + 1; p < 10; ++p) {
            if (p == 0) continue;
            this.outputIds[p] = -1;
            this.outputLevels[p] = -1;
            this.clueAccuracy[p] = -1;
        }
    }

    private void generateTransferClues(List<NewEnchantmentLevelEntry> returnList, List<NewEnchantmentLevelEntry> targetList) {
        int q = 0;
        for (NewEnchantmentLevelEntry entry2 : returnList) {
            int totalPower;
            if (targetList.get(q) == null) {
                ++q;
                continue;
            }
            this.outputIds[q] = class_7923.field_41176.method_10206((Object)targetList.get((int)q).enchantment);
            this.outputLevels[q] = targetList.get((int)q).level;
            int accuracy = this.random.method_43048(this.insight);
            int n = totalPower = entry2 == null ? NewEnchantmentHelper.getAveragePower(targetList.get((int)q).enchantment, targetList.get((int)q).level) : NewEnchantmentHelper.getAveragePower(entry2.enchantment, entry2.level);
            if (accuracy >= totalPower) {
                this.clueAccuracy[q] = 100;
                this.selectedEnchants[q] = this.selectedEnchants[q] >= 0 ? (entry2 != targetList.get(q) ? 0 : 1) : (entry2 != targetList.get(q) ? -2 : -1);
            } else {
                float accuracyChance = (float)accuracy / (float)totalPower;
                if (this.random.method_43057() < accuracyChance) {
                    this.clueAccuracy[q] = Math.round(accuracyChance * 100.0f);
                    this.selectedEnchants[q] = this.selectedEnchants[q] >= 0 ? (entry2 != targetList.get(q) ? 0 : 1) : (entry2 != targetList.get(q) ? -2 : -1);
                } else {
                    this.clueAccuracy[q] = Math.round(accuracyChance * 100.0f);
                    this.selectedEnchants[q] = this.selectedEnchants[q] >= 0 ? (entry2 == targetList.get(q) ? 0 : 1) : (entry2 == targetList.get(q) ? -2 : -1);
                }
            }
            ++q;
        }
    }

    private void generateCurseliftClues(List<NewEnchantmentLevelEntry> returnList, List<NewEnchantmentLevelEntry> targetList) {
        int q = 0;
        for (NewEnchantmentLevelEntry entry2 : returnList) {
            int totalPower;
            this.outputIds[q] = class_7923.field_41176.method_10206((Object)targetList.get((int)q).enchantment);
            this.outputLevels[q] = targetList.get((int)q).level;
            this.clueAccuracy[q] = 0;
            if (!targetList.get((int)q).enchantment.method_8195()) {
                ++q;
                continue;
            }
            int accuracy = this.random.method_43048(this.insight);
            if (accuracy >= (totalPower = NewEnchantmentHelper.getAveragePower(targetList.get((int)q).enchantment, targetList.get((int)q).level))) {
                this.clueAccuracy[q] = 100;
                this.selectedEnchants[q] = this.selectedEnchants[q] >= 0 ? (entry2 != targetList.get(q) ? 1 : 0) : (entry2 != targetList.get(q) ? -1 : -2);
            } else {
                float accuracyChance = (float)accuracy / (float)totalPower;
                this.clueAccuracy[q] = Math.round(accuracyChance * 100.0f);
                this.selectedEnchants[q] = this.random.method_43057() < accuracyChance ? (this.selectedEnchants[q] >= 0 ? (entry2 != targetList.get(q) ? 1 : 0) : (entry2 != targetList.get(q) ? -1 : -2)) : (this.selectedEnchants[q] >= 0 ? (entry2 == targetList.get(q) ? 1 : 0) : (entry2 == targetList.get(q) ? -1 : -2));
            }
            ++q;
        }
    }

    private int generateTransferXpCost(List<NewEnchantmentLevelEntry> targetList) {
        int tXpCost = Math.max(1, Math.round(((float)(targetList.getFirst().enchantment.method_8182(targetList.getFirst().level) + targetList.getFirst().enchantment.method_20742(targetList.getFirst().level)) / 2.0f + (11.0f - (float)targetList.getFirst().enchantment.method_58445())) / 8.0f));
        for (int p = 1; p < targetList.size(); ++p) {
            tXpCost += Math.max(1, Math.round(((float)(targetList.get((int)p).enchantment.method_8182(targetList.get((int)p).level) + targetList.get((int)p).enchantment.method_20742(targetList.get((int)p).level)) / 2.0f + (11.0f - (float)targetList.get((int)p).enchantment.method_58445())) / 16.0f));
        }
        return tXpCost;
    }

    private int generateTransferLevelCost(List<NewEnchantmentLevelEntry> targetList) {
        int tMinLevel = Math.max(5, Math.round(((float)(targetList.getFirst().enchantment.method_8182(targetList.getFirst().level) + targetList.getFirst().enchantment.method_20742(targetList.getFirst().level)) / 2.0f + (11.0f - (float)targetList.getFirst().enchantment.method_58445())) / 2.0f));
        for (int p = 1; p < targetList.size(); ++p) {
            tMinLevel += Math.max(5, Math.round(((float)(targetList.get((int)p).enchantment.method_8182(targetList.get((int)p).level) + targetList.get((int)p).enchantment.method_20742(targetList.get((int)p).level)) / 2.0f + (11.0f - (float)targetList.get((int)p).enchantment.method_58445())) / 4.0f));
        }
        return tMinLevel;
    }

    private void generateTableStats() {
        int[] tChaos = new int[]{10};
        int[] tStability = new int[]{1};
        int[] tPower = new int[]{1};
        int[] tMaxPower = new int[]{NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_POWER, this.enchantingLevel)};
        int[] tInsight = new int[]{1};
        int[] tMaxInsight = new int[]{NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_INSIGHT, this.enchantingLevel)};
        int[] tRarity = new int[]{0};
        int[] tMaxStability = new int[]{NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_STABILITY, this.enchantingLevel)};
        int[] tMinQuantity = new int[]{1};
        boolean[] tTreasureAllowed = new boolean[]{false};
        boolean[] tCanCurselift = new boolean[]{false};
        this.context.method_17393((world, pos) -> {
            ArrayList<NewEnchantmentHelper.LibraryBonusWithCategory> bonusList = new ArrayList<NewEnchantmentHelper.LibraryBonusWithCategory>();
            int tBookshelfCount = 0;
            int tArtifactCount = 0;
            int tTomeCount = 0;
            for (class_2338 blockPos : NewEnchantmentHelper.POWER_PROVIDER_OFFSETS) {
                class_2680 targetBlockState = world.method_8320(pos.method_10081((class_2382)blockPos));
                if (!world.method_8320(pos.method_10069(blockPos.method_10263() / 2, blockPos.method_10264(), blockPos.method_10260() / 2)).method_26164(class_3481.field_44473)) continue;
                for (AtheneumConfig.LibraryComponent component : Atheneum.config.libraryComponents) {
                    AtheneumConfig.LibraryBonuses bonuses;
                    if (!component.ids.stream().anyMatch(id -> class_7923.field_41175.method_10221((Object)targetBlockState.method_26204()).method_12833(new class_2960(id)) == 0)) continue;
                    if (component.type == AtheneumConfig.ComponentTypes.simple) {
                        bonuses = component.bonuses;
                    } else {
                        class_2586 blockEntity = world.method_8321(pos.method_10081((class_2382)blockPos));
                        try {
                            bonuses = ((IEnchantingBlock)blockEntity).getLibraryBonus();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            bonuses = component.bonuses;
                        }
                    }
                    if (!bonuses.isActive()) continue;
                    bonusList.add(new NewEnchantmentHelper.LibraryBonusWithCategory(bonuses, component.category));
                }
            }
            bonusList.sort((o1, o2) -> {
                if (o1.category == AtheneumConfig.ComponentCategories.bookshelf) {
                    if (o2.category == AtheneumConfig.ComponentCategories.bookshelf) {
                        return o1.bonuses.totalBonus() - o2.bonuses.totalBonus();
                    }
                    return 1;
                }
                if (o2.category == AtheneumConfig.ComponentCategories.bookshelf) {
                    return -1;
                }
                return 1;
            });
            for (NewEnchantmentHelper.LibraryBonusWithCategory entry : bonusList) {
                if (entry.category == AtheneumConfig.ComponentCategories.bookshelf) {
                    if (++tBookshelfCount > NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_BOOKSHELVES, this.enchantingLevel)) {
                        continue;
                    }
                } else {
                    if (entry.category == AtheneumConfig.ComponentCategories.artifact) {
                        ++tArtifactCount;
                    } else {
                        ++tTomeCount;
                    }
                    if (tArtifactCount > NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_ARTIFACTS, this.enchantingLevel) || tTomeCount > NewEnchantmentHelper.getEnchantmentStatsPerLevel(NewEnchantmentHelper.TableLevelStats.MAX_TOMES, this.enchantingLevel)) {
                        tChaos[0] = tChaos[0] + 10;
                        tStability[0] = tStability[0] - 5;
                    }
                }
                tPower[0] = tPower[0] + entry.bonuses.power;
                tMaxPower[0] = tMaxPower[0] + entry.bonuses.maxPower;
                tStability[0] = tStability[0] + entry.bonuses.synergy;
                tMaxStability[0] = tMaxStability[0] + entry.bonuses.maxSynergy;
                tInsight[0] = tInsight[0] + entry.bonuses.insight;
                tMaxInsight[0] = tMaxInsight[0] + entry.bonuses.maxInsight;
                tChaos[0] = tChaos[0] + entry.bonuses.chaos;
                tMinQuantity[0] = tMinQuantity[0] + entry.bonuses.minQuantity;
                tRarity[0] = tRarity[0] + entry.bonuses.rarityBonus;
                if (entry.bonuses.allowTreasure) {
                    tTreasureAllowed[0] = true;
                }
                if (!entry.bonuses.canCurselift) continue;
                tCanCurselift[0] = true;
            }
            try {
                AtheneumConfig.LibraryBonuses catalystBonuses = Atheneum.config.catalysts.stream().filter((Predicate<AtheneumConfig.Catalyst>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$generateTableStats$13(jpxl.atheneum.config.AtheneumConfig$Catalyst ), (Ljpxl/atheneum/config/AtheneumConfig$Catalyst;)Z)((NewEnchantmentScreenHandler)this)).toList().getFirst().bonuses;
                tPower[0] = tPower[0] + catalystBonuses.power;
                tMaxPower[0] = tMaxPower[0] + catalystBonuses.maxPower;
                tStability[0] = tStability[0] + catalystBonuses.synergy;
                tMaxStability[0] = tMaxStability[0] + catalystBonuses.maxSynergy;
                tInsight[0] = tInsight[0] + catalystBonuses.insight;
                tMaxInsight[0] = tMaxInsight[0] + catalystBonuses.maxInsight;
                tChaos[0] = tChaos[0] + catalystBonuses.chaos;
                tMinQuantity[0] = tMinQuantity[0] + catalystBonuses.minQuantity;
                tRarity[0] = tRarity[0] + catalystBonuses.rarityBonus;
                if (catalystBonuses.allowTreasure) {
                    tTreasureAllowed[0] = true;
                }
                if (catalystBonuses.canCurselift) {
                    tCanCurselift[0] = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.power = Math.clamp((long)tPower[0], 0, tMaxPower[0]);
            this.maxPower = tMaxPower[0];
            this.rarityBonus = Math.clamp((long)tRarity[0], 0, 10);
            this.insight = Math.clamp((long)tInsight[0], 0, tMaxInsight[0]);
            this.maxInsight = tMaxInsight[0];
            this.chaos = Math.clamp((long)tChaos[0], 10, 90);
            this.synergy = Math.clamp((long)tStability[0], 0, tMaxStability[0]);
            this.maxSynergy = tMaxStability[0];
            this.minQuantity = Math.clamp((long)tMinQuantity[0], 1, 10);
            this.treasureAllowed = tTreasureAllowed[0];
            this.canCurselift = tCanCurselift[0];
            this.bookshelfCount = tBookshelfCount;
            this.tomeCount = tTomeCount;
            this.artifactCount = tArtifactCount;
        });
    }

    private void resetOutput(boolean resetSelected) {
        for (int i = 0; i < 10; ++i) {
            this.outputIds[i] = -1;
            this.outputLevels[i] = -1;
            this.clueAccuracy[i] = -1;
            if (!resetSelected) continue;
            this.selectedEnchants[i] = -1;
        }
        this.xpCost = -1;
        this.minLevel = -1;
    }

    private void resetEnchantStats() {
        PlayerEnchantLevelEntry enchantLevel = EnchantLevelData.getEnchantmentLevels((IEntityDataSaver)this.playerInventory.field_7546);
        this.enchantingLevel = enchantLevel.getLevel();
        this.enchantingXP = enchantLevel.getXp();
    }

    private /* synthetic */ boolean lambda$generateTableStats$13(AtheneumConfig.Catalyst catalyst) {
        return catalyst.ids.stream().anyMatch(id -> class_7923.field_41178.method_10221((Object)this.inventory.method_5438(1).method_7909()).method_12833(new class_2960(id)) == 0);
    }
}

