/*
 * Decompiled with CFR 0.152.
 */
package jpxl.atheneum.util;

import jpxl.atheneum.ench.table.NewEnchantmentHelper;
import jpxl.atheneum.util.IEntityDataSaver;
import jpxl.atheneum.util.PlayerEnchantLevelEntry;
import net.minecraft.class_2487;

public class EnchantLevelData {
    public static void addEnchantmentXP(IEntityDataSaver player, int amount) {
        int maxXp;
        class_2487 nbt = EnchantLevelData.getNbt(player);
        int enchLevel = nbt.method_10550("level");
        int enchXP = nbt.method_10550("xp");
        int newAmount = enchXP + amount;
        if (newAmount >= (maxXp = NewEnchantmentHelper.getEnchLevelXpPerLevel(enchLevel))) {
            if (enchLevel >= 15) {
                enchLevel = 15;
                enchXP = maxXp;
            } else {
                ++enchLevel;
                enchXP = newAmount - maxXp;
            }
        } else {
            enchXP = newAmount;
        }
        nbt.method_10569("level", enchLevel);
        nbt.method_10569("xp", enchXP);
    }

    public static PlayerEnchantLevelEntry getEnchantmentLevels(IEntityDataSaver player) {
        class_2487 nbt = EnchantLevelData.getNbt(player);
        int enchLevel = nbt.method_10550("level");
        int enchXP = nbt.method_10550("xp");
        return new PlayerEnchantLevelEntry(player, enchLevel, enchXP);
    }

    private static class_2487 getNbt(IEntityDataSaver player) {
        class_2487 nbt = player.getPersistentData();
        int enchLevel = nbt.method_10550("level");
        int enchXp = nbt.method_10550("xp");
        if (enchLevel == 0) {
            nbt.method_10569("level", 1);
            nbt.method_10569("xp", 0);
        }
        if (enchXp < 0) {
            nbt.method_10569("xp", 0);
        }
        return nbt;
    }

    public static void resetEnchantingLevels(IEntityDataSaver player) {
        class_2487 nbt = player.getPersistentData();
        nbt.method_10569("level", 1);
        nbt.method_10569("xp", 0);
    }

    public static void setEnchantingLevel(IEntityDataSaver player, int level) {
        class_2487 nbt = EnchantLevelData.getNbt(player);
        nbt.method_10569("level", level);
    }

    public static void addEnchantingLevels(IEntityDataSaver player, int levels) {
        class_2487 nbt = EnchantLevelData.getNbt(player);
        int currentLevel = nbt.method_10550("level");
        int newAmount = Math.clamp((long)(currentLevel + levels), 1, 15);
        nbt.method_10569("level", newAmount);
    }

    public static void setEnchantingXp(IEntityDataSaver player, int xp) {
        class_2487 nbt = EnchantLevelData.getNbt(player);
        nbt.method_10569("xp", xp);
    }

    public static void addEnchantingXp(IEntityDataSaver player, int xp) {
        class_2487 nbt = EnchantLevelData.getNbt(player);
        int currentXp = nbt.method_10550("xp");
        int level = nbt.method_10550("level");
        int newAmount = Math.clamp((long)(currentXp + xp), 0, NewEnchantmentHelper.getEnchLevelXpPerLevel(level));
        nbt.method_10569("xp", newAmount);
    }
}

