/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.client.models.entity;

import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.client.ClientResourceHelper;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.init.ModEntities;

public class GlacerosModel
extends GeoModel<GlacerosEntity> {
    public static final ResourceLocation MODEL = BlastFromThePast.location("geo/entity/glaceros.geo.json");
    public static final ResourceLocation BABY_MODEL = BlastFromThePast.location("geo/entity/baby_glaceros.geo.json");
    public static final ResourceLocation ANIMATION = BlastFromThePast.location("animations/entity/glaceros.animation.json");
    public static final ResourceLocation BABY_ANIMATION = BlastFromThePast.location("animations/entity/baby_glaceros.animation.json");
    private static final ResourceLocation NORMAL = ClientResourceHelper.entityTexLocWithTypeSubFolder(ModEntities.GLACEROS.getId());
    private static final ResourceLocation BROAD = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.GLACEROS.getId(), "_broad");
    private static final ResourceLocation CURLY = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.GLACEROS.getId(), "_curly");
    private static final ResourceLocation SPIKEY = ClientResourceHelper.entityTecLocWithTypeSubFolderWithSuffix(ModEntities.GLACEROS.getId(), "_spikey");
    private static final ResourceLocation BABY_TEXTURE = ClientResourceHelper.entityTexLocWithTypeSubFolderWithPrefix(ModEntities.GLACEROS.getId(), "baby_");

    public ResourceLocation getModelResource(GlacerosEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_MODEL;
        }
        return MODEL;
    }

    public ResourceLocation getTextureResource(GlacerosEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_TEXTURE;
        }
        return switch (animatable.getVariant()) {
            default -> throw new MatchException(null, null);
            case GlacerosEntity.Variant.STRAIGHT -> NORMAL;
            case GlacerosEntity.Variant.BROAD -> BROAD;
            case GlacerosEntity.Variant.CURLY -> CURLY;
            case GlacerosEntity.Variant.SPIKEY -> SPIKEY;
        };
    }

    public ResourceLocation getAnimationResource(GlacerosEntity animatable) {
        if (animatable.isBaby()) {
            return BABY_ANIMATION;
        }
        return ANIMATION;
    }

    public void setCustomAnimations(GlacerosEntity animatable, long instanceId, AnimationState<GlacerosEntity> animationState) {
        GeoBone head = (GeoBone)this.getBone("neck").orElseThrow();
        if (animationState.isCurrentAnimation(GlacerosEntity.IDLE)) {
            head.setRotZ(0.0f);
        }
        if (!animatable.isBaby()) {
            ((GeoBone)this.getBone("Antlers1").orElseThrow()).setHidden(animatable.isSheared());
        }
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (!animatable.isSparring()) {
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
        }
        head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
    }
}

