/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;

public class EatDelphiniumGoal
extends MoveToBlockGoal {
    private GlacerosEntity mob;
    private int ticksWaited;

    public EatDelphiniumGoal(GlacerosEntity mob, double speedModifier, int searchRange) {
        super((PathfinderMob)mob, speedModifier, searchRange);
        this.mob = mob;
    }

    public double acceptedDistance() {
        return 2.15;
    }

    public void start() {
        super.start();
        this.ticksWaited = 0;
        this.mob.setEating(false);
    }

    public void tick() {
        if (this.isReachedTarget()) {
            Vec3 lookVec = this.blockPos.getBottomCenter();
            this.mob.getLookControl().setLookAt(lookVec);
            if (this.ticksWaited >= 40) {
                this.mob.setEating(false);
                this.onReachedTarget();
            } else {
                if (!this.mob.isEating()) {
                    this.mob.setEating(true);
                }
                if (this.mob.getRandom().nextFloat() < 0.05f) {
                    this.mob.playSound(SoundEvents.PANDA_EAT, 1.0f, 1.0f);
                }
                ++this.ticksWaited;
            }
        } else if (this.mob.isEating()) {
            this.mob.setEating(false);
        }
        super.tick();
    }

    protected void onReachedTarget() {
        if (EventHooks.canEntityGrief((Level)this.mob.level(), (Entity)this.mob)) {
            this.mob.heal(2.0f);
            if (this.mob.isBaby()) {
                this.mob.ageUp(AgeableMob.getSpeedUpSecondsWhenFeeding((int)(-this.mob.getAge())), true);
            }
            this.mob.level().destroyBlock(this.blockPos, false, (Entity)this.mob);
        }
    }

    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        Block delphinium = levelReader.getBlockState(blockPos).getBlock();
        return delphinium == this.mob.getVariant().getDelphinium();
    }

    public void stop() {
        super.stop();
        this.mob.setEating(false);
    }
}

