/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2;

import appeng.api.config.PowerUnit;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.compat.ae2.P2PModels;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StoragePreconditions;
import java.util.List;

public class EnergyP2PTunnelPart
extends CapabilityP2PTunnelPart<EnergyP2PTunnelPart, MIEnergyStorage> {
    private static final P2PModels MODELS = new P2PModels("part/energy_p2p_tunnel");

    public EnergyP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, EnergyApi.SIDED);
        this.inputHandler = new InputEnergyStorage();
        this.outputHandler = new OutputEnergyStorage();
        this.emptyHandler = EnergyApi.EMPTY;
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputEnergyStorage
    implements MIEnergyStorage.NoExtract {
        private InputEnergyStorage() {
        }

        public boolean canReceive() {
            for (EnergyP2PTunnelPart output : EnergyP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    if (!((MIEnergyStorage)capabilityGuard.get()).canReceive()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return false;
        }

        public long receive(long maxAmount, boolean simulate) {
            StoragePreconditions.notNegative(maxAmount);
            long total = 0L;
            int outputTunnels = EnergyP2PTunnelPart.this.getOutputs().size();
            long amount = maxAmount;
            if (outputTunnels == 0 || amount == 0L) {
                return 0L;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (EnergyP2PTunnelPart target : EnergyP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    MIEnergyStorage output = (MIEnergyStorage)capabilityGuard.get();
                    long toSend = amountPerOutput + overflow;
                    long received = output.receive(toSend, simulate);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (!simulate) {
                EnergyP2PTunnelPart.this.queueTunnelDrain(PowerUnit.FE, total);
            }
            return total;
        }

        public long getAmount() {
            long tot = 0L;
            for (EnergyP2PTunnelPart output : EnergyP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    tot += ((MIEnergyStorage)capabilityGuard.get()).getAmount();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return tot;
        }

        public long getCapacity() {
            long tot = 0L;
            for (EnergyP2PTunnelPart output : EnergyP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    tot += ((MIEnergyStorage)capabilityGuard.get()).getCapacity();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return tot;
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return cableTier == CableTier.SUPERCONDUCTOR;
        }
    }

    private class OutputEnergyStorage
    implements MIEnergyStorage.NoInsert {
        private OutputEnergyStorage() {
        }

        public boolean canExtract() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = EnergyP2PTunnelPart.this.getInputCapability();){
                boolean bl = ((MIEnergyStorage)input.get()).canExtract();
                return bl;
            }
        }

        public long extract(long maxAmount, boolean simulate) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = EnergyP2PTunnelPart.this.getInputCapability();){
                long extracted = ((MIEnergyStorage)input.get()).extract(maxAmount, simulate);
                if (!simulate) {
                    EnergyP2PTunnelPart.this.queueTunnelDrain(PowerUnit.FE, extracted);
                }
                long l = extracted;
                return l;
            }
        }

        public long getAmount() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = EnergyP2PTunnelPart.this.getInputCapability();){
                long l = ((MIEnergyStorage)input.get()).getAmount();
                return l;
            }
        }

        public long getCapacity() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = EnergyP2PTunnelPart.this.getInputCapability();){
                long l = ((MIEnergyStorage)input.get()).getCapacity();
                return l;
            }
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return cableTier == CableTier.SUPERCONDUCTOR;
        }
    }
}

