/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.ae2;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.parts.PartModels;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.util.AEColor;
import appeng.items.parts.PartItem;
import appeng.items.parts.PartModelsHelper;
import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MITags;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.EnergyApi;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import aztech.modern_industrialization.compat.ae2.EnergyP2PTunnelPart;
import aztech.modern_industrialization.compat.ae2.pipe.MENetwork;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkData;
import aztech.modern_industrialization.compat.ae2.pipe.MENetworkNode;
import aztech.modern_industrialization.config.MIStartupConfig;
import aztech.modern_industrialization.datagen.tag.TagsToGenerate;
import aztech.modern_industrialization.definition.ItemDefinition;
import aztech.modern_industrialization.items.SortOrder;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.PipeColor;
import aztech.modern_industrialization.pipes.api.PipeNetworkData;
import aztech.modern_industrialization.pipes.api.PipeNetworkType;
import aztech.modern_industrialization.pipes.impl.PipeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;

public class MIAEAddon {
    public static final ItemDefinition<PartItem<EnergyP2PTunnelPart>> ENERGY_P2P_TUNNEL;
    public static final List<PipeNetworkType> PIPES;

    public static void init(IEventBus modBus) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(EnergyP2PTunnelPart.class));
        modBus.addListener(MIAEAddon::commonSetup);
        modBus.addListener(MIAEAddon::registerPartCapabilities);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        P2PTunnelAttunement.registerAttunementTag(ENERGY_P2P_TUNNEL);
        MITooltips.TooltipAttachment.of(ENERGY_P2P_TUNNEL, MIText.SuperconductorPowerOnly);
    }

    public static void registerPartCapabilities(RegisterPartCapabilitiesEvent event) {
        event.register(EnergyApi.SIDED, (part, context) -> (MIEnergyStorage)part.getExposedApi(), EnergyP2PTunnelPart.class);
    }

    public static void onInitializePipes() {
        for (PipeColor color : PipeColor.values()) {
            MIAEAddon.registerMEPipeType(color);
        }
        TagsToGenerate.markTagOptional(MITags.ME_WIRES);
    }

    private static void registerMEPipeType(PipeColor color) {
        AEColor aeColor = switch (color) {
            case PipeColor.REGULAR -> AEColor.TRANSPARENT;
            default -> {
                for (AEColor candidate : AEColor.values()) {
                    if (!candidate.registryPrefix.equals(color.name)) continue;
                    yield candidate;
                }
                throw new UnsupportedOperationException("No AE color for " + color.name);
            }
        };
        String pipeId = color.prefix + "me_wire";
        PipeNetworkType type = PipeNetworkType.register(MI.id(pipeId), (id, data) -> new MENetwork((int)id, (PipeNetworkData)data, aeColor), MENetworkNode::new, color.color, false);
        PIPES.add(type);
        ItemDefinition<PipeItem> itemDef = MIItem.item(color.englishNamePrefix + "ME Wire", pipeId, prop -> new PipeItem((Item.Properties)prop, type, new MENetworkData()), MIPipes.ITEM_MODEL_GENERATOR, SortOrder.PIPES);
        MIPipes.INSTANCE.register(type, itemDef::asItem);
        TagsToGenerate.generateTag(MITags.ME_WIRES, itemDef, "ME Wires");
    }

    static {
        if (!MIStartupConfig.INSTANCE.loadAe2Compat()) {
            throw new RuntimeException("AE2 compat is disabled. How did this get loaded?");
        }
        ENERGY_P2P_TUNNEL = MIItem.item("EU P2P Tunnel", "energy_p2p_tunnel", p -> new PartItem(new Item.Properties(), EnergyP2PTunnelPart.class, EnergyP2PTunnelPart::new), (item, gen) -> {}, SortOrder.CABLES.and(CableTier.SUPERCONDUCTOR).and((Comparable)((Object)"extra")));
        PIPES = new ArrayList<PipeNetworkType>();
    }
}

