/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MachineOverlay {
    private static final double SIDE = 0.25;
    public static final double[] ZONES = new double[]{0.0, 0.25, 0.75, 1.0};
    public static final List<VoxelShape> OVERLAY_SHAPES = new ArrayList<VoxelShape>();
    public static final List<List<Direction>> TOUCHING_DIRECTIONS = new ArrayList<List<Direction>>();

    public static Vec3 getPosInBlock(BlockHitResult blockHitResult) {
        BlockPos blockPos = blockHitResult.getBlockPos();
        return blockHitResult.getLocation().subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public static int findHitIndex(Vec3 posInBlock) {
        for (int i = 0; i < OVERLAY_SHAPES.size(); ++i) {
            Vec3 dir;
            AABB box = OVERLAY_SHAPES.get(i).bounds();
            if (!box.contains(posInBlock.add(dir = box.getCenter().subtract(posInBlock).normalize().scale(1.0E-4)))) continue;
            return i;
        }
        return 13;
    }

    public static Direction findHitSide(Vec3 posInBlock, Direction hitFace) {
        int i = MachineOverlay.findHitIndex(posInBlock);
        List<Direction> shapeDirections = TOUCHING_DIRECTIONS.get(i);
        if (shapeDirections.size() == 1) {
            return hitFace;
        }
        if (shapeDirections.size() == 3) {
            return hitFace.getOpposite();
        }
        for (Direction direction : shapeDirections) {
            if (direction == hitFace) continue;
            return direction;
        }
        return hitFace;
    }

    public static Direction findHitSide(BlockHitResult bhr) {
        return MachineOverlay.findHitSide(MachineOverlay.getPosInBlock(bhr), bhr.getDirection());
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    ArrayList<Direction> directions = new ArrayList<Direction>();
                    OVERLAY_SHAPES.add(Shapes.box((double)ZONES[i], (double)ZONES[j], (double)ZONES[k], (double)ZONES[i + 1], (double)ZONES[j + 1], (double)ZONES[k + 1]));
                    if (i == 0) {
                        directions.add(Direction.WEST);
                    }
                    if (i == 2) {
                        directions.add(Direction.EAST);
                    }
                    if (j == 0) {
                        directions.add(Direction.DOWN);
                    }
                    if (j == 2) {
                        directions.add(Direction.UP);
                    }
                    if (k == 0) {
                        directions.add(Direction.NORTH);
                    }
                    if (k == 2) {
                        directions.add(Direction.SOUTH);
                    }
                    TOUCHING_DIRECTIONS.add(directions);
                }
            }
        }
    }
}

