/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.guicomponents;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.machines.GuiComponents;
import aztech.modern_industrialization.machines.gui.GuiComponent;
import aztech.modern_industrialization.util.Rectangle;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ProgressBar {

    public static class Parameters {
        public final int renderX;
        public final int renderY;
        public final String progressBarType;
        public final boolean isVertical;

        public Parameters(int renderX, int renderY, String progressBarType) {
            this(renderX, renderY, progressBarType, false);
        }

        public Parameters(int renderX, int renderY, String progressBarType, boolean isVertical) {
            this.renderX = renderX;
            this.renderY = renderY;
            this.progressBarType = progressBarType;
            this.isVertical = isVertical;
        }

        public ResourceLocation getTextureId() {
            return MI.id("textures/gui/progress_bar/" + this.progressBarType + ".png");
        }

        public Rectangle toRectangle() {
            return new Rectangle(this.renderX, this.renderY, 20, 20);
        }
    }

    public static class Server
    implements GuiComponent.Server<Float> {
        private final Parameters params;
        private final Supplier<Float> progressSupplier;

        public Server(Parameters params, Supplier<Float> progressSupplier) {
            this.params = params;
            this.progressSupplier = progressSupplier;
        }

        @Override
        public Float copyData() {
            return this.progressSupplier.get();
        }

        @Override
        public boolean needsSync(Float cachedData) {
            return !cachedData.equals(this.progressSupplier.get());
        }

        @Override
        public void writeInitialData(RegistryFriendlyByteBuf buf) {
            buf.writeInt(this.params.renderX);
            buf.writeInt(this.params.renderY);
            buf.writeUtf(this.params.progressBarType);
            buf.writeBoolean(this.params.isVertical);
            this.writeCurrentData(buf);
        }

        @Override
        public void writeCurrentData(RegistryFriendlyByteBuf buf) {
            buf.writeFloat(this.progressSupplier.get().floatValue());
        }

        @Override
        public ResourceLocation getId() {
            return GuiComponents.PROGRESS_BAR;
        }
    }
}

