/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.CharArraySet;
import guideme.internal.shaded.lucene.analysis.WordlistLoader;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public abstract class StopwordAnalyzerBase
extends Analyzer {
    protected final CharArraySet stopwords;

    public CharArraySet getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(CharArraySet stopwords) {
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
    }

    protected StopwordAnalyzerBase() {
        this((CharArraySet)null);
    }

    protected static CharArraySet loadStopwordSet(Path stopwords) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(stopwords, StandardCharsets.UTF_8);){
            CharArraySet charArraySet = WordlistLoader.getWordSet(reader);
            return charArraySet;
        }
    }

    protected static CharArraySet loadStopwordSet(Reader stopwords) throws IOException {
        CharArraySet charArraySet;
        try {
            charArraySet = WordlistLoader.getWordSet(stopwords);
        }
        catch (Throwable throwable) {
            IOUtils.close(stopwords);
            throw throwable;
        }
        IOUtils.close(stopwords);
        return charArraySet;
    }
}

