/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenFilterFactory;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import java.util.Map;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "asciiFolding";
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveOriginal = this.getBoolean(args, PRESERVE_ORIGINAL, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public ASCIIFoldingFilterFactory() {
        throw ASCIIFoldingFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ASCIIFoldingFilter(input, this.preserveOriginal);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return new ASCIIFoldingFilter(input, false);
    }
}

