/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet;

import guideme.internal.shaded.lucene.facet.MultiDoubleValues;
import guideme.internal.shaded.lucene.facet.MultiLongValues;
import guideme.internal.shaded.lucene.facet.MultiLongValuesSource;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.search.SegmentCacheable;
import guideme.internal.shaded.lucene.util.NumericUtils;
import java.io.IOException;
import java.util.Objects;
import java.util.function.LongToDoubleFunction;

public abstract class MultiDoubleValuesSource
implements SegmentCacheable {
    public abstract MultiDoubleValues getValues(LeafReaderContext var1) throws IOException;

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static MultiDoubleValuesSource fromField(String field, LongToDoubleFunction decoder) {
        return new FieldMultiValuedSource(field, decoder);
    }

    public static MultiDoubleValuesSource fromDoubleField(String field) {
        return MultiDoubleValuesSource.fromField(field, Double::longBitsToDouble);
    }

    public static MultiDoubleValuesSource fromFloatField(String field) {
        return MultiDoubleValuesSource.fromField(field, v -> Float.intBitsToFloat((int)v));
    }

    public static MultiDoubleValuesSource fromLongField(String field) {
        return MultiDoubleValuesSource.fromField(field, v -> v);
    }

    public static MultiDoubleValuesSource fromIntField(String field) {
        return MultiDoubleValuesSource.fromLongField(field);
    }

    public static MultiDoubleValuesSource fromSingleValued(DoubleValuesSource singleValued) {
        return new SingleValuedAsMultiValued(singleValued);
    }

    public static DoubleValuesSource unwrapSingleton(MultiDoubleValuesSource in) {
        if (in instanceof SingleValuedAsMultiValued) {
            return ((SingleValuedAsMultiValued)in).in;
        }
        return null;
    }

    public final MultiLongValuesSource toMultiLongValuesSource() {
        return new LongDoubleValuesSource(this);
    }

    public final MultiLongValuesSource toSortableMultiLongValuesSource() {
        return new SortableMultiLongValuesSource(this);
    }

    private static class FieldMultiValuedSource
    extends MultiDoubleValuesSource {
        private final String field;
        private final LongToDoubleFunction decoder;

        FieldMultiValuedSource(String field, LongToDoubleFunction decoder) {
            this.field = field;
            this.decoder = decoder;
        }

        @Override
        public MultiDoubleValues getValues(LeafReaderContext ctx) throws IOException {
            final SortedNumericDocValues docValues = DocValues.getSortedNumeric(ctx.reader(), this.field);
            return new MultiDoubleValues(){

                @Override
                public long getValueCount() {
                    return docValues.docValueCount();
                }

                @Override
                public double nextValue() throws IOException {
                    return decoder.applyAsDouble(docValues.nextValue());
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return docValues.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable(ctx, this.field);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field, this.decoder);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldMultiValuedSource that = (FieldMultiValuedSource)o;
            return Objects.equals(this.field, that.field) && Objects.equals(this.decoder, that.decoder);
        }

        @Override
        public String toString() {
            return "multi-double(" + this.field + ")";
        }
    }

    private static class SingleValuedAsMultiValued
    extends MultiDoubleValuesSource {
        private final DoubleValuesSource in;

        SingleValuedAsMultiValued(DoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public MultiDoubleValues getValues(LeafReaderContext ctx) throws IOException {
            final DoubleValues singleValues = this.in.getValues(ctx, null);
            return new MultiDoubleValues(this){

                @Override
                public long getValueCount() {
                    return 1L;
                }

                @Override
                public double nextValue() throws IOException {
                    return singleValues.doubleValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleValuedAsMultiValued that = (SingleValuedAsMultiValued)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public String toString() {
            return "multi-double(" + String.valueOf(this.in) + ")";
        }
    }

    private static class LongDoubleValuesSource
    extends MultiLongValuesSource {
        private final MultiDoubleValuesSource in;

        LongDoubleValuesSource(MultiDoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public MultiLongValues getValues(LeafReaderContext ctx) throws IOException {
            final MultiDoubleValues doubleValues = this.in.getValues(ctx);
            return new MultiLongValues(this){

                @Override
                public long getValueCount() {
                    return doubleValues.getValueCount();
                }

                @Override
                public long nextValue() throws IOException {
                    return (long)doubleValues.nextValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return doubleValues.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.in.isCacheable(ctx);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LongDoubleValuesSource that = (LongDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public String toString() {
            return "multi-double(" + String.valueOf(this.in) + ")";
        }
    }

    private static class SortableMultiLongValuesSource
    extends MultiLongValuesSource {
        MultiDoubleValuesSource inner;

        SortableMultiLongValuesSource(MultiDoubleValuesSource inner) {
            this.inner = Objects.requireNonNull(inner);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx);
        }

        @Override
        public MultiLongValues getValues(LeafReaderContext ctx) throws IOException {
            final MultiDoubleValues doubleValues = this.inner.getValues(ctx);
            return new MultiLongValues(this){

                @Override
                public long getValueCount() {
                    return doubleValues.getValueCount();
                }

                @Override
                public long nextValue() throws IOException {
                    return NumericUtils.doubleToSortableLong(doubleValues.nextValue());
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return doubleValues.advanceExact(doc);
                }
            };
        }

        @Override
        public int hashCode() {
            return this.inner.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortableMultiLongValuesSource that = (SortableMultiLongValuesSource)o;
            return Objects.equals(this.inner, that.inner);
        }

        @Override
        public String toString() {
            return "sortableMultiLong(" + this.inner.toString() + ")";
        }
    }
}

