/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.facet.taxonomy;

import guideme.internal.shaded.lucene.facet.FacetsCollector;
import guideme.internal.shaded.lucene.facet.FacetsConfig;
import guideme.internal.shaded.lucene.facet.taxonomy.AssociationAggregationFunction;
import guideme.internal.shaded.lucene.facet.taxonomy.FloatTaxonomyFacets;
import guideme.internal.shaded.lucene.facet.taxonomy.TaxonomyReader;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.search.ConjunctionUtils;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.DoubleValues;
import guideme.internal.shaded.lucene.search.DoubleValuesSource;
import guideme.internal.shaded.lucene.util.BitUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TaxonomyFacetFloatAssociations
extends FloatTaxonomyFacets {
    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction);
    }

    public TaxonomyFacetFloatAssociations(TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        this("$facets", taxoReader, config, fc, aggregationFunction, valuesSource);
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs());
    }

    public TaxonomyFacetFloatAssociations(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc, AssociationAggregationFunction aggregationFunction, DoubleValuesSource valuesSource) throws IOException {
        super(indexFieldName, taxoReader, aggregationFunction, config, fc);
        this.aggregateValues(aggregationFunction, fc.getMatchingDocs(), fc.getKeepScores(), valuesSource);
    }

    private static DoubleValues scores(final FacetsCollector.MatchingDocs hits) {
        return new DoubleValues(){
            int index = -1;

            @Override
            public double doubleValue() throws IOException {
                return hits.scores()[this.index];
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.index = doc;
                return true;
            }
        };
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs, boolean keepScores, DoubleValuesSource valueSource) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeValueCounters();
            SortedNumericDocValues ordinalValues = DocValues.getSortedNumeric(hits.context().reader(), this.indexFieldName);
            DoubleValues scores = keepScores ? TaxonomyFacetFloatAssociations.scores(hits) : null;
            DoubleValues functionValues = valueSource.getValues(hits.context(), scores);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(List.of(hits.bits().iterator(), ordinalValues));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (functionValues.advanceExact(doc)) {
                    float value = (float)functionValues.doubleValue();
                    int ordinalCount = ordinalValues.docValueCount();
                    for (int i = 0; i < ordinalCount; ++i) {
                        int ord = (int)ordinalValues.nextValue();
                        float currentValue = this.getValue(ord);
                        float newValue = aggregationFunction.aggregate(currentValue, value);
                        this.setValue(ord, newValue);
                        this.setCount(ord, this.getCount(ord) + 1);
                    }
                }
                doc = it.nextDoc();
            }
        }
        this.rollup();
    }

    private void aggregateValues(AssociationAggregationFunction aggregationFunction, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (hits.totalHits() == 0) continue;
            this.initializeValueCounters();
            BinaryDocValues dv = DocValues.getBinary(hits.context().reader(), this.indexFieldName);
            DocIdSetIterator it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits().iterator(), dv));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                BytesRef bytesRef = dv.binaryValue();
                byte[] bytes = bytesRef.bytes;
                int end = bytesRef.offset + bytesRef.length;
                for (int offset = bytesRef.offset; offset < end; offset += 4) {
                    int ord = BitUtil.VH_BE_INT.get(bytes, offset);
                    float value = BitUtil.VH_BE_FLOAT.get(bytes, offset += 4);
                    float currentValue = this.getValue(ord);
                    float newValue = aggregationFunction.aggregate(currentValue, value);
                    this.setValue(ord, newValue);
                    this.setCount(ord, this.getCount(ord) + 1);
                }
                doc = it.nextDoc();
            }
        }
    }
}

