/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BaseTermsEnum;
import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.MultiPostingsEnum;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.ReaderSlice;
import guideme.internal.shaded.lucene.index.SlowImpactsEnum;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.index.TermsEnumIndex;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.PriorityQueue;
import java.io.IOException;
import java.util.Arrays;

public final class MultiTermsEnum
extends BaseTermsEnum {
    private final TermMergeQueue queue;
    private final TermsEnumWithSlice[] subs;
    private final TermsEnumWithSlice[] currentSubs;
    private final TermsEnumWithSlice[] top;
    private final MultiPostingsEnum.EnumWithSlice[] subDocs;
    private BytesRef lastSeek;
    private boolean lastSeekExact;
    private final BytesRefBuilder lastSeekScratch = new BytesRefBuilder();
    private int numTop;
    private int numSubs;
    private BytesRef current;

    public int getMatchCount() {
        return this.numTop;
    }

    public TermsEnumWithSlice[] getMatchArray() {
        return this.top;
    }

    public MultiTermsEnum(ReaderSlice[] slices) {
        this.queue = new TermMergeQueue(slices.length);
        this.top = new TermsEnumWithSlice[slices.length];
        this.subs = new TermsEnumWithSlice[slices.length];
        this.subDocs = new MultiPostingsEnum.EnumWithSlice[slices.length];
        for (int i = 0; i < slices.length; ++i) {
            this.subs[i] = new TermsEnumWithSlice(i, slices[i]);
            this.subDocs[i] = new MultiPostingsEnum.EnumWithSlice();
            this.subDocs[i].slice = slices[i];
        }
        this.currentSubs = new TermsEnumWithSlice[slices.length];
    }

    @Override
    public BytesRef term() {
        return this.current;
    }

    public TermsEnum reset(TermsEnumIndex[] termsEnumsIndex) throws IOException {
        assert (termsEnumsIndex.length <= this.top.length);
        this.numSubs = 0;
        this.numTop = 0;
        this.queue.clear();
        for (int i = 0; i < termsEnumsIndex.length; ++i) {
            TermsEnumIndex termsEnumIndex = termsEnumsIndex[i];
            assert (termsEnumIndex != null);
            BytesRef term = termsEnumIndex.next();
            if (term == null) continue;
            TermsEnumWithSlice entry = this.subs[termsEnumIndex.subIndex];
            entry.reset(termsEnumIndex);
            this.queue.add(entry);
            this.currentSubs[this.numSubs++] = entry;
        }
        if (this.queue.size() == 0) {
            return TermsEnum.EMPTY;
        }
        return this;
    }

    @Override
    public boolean seekExact(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeek = null;
        this.lastSeekExact = true;
        for (int i = 0; i < this.numSubs; ++i) {
            int cmp;
            BytesRef curTerm;
            boolean status = seekOpt ? ((curTerm = this.currentSubs[i].term()) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? true : (cmp < 0 ? false : this.currentSubs[i].seekExact(term))) : false) : this.currentSubs[i].seekExact(term);
            if (!status) continue;
            this.top[this.numTop++] = this.currentSubs[i];
            this.current = this.currentSubs[i].term();
            assert (term.equals(this.currentSubs[i].term()));
        }
        return this.numTop > 0;
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
        this.queue.clear();
        this.numTop = 0;
        this.lastSeekExact = false;
        boolean seekOpt = false;
        if (this.lastSeek != null && this.lastSeek.compareTo(term) <= 0) {
            seekOpt = true;
        }
        this.lastSeekScratch.copyBytes(term);
        this.lastSeek = this.lastSeekScratch.get();
        for (int i = 0; i < this.numSubs; ++i) {
            int cmp;
            BytesRef curTerm;
            TermsEnum.SeekStatus status = seekOpt ? ((curTerm = this.currentSubs[i].term()) != null ? ((cmp = term.compareTo(curTerm)) == 0 ? TermsEnum.SeekStatus.FOUND : (cmp < 0 ? TermsEnum.SeekStatus.NOT_FOUND : this.currentSubs[i].seekCeil(term))) : TermsEnum.SeekStatus.END) : this.currentSubs[i].seekCeil(term);
            if (status == TermsEnum.SeekStatus.FOUND) {
                this.top[this.numTop++] = this.currentSubs[i];
                this.current = this.currentSubs[i].term();
                this.queue.add(this.currentSubs[i]);
                continue;
            }
            if (status == TermsEnum.SeekStatus.NOT_FOUND) {
                assert (this.currentSubs[i].term() != null);
                this.queue.add(this.currentSubs[i]);
                continue;
            }
            assert (status == TermsEnum.SeekStatus.END);
        }
        if (this.numTop > 0) {
            return TermsEnum.SeekStatus.FOUND;
        }
        if (this.queue.size() > 0) {
            this.pullTop();
            return TermsEnum.SeekStatus.NOT_FOUND;
        }
        return TermsEnum.SeekStatus.END;
    }

    @Override
    public void seekExact(long ord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long ord() {
        throw new UnsupportedOperationException();
    }

    private void pullTop() {
        assert (this.numTop == 0);
        this.numTop = this.queue.fillTop(this.top);
        this.current = this.top[0].term();
    }

    private void pushTop() throws IOException {
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithSlice top = (TermsEnumWithSlice)this.queue.top();
            if (top.next() == null) {
                this.queue.pop();
                continue;
            }
            this.queue.updateTop();
        }
        this.numTop = 0;
    }

    @Override
    public BytesRef next() throws IOException {
        if (this.lastSeekExact) {
            TermsEnum.SeekStatus status = this.seekCeil(this.current);
            assert (status == TermsEnum.SeekStatus.FOUND);
            this.lastSeekExact = false;
        }
        this.lastSeek = null;
        this.pushTop();
        if (this.queue.size() > 0) {
            this.pullTop();
        } else {
            this.current = null;
        }
        return this.current;
    }

    @Override
    public int docFreq() throws IOException {
        int sum = 0;
        for (int i = 0; i < this.numTop; ++i) {
            sum += this.top[i].termsEnum.docFreq();
        }
        return sum;
    }

    @Override
    public long totalTermFreq() throws IOException {
        long sum = 0L;
        for (int i = 0; i < this.numTop; ++i) {
            long v = this.top[i].termsEnum.totalTermFreq();
            assert (v != -1L);
            sum += v;
        }
        return sum;
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        MultiPostingsEnum docsEnum;
        if (reuse != null && reuse instanceof MultiPostingsEnum) {
            docsEnum = (MultiPostingsEnum)reuse;
            if (!docsEnum.canReuse(this)) {
                docsEnum = new MultiPostingsEnum(this, this.subs.length);
            }
        } else {
            docsEnum = new MultiPostingsEnum(this, this.subs.length);
        }
        int upto = 0;
        ArrayUtil.timSort(this.top, 0, this.numTop, (o1, o2) -> o1.subIndex - o2.subIndex);
        for (int i = 0; i < this.numTop; ++i) {
            TermsEnumWithSlice entry = this.top[i];
            assert (entry.subIndex < docsEnum.subPostingsEnums.length) : entry.subIndex + " vs " + docsEnum.subPostingsEnums.length + "; " + this.subs.length;
            PostingsEnum subPostingsEnum = entry.termsEnum.postings(docsEnum.subPostingsEnums[entry.subIndex], flags);
            assert (subPostingsEnum != null);
            docsEnum.subPostingsEnums[entry.subIndex] = subPostingsEnum;
            this.subDocs[upto].postingsEnum = subPostingsEnum;
            this.subDocs[upto].slice = entry.subSlice;
            ++upto;
        }
        return docsEnum.reset(this.subDocs, upto);
    }

    @Override
    public ImpactsEnum impacts(int flags) throws IOException {
        return new SlowImpactsEnum(this.postings(null, flags));
    }

    public String toString() {
        return "MultiTermsEnum(" + Arrays.toString(this.subs) + ")";
    }

    static final class TermsEnumWithSlice
    extends TermsEnumIndex {
        private final ReaderSlice subSlice;

        public TermsEnumWithSlice(int index, ReaderSlice subSlice) {
            super(null, index);
            this.subSlice = subSlice;
            assert (subSlice.length() >= 0) : "length=" + subSlice.length();
        }

        @Override
        public String toString() {
            return this.subSlice.toString() + ":" + super.toString();
        }
    }

    private static final class TermMergeQueue
    extends PriorityQueue<TermsEnumWithSlice> {
        final int[] stack;

        TermMergeQueue(int size) {
            super(size);
            this.stack = new int[size];
        }

        @Override
        protected boolean lessThan(TermsEnumWithSlice termsA, TermsEnumWithSlice termsB) {
            return termsA.compareTermTo(termsB) < 0;
        }

        int fillTop(TermsEnumWithSlice[] tops) {
            int size = this.size();
            if (size == 0) {
                return 0;
            }
            tops[0] = (TermsEnumWithSlice)this.top();
            int numTop = 1;
            this.stack[0] = 1;
            int stackLen = 1;
            while (stackLen != 0) {
                int leftChild;
                int index = this.stack[--stackLen];
                int end = Math.min(size, leftChild + 1);
                for (int child = leftChild = index << 1; child <= end; ++child) {
                    TermsEnumWithSlice te = this.get(child);
                    if (te.compareTermTo(tops[0]) != 0) continue;
                    tops[numTop++] = te;
                    this.stack[stackLen++] = child;
                }
            }
            return numTop;
        }

        private TermsEnumWithSlice get(int i) {
            return (TermsEnumWithSlice)this.getHeapArray()[i];
        }
    }
}

