/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.uhighlight;

import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;

public class Passage {
    private int startOffset = -1;
    private int endOffset = -1;
    private float score = 0.0f;
    private int[] matchStarts = new int[8];
    private int[] matchEnds = new int[8];
    private BytesRef[] matchTerms = new BytesRef[8];
    private int[] matchTermFreqInDoc = new int[8];
    private int numMatches = 0;

    public void addMatch(int startOffset, int endOffset, BytesRef term, int termFreqInDoc) {
        assert (startOffset >= this.startOffset && startOffset <= this.endOffset);
        if (this.numMatches == this.matchStarts.length) {
            int newLength = ArrayUtil.oversize(this.numMatches + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            int[] newMatchStarts = new int[newLength];
            int[] newMatchEnds = new int[newLength];
            int[] newMatchTermFreqInDoc = new int[newLength];
            BytesRef[] newMatchTerms = new BytesRef[newLength];
            System.arraycopy(this.matchStarts, 0, newMatchStarts, 0, this.numMatches);
            System.arraycopy(this.matchEnds, 0, newMatchEnds, 0, this.numMatches);
            System.arraycopy(this.matchTerms, 0, newMatchTerms, 0, this.numMatches);
            System.arraycopy(this.matchTermFreqInDoc, 0, newMatchTermFreqInDoc, 0, this.numMatches);
            this.matchStarts = newMatchStarts;
            this.matchEnds = newMatchEnds;
            this.matchTerms = newMatchTerms;
            this.matchTermFreqInDoc = newMatchTermFreqInDoc;
        }
        assert (this.matchStarts.length == this.matchEnds.length && this.matchEnds.length == this.matchTerms.length);
        this.matchStarts[this.numMatches] = startOffset;
        this.matchEnds[this.numMatches] = endOffset;
        this.matchTerms[this.numMatches] = term;
        this.matchTermFreqInDoc[this.numMatches] = termFreqInDoc;
        ++this.numMatches;
    }

    public void reset() {
        this.endOffset = -1;
        this.startOffset = -1;
        this.score = 0.0f;
        this.numMatches = 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Passage[").append(this.startOffset).append('-').append(this.endOffset).append(']');
        buf.append('{');
        for (int i = 0; i < this.numMatches; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.matchTerms[i].utf8ToString());
            buf.append('[').append(this.matchStarts[i] - this.startOffset).append('-').append(this.matchEnds[i] - this.startOffset).append(']');
        }
        buf.append('}');
        buf.append("score=").append(this.score);
        return buf.toString();
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public int getNumMatches() {
        return this.numMatches;
    }

    public int[] getMatchStarts() {
        return this.matchStarts;
    }

    public int[] getMatchEnds() {
        return this.matchEnds;
    }

    public BytesRef[] getMatchTerms() {
        return this.matchTerms;
    }

    public int[] getMatchTermFreqsInDoc() {
        return this.matchTermFreqInDoc;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public void setEndOffset(int endOffset) {
        assert (this.startOffset <= endOffset);
        this.endOffset = endOffset;
    }
}

