/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.hnsw;

import guideme.internal.shaded.lucene.codecs.hnsw.HnswGraphProvider;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.KnnVectorValues;
import guideme.internal.shaded.lucene.search.TaskExecutor;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.hnsw.HnswBuilder;
import guideme.internal.shaded.lucene.util.hnsw.HnswConcurrentMergeBuilder;
import guideme.internal.shaded.lucene.util.hnsw.HnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.IncrementalHnswGraphMerger;
import guideme.internal.shaded.lucene.util.hnsw.InitializedHnswGraphBuilder;
import guideme.internal.shaded.lucene.util.hnsw.OnHeapHnswGraph;
import guideme.internal.shaded.lucene.util.hnsw.RandomVectorScorerSupplier;
import java.io.IOException;

public class ConcurrentHnswMerger
extends IncrementalHnswGraphMerger {
    private final TaskExecutor taskExecutor;
    private final int numWorker;

    public ConcurrentHnswMerger(FieldInfo fieldInfo, RandomVectorScorerSupplier scorerSupplier, int M, int beamWidth, TaskExecutor taskExecutor, int numWorker) {
        super(fieldInfo, scorerSupplier, M, beamWidth);
        this.taskExecutor = taskExecutor;
        this.numWorker = numWorker;
    }

    @Override
    protected HnswBuilder createBuilder(KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        if (this.initReader == null) {
            return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, new OnHeapHnswGraph(this.M, maxOrd), null);
        }
        HnswGraph initializerGraph = ((HnswGraphProvider)((Object)this.initReader)).getGraph(this.fieldInfo.name);
        FixedBitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
        return new HnswConcurrentMergeBuilder(this.taskExecutor, this.numWorker, this.scorerSupplier, this.M, this.beamWidth, InitializedHnswGraphBuilder.initGraph(this.M, initializerGraph, oldToNewOrdinalMap, maxOrd), initializedNodes);
    }
}

