/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render;

import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.common.entities.ally.illager.Prisoner;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.utils.ColorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.VillagerProfessionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class PrisonerRenderer
extends MobRenderer<Prisoner, VillagerModel<Prisoner>> {
    private static final ResourceLocation VILLAGER_BASE_SKIN = new ResourceLocation("textures/entity/villager/villager.png");
    private static final ResourceLocation TRADER = new ResourceLocation("textures/entity/wandering_trader.png");
    private static final ResourceLocation CHAIN = Goety.location("textures/entity/servants/prisoner_chain.png");

    public PrisonerRenderer(EntityRendererProvider.Context p_174437_) {
        super(p_174437_, (EntityModel)new VillagerModel(p_174437_.m_174023_(ModelLayers.f_171210_)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, p_174437_.m_174027_(), p_174437_.m_234598_()));
        this.m_115326_((RenderLayer)new VillagerProfessionLayer<Prisoner, VillagerModel<Prisoner>>((RenderLayerParent)this, p_174437_.m_174026_(), "villager"){

            public void render(PoseStack p_117646_, MultiBufferSource p_117647_, int p_117648_, Prisoner p_117649_, float p_117650_, float p_117651_, float p_117652_, float p_117653_, float p_117654_, float p_117655_) {
                if (!p_117649_.isTrader()) {
                    super.m_6494_(p_117646_, p_117647_, p_117648_, (LivingEntity)p_117649_, p_117650_, p_117651_, p_117652_, p_117653_, p_117654_, p_117655_);
                }
            }
        });
        this.m_115326_(new ShacklesLayer(this, p_174437_.m_174027_()));
        this.m_115326_((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this, p_174437_.m_234598_()));
    }

    public ResourceLocation getTextureLocation(Prisoner p_116312_) {
        if (p_116312_.isTrader()) {
            return TRADER;
        }
        return VILLAGER_BASE_SKIN;
    }

    protected void scale(Prisoner p_116314_, PoseStack p_116315_, float p_116316_) {
        float f = 0.9375f;
        if (p_116314_.m_6162_() && !p_116314_.isTrader()) {
            f *= 0.5f;
            this.f_114477_ = 0.25f;
        } else {
            this.f_114477_ = 0.5f;
        }
        p_116315_.m_85841_(f, f, f);
    }

    public boolean shouldRender(Prisoner p_115468_, Frustum p_115469_, double p_115470_, double p_115471_, double p_115472_) {
        if (super.m_5523_((Mob)p_115468_, p_115469_, p_115470_, p_115471_, p_115472_)) {
            return true;
        }
        RaiderServant entity = p_115468_.getLeader();
        if (entity == null) {
            entity = p_115468_.getTrueOwner();
        }
        return entity != null && p_115469_.m_113029_(entity.m_6921_());
    }

    public void render(Prisoner p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        super.m_7392_((Mob)p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        RaiderServant entity = p_115455_.getLeader();
        if (entity == null) {
            entity = p_115455_.getTrueOwner();
        }
        if (entity != null && entity.m_20270_((Entity)p_115455_) <= 32.0f && p_115455_.isFollowing()) {
            this.renderChain(p_115455_, p_115457_, p_115458_, p_115459_, entity);
        }
    }

    private <E extends Entity> void renderChain(Prisoner p_115462_, float p_115463_, PoseStack p_115464_, MultiBufferSource p_115465_, E p_115466_) {
        p_115464_.m_85836_();
        Vec3 vec3 = p_115466_.m_7398_(p_115463_);
        double d0 = (double)(Mth.m_14179_((float)p_115463_, (float)p_115462_.f_20884_, (float)p_115462_.f_20883_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = p_115462_.m_245894_(p_115463_);
        double d1 = Math.cos(d0) * vec31.f_82481_ + Math.sin(d0) * vec31.f_82479_;
        double d2 = Math.sin(d0) * vec31.f_82481_ - Math.cos(d0) * vec31.f_82479_;
        double d3 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19854_, (double)p_115462_.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19855_, (double)p_115462_.m_20186_()) + vec31.f_82480_;
        double d5 = Mth.m_14139_((double)p_115463_, (double)p_115462_.f_19856_, (double)p_115462_.m_20189_()) + d2;
        p_115464_.m_85837_(d1, vec31.f_82480_, d2);
        float f = (float)(vec3.f_82479_ - d3);
        float f1 = (float)(vec3.f_82480_ - d4);
        float f2 = (float)(vec3.f_82481_ - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = p_115465_.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = p_115464_.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.m_274446_((Position)p_115462_.m_20299_(p_115463_));
        BlockPos blockpos1 = BlockPos.m_274446_((Position)p_115466_.m_20299_(p_115463_));
        int i = this.m_6086_((Entity)p_115462_, blockpos);
        int j = this.m_6086_((Entity)p_115462_, blockpos1);
        int k = p_115462_.f_19853_.m_45517_(LightLayer.SKY, blockpos);
        int l = p_115462_.f_19853_.m_45517_(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            PrisonerRenderer.m_174307_(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.025f, f5, f6, i1, false);
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            PrisonerRenderer.m_174307_(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.025f, 0.0f, f5, f6, j1, true);
        }
        p_115464_.m_85849_();
    }

    private static void m_174307_(VertexConsumer p_174308_, Matrix4f p_254405_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.m_14179_((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.m_14179_((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.m_109885_((int)i, (int)j);
        ColorUtil light = new ColorUtil(9678509);
        ColorUtil dark = new ColorUtil(6719365);
        float f2 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? dark.red() : light.red();
        float f3 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? dark.green() : light.green();
        float f4 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? dark.blue() : light.blue();
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.m_252986_(p_254405_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
        p_174308_.m_252986_(p_254405_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).m_85950_(f2, f3, f4, 1.0f).m_85969_(k).m_5752_();
    }

    public static class ShacklesLayer<T extends Prisoner, M extends VillagerModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation SHACKLES = Goety.location("textures/entity/servants/prisoner_shackles.png");
        private final VillagerModel<T> layerModel;

        public ShacklesLayer(RenderLayerParent<T, M> p_i50919_1_, EntityModelSet p_174555_) {
            super(p_i50919_1_);
            this.layerModel = new VillagerModel(p_174555_.m_171103_(ModelLayers.f_171210_));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.m_20145_()) {
                ShacklesLayer.m_117359_((EntityModel)this.m_117386_(), this.layerModel, (ResourceLocation)SHACKLES, (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)packedLightIn, entitylivingbaseIn, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }
}

