/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.init.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneGolemSkullBlockEntity
extends SkullBlockEntity {
    private UUID ownerUUID;
    private String customName;

    public RedstoneGolemSkullBlockEntity(BlockPos p_155731_, BlockState p_155732_) {
        super(p_155731_, p_155732_);
    }

    public BlockEntityType<?> m_58903_() {
        return (BlockEntityType)ModBlockEntities.REDSTONE_GOLEM_SKULL.get();
    }

    public CompoundTag m_5995_() {
        return this.writeNetwork(super.m_5995_());
    }

    public void m_142466_(CompoundTag nbt) {
        this.readNetwork(nbt);
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        this.writeNetwork(compound);
        super.m_183515_(compound);
    }

    @Nullable
    public ResourceLocation m_262374_() {
        return ((SoundEvent)ModSounds.REDSTONE_GOLEM_AMBIENT.get()).m_11660_();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nullable
    public String getCustomName() {
        return this.customName;
    }

    public void readNetwork(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.setOwnerId(tag.m_128342_("Owner"));
        }
        if (tag.m_128441_("mod_custom_name")) {
            this.setCustomName(tag.m_128461_("mod_custom_name"));
        }
    }

    public CompoundTag writeNetwork(CompoundTag tag) {
        if (this.getOwnerId() != null) {
            tag.m_128362_("Owner", this.getOwnerId());
        }
        if (this.getCustomName() != null && !this.getCustomName().isEmpty()) {
            tag.m_128359_("mod_custom_name", this.getCustomName());
        }
        return tag;
    }

    public ClientboundBlockEntityDataPacket m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public UUID getOwnerId() {
        return this.ownerUUID;
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.ownerUUID = p_184754_1_;
    }

    public void setOwner(LivingEntity livingEntity) {
        this.setOwnerId(livingEntity.m_20148_());
    }

    public LivingEntity getTrueOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.f_58857_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public Player getPlayer() {
        return (Player)this.getTrueOwner();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.readNetwork(pkt.m_131708_());
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.m_142466_(tag);
        this.readNetwork(tag);
    }
}

