/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.illager.RaiderServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Prisoner
extends RaiderServant
implements VillagerDataHolder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> IS_TRADER = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<VillagerData> DATA_VILLAGER_DATA = SynchedEntityData.m_135353_(Prisoner.class, (EntityDataSerializer)EntityDataSerializers.f_135043_);
    @Nullable
    private Tag gossips;
    @Nullable
    private CompoundTag tradeOffers;
    private int villagerXp;

    public Prisoner(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(6, (Goal)new Summoned.FollowOwnerGoal<Prisoner>(this, 0.6, 6.0f, 2.0f){

            @Override
            public boolean m_8036_() {
                if (Prisoner.this.getLeader() != null) {
                    RaiderServant livingentity = Prisoner.this.getLeader();
                    if (livingentity == null) {
                        return false;
                    }
                    if (livingentity.m_5833_()) {
                        return false;
                    }
                    if (Prisoner.this.m_20280_((Entity)livingentity) < (double)Mth.m_14207_((float)this.startDistance)) {
                        return false;
                    }
                    if (!Prisoner.this.isFollowing() || Prisoner.this.isCommanded()) {
                        return false;
                    }
                    if (Prisoner.this.m_5448_() != null) {
                        return false;
                    }
                    this.owner = livingentity;
                    return true;
                }
                return super.m_8036_();
            }
        });
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_TRADER, (Object)false);
        this.f_19804_.m_135372_(DATA_VILLAGER_DATA, (Object)new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    @Override
    public void m_7380_(CompoundTag p_34397_) {
        super.m_7380_(p_34397_);
        VillagerData.f_35550_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_7141_()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_204072_ -> p_34397_.m_128365_("VillagerData", p_204072_));
        if (this.tradeOffers != null) {
            p_34397_.m_128365_("Offers", (Tag)this.tradeOffers);
        }
        if (this.gossips != null) {
            p_34397_.m_128365_("Gossips", this.gossips);
        }
        p_34397_.m_128405_("Xp", this.villagerXp);
        p_34397_.m_128379_("Trader", this.isTrader());
    }

    @Override
    public void m_7378_(CompoundTag p_34387_) {
        super.m_7378_(p_34387_);
        if (p_34387_.m_128425_("VillagerData", 10)) {
            DataResult dataresult = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_34387_.m_128423_("VillagerData")));
            dataresult.resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::m_34375_);
        }
        if (p_34387_.m_128425_("Offers", 10)) {
            this.tradeOffers = p_34387_.m_128469_("Offers");
        }
        if (p_34387_.m_128425_("Gossips", 9)) {
            this.gossips = p_34387_.m_128437_("Gossips", 10);
        }
        if (p_34387_.m_128425_("Xp", 3)) {
            this.villagerXp = p_34387_.m_128451_("Xp");
        }
        if (p_34387_.m_128441_("Trader")) {
            this.setIsTrader(p_34387_.m_128471_("Trader"));
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.isTrader()) {
            return SoundEvents.f_12588_;
        }
        return SoundEvents.f_12507_;
    }

    protected SoundEvent m_7975_(DamageSource p_35498_) {
        if (this.isTrader()) {
            return SoundEvents.f_12587_;
        }
        return SoundEvents.f_12506_;
    }

    protected SoundEvent m_5592_() {
        if (this.isTrader()) {
            return SoundEvents.f_12583_;
        }
        return SoundEvents.f_12505_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            float f;
            RaiderServant raider;
            LivingEntity livingEntity = this.getTrueOwner();
            if (livingEntity instanceof RaiderServant && (raider = (RaiderServant)livingEntity).getLeader() != null && this.getLeader() != raider.getLeader()) {
                this.setLeader(raider.getLeader());
                if (raider.getLeader().getTrueOwner() != null) {
                    this.setTrueOwner(raider.getLeader().getTrueOwner());
                }
            }
            if (this.getLeader() == null && this.getMasterOwner() != null && this.isFollowing() && (f = this.m_20270_((Entity)this.getMasterOwner())) > 6.0f) {
                double d0 = (this.getMasterOwner().m_20185_() - this.m_20185_()) / (double)f;
                double d1 = (this.getMasterOwner().m_20186_() - this.m_20186_()) / (double)f;
                double d2 = (this.getMasterOwner().m_20189_() - this.m_20189_()) / (double)f;
                this.m_20256_(this.m_20184_().m_82520_(Math.copySign(d0 * d0 * 0.4, d0), Math.copySign(d1 * d1 * 0.4, d1), Math.copySign(d2 * d2 * 0.4, d2)));
                this.m_245125_();
            }
        }
    }

    public VillagerData m_7141_() {
        return (VillagerData)this.f_19804_.m_135370_(DATA_VILLAGER_DATA);
    }

    public void m_34375_(VillagerData p_34376_) {
        VillagerData villagerdata = this.m_7141_();
        if (villagerdata.m_35571_() != p_34376_.m_35571_()) {
            this.tradeOffers = null;
        }
        this.f_19804_.m_135381_(DATA_VILLAGER_DATA, (Object)p_34376_);
    }

    @Override
    public void setHostile(boolean hostile) {
    }

    @Override
    public boolean isHostile() {
        return false;
    }

    @Override
    public void onStopAttack() {
    }

    public boolean isTrader() {
        return (Boolean)this.f_19804_.m_135370_(IS_TRADER);
    }

    public void setIsTrader(boolean isTrader) {
        this.f_19804_.m_135381_(IS_TRADER, (Object)isTrader);
    }

    public void setTradeOffers(CompoundTag p_34412_) {
        this.tradeOffers = p_34412_;
    }

    public void setGossips(Tag p_34392_) {
        this.gossips = p_34392_;
    }

    public int getVillagerXp() {
        return this.villagerXp;
    }

    public void setVillagerXp(int p_34374_) {
        this.villagerXp = p_34374_;
    }

    @Override
    public void mobSense() {
    }

    @Override
    @Nullable
    public LivingEntity getMarked() {
        return null;
    }

    @Override
    @Nullable
    public BlockPos getRaidPos() {
        return null;
    }

    @Override
    public boolean isRaiding() {
        return false;
    }

    @Override
    public boolean isCapturing() {
        return false;
    }

    @Override
    public boolean canCelebrate() {
        return false;
    }

    @Override
    public boolean canJoinPatrol() {
        return false;
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null) {
            boolean flag;
            boolean bl = flag = this.getLeader() == null || (double)this.m_20270_((Entity)this.getLeader()) > 8.0;
            if (this.getMasterOwner() == null || (double)this.m_20270_((Entity)this.getMasterOwner()) > 8.0) {
                flag = true;
            }
            if (flag && this.m_21223_() - amount > 0.0f && this.f_19853_.m_213780_().m_188501_() <= amount / this.m_21223_()) {
                Player player = null;
                Entity entity = source.m_7639_();
                if (entity instanceof Player) {
                    Player player1;
                    player = player1 = (Player)entity;
                }
                this.unshackle(player);
            }
        }
        return super.m_6469_(source, amount);
    }

    public void unshackle(@Nullable Player player) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11794_, this.m_5720_(), 1.0f, 2.0f);
            AbstractVillager villager = (AbstractVillager)this.m_21406_(EntityType.f_20492_, true);
            if (this.isTrader()) {
                villager = (AbstractVillager)this.m_21406_(EntityType.f_20494_, true);
            }
            if (villager == null) {
                return;
            }
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                ItemStack itemstack = this.m_6844_(equipmentslot);
                if (itemstack.m_41619_()) continue;
                if (EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
                    villager.m_141942_(equipmentslot.m_20749_() + 300).m_142104_(itemstack);
                    continue;
                }
                double d0 = this.m_21519_(equipmentslot);
                if (!(d0 > 1.0)) continue;
                this.m_19983_(itemstack);
            }
            if (villager instanceof Villager) {
                LivingEntity livingEntity;
                Villager villager1 = (Villager)villager;
                villager1.m_34375_(this.m_7141_());
                if (this.gossips != null) {
                    villager1.m_35455_(this.gossips);
                }
                if (this.tradeOffers != null) {
                    villager1.m_35476_(new MerchantOffers(this.tradeOffers));
                }
                villager1.m_35546_(this.villagerXp);
                villager1.m_35483_(serverLevel);
                if (player instanceof ServerPlayer && player != this.getMasterOwner() && !MobUtil.areAllies((Entity)player, (Entity)this.getMasterOwner())) {
                    serverLevel.m_8670_(ReputationEventType.f_26985_, (Entity)player, (ReputationEventHandler)villager1);
                    villager1.m_216990_(SoundEvents.f_12504_);
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)villager1);
                }
                if ((livingEntity = this.getMasterOwner()) instanceof Player) {
                    Player player1 = (Player)livingEntity;
                    villager1.m_35517_().m_26191_(player1.m_20148_(), GossipType.MAJOR_NEGATIVE, 200);
                }
            } else if (villager instanceof WanderingTrader) {
                LivingEntity livingEntity;
                if (player instanceof ServerPlayer && player != this.getMasterOwner() && !MobUtil.areAllies((Entity)player, (Entity)this.getMasterOwner())) {
                    villager.m_216990_(SoundEvents.f_12539_);
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_123748_, (Entity)villager);
                }
                if ((livingEntity = this.getMasterOwner()) instanceof Player) {
                    Player player1 = (Player)livingEntity;
                    villager.m_6598_(player1);
                } else if (this.getMasterOwner() != null) {
                    villager.m_6703_(this.getMasterOwner());
                }
            }
            ServerParticleUtil.addParticlesAroundMiddleSelf(serverLevel, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50184_.m_49966_()), (Entity)villager);
            villager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(villager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
            villager.m_21153_(this.m_21223_());
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)villager);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pPlayer.m_6047_()) {
            this.unshackle(pPlayer);
            return InteractionResult.SUCCESS;
        }
        if (this.getMasterOwner() != null && this.getMasterOwner() == pPlayer && this.getLeader() != null) {
            this.setLeader(null);
            this.setFollowing();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

