/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.entities.ally.IServant;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.ItemConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class AbstractReaper
extends Summoned {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(AbstractReaper.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(AbstractReaper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackTick;
    public int deathTime = 0;
    public float fly;
    public float flySpeed;
    public float oFlySpeed;
    public float oFly;
    private float flying = 1.0f;
    private float nextFly = 1.0f;
    public static String IDLE = "idle";
    public static String ATTACK = "attack";
    public static String DEATH = "death";
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public AbstractReaper(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
        this.m_20242_(true);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new MeleeGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new ReaperAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FlyTowardsTargetGoal(this));
        this.f_21345_.m_25352_(6, new FlyingGoal<AbstractReaper>(this));
        this.f_21345_.m_25352_(7, (Goal)new ReaperLookGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.ReaperHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.ReaperArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.ReaperDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.ReaperHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.ReaperArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.ReaperDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof AbstractReaper;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.ReaperLimit.get();
    }

    @Override
    public int xpReward() {
        return 10;
    }

    @Override
    protected boolean isSunSensitive() {
        return true;
    }

    protected PathNavigation m_6037_(Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }
        };
        flyingpathnavigation.m_26440_(false);
        flyingpathnavigation.m_7008_(true);
        flyingpathnavigation.m_26443_(true);
        return flyingpathnavigation;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.REAPER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.REAPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REAPER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)ModSounds.REAPER_FLY.get();
    }

    protected void m_7355_(BlockPos p_29419_, BlockState p_29420_) {
    }

    private void calculateFlapping() {
        this.oFly = this.fly;
        this.oFlySpeed = this.flySpeed;
        this.flySpeed += (float)(!this.m_20096_() && !this.m_20159_() ? 4 : -1) * 0.3f;
        this.flySpeed = Mth.m_14036_((float)this.flySpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flying < 1.0f) {
            this.flying = 1.0f;
        }
        this.flying *= 0.9f;
        this.fly += this.flying * 2.0f;
    }

    protected void m_146874_() {
        if (this.m_142039_()) {
            this.m_142043_();
            if (this.m_142319_().m_146945_()) {
                this.m_146850_(GameEvent.f_157785_);
            }
        }
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFly;
    }

    protected void m_142043_() {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
        this.nextFly = this.f_146794_ + this.flySpeed / 2.0f;
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "attack")) {
            return 2;
        }
        if (Objects.equals(animation, "death")) {
            return 3;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.idleAnimationState);
        list.add(this.attackAnimationState);
        list.add(this.deathAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 3: {
                    this.deathAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deathAnimationState);
                }
            }
        }
        super.m_7350_(accessor);
    }

    private boolean getReaperFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setReaperFlags(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getReaperFlag(1);
    }

    public void setMeleeAttacking(boolean attacking) {
        this.setReaperFlags(1, attacking);
        this.attackTick = 0;
        this.f_19853_.m_7605_((Entity)this, (byte)5);
    }

    public void m_7822_(byte pId) {
        if (pId == 5) {
            this.attackTick = 0;
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_142535_(float p_146828_, float p_146829_, DamageSource p_146830_) {
        return false;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean m_20161_() {
        return true;
    }

    protected void m_6153_() {
        ++this.deathTime;
        if (this.deathTime >= 30) {
            this.m_21373_();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.f_20916_ = 1;
    }

    @Override
    public void m_6667_(DamageSource p_21014_) {
        this.setAnimationState(DEATH);
        super.m_6667_(p_21014_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.isMeleeAttacking()) {
                ++this.attackTick;
            } else if (!this.m_21224_()) {
                this.setAnimationState(IDLE);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    public double m_142593_(LivingEntity p_147273_) {
        return this.m_20205_() * 4.0f * this.m_20205_() * 4.0f + p_147273_.m_20205_();
    }

    public boolean m_6147_() {
        return false;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_150930_((Item)ModItems.ECTOPLASM.get()) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_((SoundEvent)ModSounds.REAPER_AMBIENT.get(), 1.0f, 1.25f);
            this.m_5634_(2.0f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            pPlayer.m_6674_(pHand);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class MeleeGoal
    extends Goal {
        private final AbstractReaper reaper;

        public MeleeGoal(AbstractReaper reaper) {
            this.reaper = reaper;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.reaper.m_5448_() != null && this.reaper.isMeleeAttacking();
        }

        public boolean m_8045_() {
            return this.reaper.attackTick < 23;
        }

        public void m_8056_() {
            this.reaper.setMeleeAttacking(true);
            this.reaper.setAnimationState(ATTACK);
        }

        public void m_8041_() {
            this.reaper.setMeleeAttacking(false);
            this.reaper.setAnimationState(IDLE);
        }

        public void m_8037_() {
            if (this.reaper.m_5448_() != null && this.reaper.m_5448_().m_6084_()) {
                LivingEntity livingentity = this.reaper.m_5448_();
                MobUtil.instaLook((Mob)this.reaper, (Entity)livingentity);
                this.reaper.m_5618_(this.reaper.m_6080_());
                if (this.reaper.attackTick == 1) {
                    this.reaper.m_5496_((SoundEvent)ModSounds.REAPER_SWING.get(), this.reaper.m_6121_(), this.reaper.m_6100_());
                    this.reaper.setAnimationState(ATTACK);
                }
                if (this.reaper.attackTick == 12) {
                    this.attackMobs(livingentity, this.reaper);
                }
            }
        }

        public Vec3 getHorizontalLookAngle() {
            return this.reaper.m_20171_(0.0f, this.reaper.m_146908_());
        }

        public void attackMobs(LivingEntity pTarget, AbstractReaper reaper) {
            LivingEntity livingEntity = reaper.getTrueOwner();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                SEHelper.increaseSouls(player, (Integer)ItemConfig.DarkScytheSouls.get() * 5);
            }
            float f = (float)reaper.m_21133_(Attributes.f_22281_);
            float f1 = EnchantmentHelper.m_44833_((ItemStack)reaper.m_21205_(), (MobType)pTarget.m_6336_());
            float f2 = 1.0f;
            f *= 0.2f + f2 * f2 * 0.8f;
            float f3 = 1.0f + SweepingEdgeEnchantment.m_45193_((int)3) * (f += (f1 *= f2));
            int j = EnchantmentHelper.m_44914_((LivingEntity)reaper);
            double area = 2.0;
            for (LivingEntity livingentity : reaper.f_19853_.m_45976_(LivingEntity.class, this.reaper.m_20191_().m_82383_(this.getHorizontalLookAngle().m_82490_(2.0)).m_82377_(area, area, area))) {
                LivingEntity livingEntity2;
                if (livingentity == reaper || MobUtil.areAllies((Entity)reaper, (Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(reaper.m_20280_((Entity)livingentity) < 16.0) || livingentity == reaper.m_20202_()) continue;
                livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(reaper.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(reaper.m_146908_() * ((float)Math.PI / 180)))));
                if (!livingentity.m_6469_(this.reaper.getServantAttack(), f3)) continue;
                if (j > 0) {
                    livingentity.m_20254_(j * 4);
                }
                if ((livingEntity2 = reaper.getTrueOwner()) instanceof Player) {
                    Player player = (Player)livingEntity2;
                    if (livingentity instanceof IOwned) {
                        IOwned owned = (IOwned)livingentity;
                        if (owned.getTrueOwner() != reaper) {
                            SEHelper.increaseSouls(player, (Integer)ItemConfig.DarkScytheSouls.get() * 5);
                        }
                    } else {
                        SEHelper.increaseSouls(player, (Integer)ItemConfig.DarkScytheSouls.get() * 5);
                    }
                }
                EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)reaper);
                EnchantmentHelper.m_44896_((LivingEntity)reaper, (Entity)livingentity);
            }
            reaper.f_19853_.m_6263_(null, reaper.m_20185_(), reaper.m_20186_(), reaper.m_20189_(), (SoundEvent)ModSounds.SCYTHE_SWING.get(), reaper.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(reaper.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(reaper.m_146908_() * ((float)Math.PI / 180)));
            Level level = reaper.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, reaper.m_20185_() + d0, reaper.m_20227_(0.5), reaper.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class ReaperAttackGoal
    extends MeleeAttackGoal {
        private final AbstractReaper reaper;

        public ReaperAttackGoal(AbstractReaper mob, double moveSpeed) {
            super((PathfinderMob)mob, moveSpeed, true);
            this.reaper = mob;
        }

        public boolean m_8036_() {
            return this.reaper.m_5448_() != null && this.reaper.m_5448_().m_6084_() && this.reaper.m_217066_(this.reaper.m_5448_());
        }

        public void m_8037_() {
            LivingEntity livingentity = this.reaper.m_5448_();
            if (livingentity == null) {
                return;
            }
            this.m_6739_(livingentity, this.reaper.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_()));
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            if (this.reaper.m_217066_(enemy) && this.reaper.m_142582_((Entity)enemy)) {
                this.reaper.setMeleeAttacking(true);
            }
        }
    }

    public static class FlyTowardsTargetGoal
    extends Goal {
        private final AbstractReaper reaper;

        public FlyTowardsTargetGoal(AbstractReaper reaper) {
            this.reaper = reaper;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.reaper.m_5448_() != null && !this.reaper.isStaying() && !this.reaper.m_21566_().m_24995_();
        }

        public boolean m_8045_() {
            return this.reaper.m_21566_().m_24995_() && !this.reaper.isStaying() && this.reaper.m_5448_() != null && this.reaper.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity target = this.reaper.m_5448_();
            if (target != null) {
                this.reaper.m_21573_().m_5624_((Entity)target, 1.0);
            }
        }

        public void m_8037_() {
            double d0;
            LivingEntity target = this.reaper.m_5448_();
            if (target != null && (d0 = this.reaper.m_20280_((Entity)target)) < 16.0) {
                this.reaper.m_21573_().m_5624_((Entity)target, 1.0);
            }
        }
    }

    static class FlyingGoal<T extends PathfinderMob>
    extends Summoned.WanderGoal<T> {
        public FlyingGoal(T reaper) {
            super(reaper, 0.8, 20.0f);
        }

        @Override
        @Nullable
        protected Vec3 m_7037_() {
            if (((IServant)this.summonedEntity).isGuardingArea()) {
                return this.randomBoundPos();
            }
            return this.getFlyingPosition();
        }

        protected Vec3 getFlyingPosition() {
            double xd = this.summonedEntity.m_20185_() + (double)((this.summonedEntity.m_217043_().m_188501_() * 2.0f - 1.0f) * 16.0f);
            double yd = this.summonedEntity.m_20186_() + (double)((this.summonedEntity.m_217043_().m_188501_() * 2.0f - 1.0f) * 16.0f);
            double zd = this.summonedEntity.m_20189_() + (double)((this.summonedEntity.m_217043_().m_188501_() * 2.0f - 1.0f) * 16.0f);
            return new Vec3(xd, yd, zd);
        }
    }

    public static class ReaperLookGoal
    extends Goal {
        private final AbstractReaper reaper;

        public ReaperLookGoal(AbstractReaper reaper) {
            this.reaper = reaper;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.reaper.m_5448_() == null) {
                this.reaper.m_146922_(-((float)Mth.m_14136_((double)this.reaper.m_20184_().m_7096_(), (double)this.reaper.m_20184_().m_7094_())) * 57.295776f);
                this.reaper.m_5618_(this.reaper.m_146908_());
            } else {
                LivingEntity target = this.reaper.m_5448_();
                if (target.m_20280_((Entity)this.reaper) < (double)Mth.m_144944_((int)64)) {
                    double d1 = target.m_20185_() - this.reaper.m_20185_();
                    double d2 = target.m_20189_() - this.reaper.m_20189_();
                    this.reaper.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.reaper.m_5618_(this.reaper.m_146908_());
                }
            }
        }
    }
}

