/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class ModWitherSkull
extends WitherSkull {
    private static final EntityDataAccessor<Boolean> DATA_UPGRADED = SynchedEntityData.m_135353_(ModWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_EXPLOSION = SynchedEntityData.m_135353_(ModWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_DAMAGE = SynchedEntityData.m_135353_(ModWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> DATA_EXTRA_DAMAGE = SynchedEntityData.m_135353_(ModWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> DATA_FIERY = SynchedEntityData.m_135353_(ModWitherSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModWitherSkull(EntityType<? extends WitherSkull> p_37598_, Level p_37599_) {
        super(p_37598_, p_37599_);
    }

    public ModWitherSkull(double p_i50167_2_, double p_i50167_4_, double p_i50167_6_, double p_i50167_8_, double p_i50167_10_, double p_i50167_12_, Level p_i50167_14_) {
        this((EntityType<? extends WitherSkull>)((EntityType)ModEntityType.MOD_WITHER_SKULL.get()), p_i50167_14_);
        this.m_7678_(p_i50167_2_, p_i50167_4_, p_i50167_6_, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(p_i50167_8_ * p_i50167_8_ + p_i50167_10_ * p_i50167_10_ + p_i50167_12_ * p_i50167_12_);
        if (d0 != 0.0) {
            this.f_36813_ = p_i50167_8_ / d0 * 0.1;
            this.f_36814_ = p_i50167_10_ / d0 * 0.1;
            this.f_36815_ = p_i50167_12_ / d0 * 0.1;
        }
    }

    public ModWitherSkull(Level p_37609_, LivingEntity p_37610_, double p_37611_, double p_37612_, double p_37613_) {
        this(p_37610_.m_20185_(), p_37610_.m_20186_(), p_37610_.m_20189_(), p_37611_, p_37612_, p_37613_, p_37609_);
        this.m_5602_((Entity)p_37610_);
        this.m_19915_(p_37610_.m_146908_(), p_37610_.m_146909_());
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntityType.MOD_WITHER_SKULL.get();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_UPGRADED, (Object)false);
        this.f_19804_.m_135372_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_FIERY, (Object)0);
        this.f_19804_.m_135372_(DATA_EXPLOSION, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_DAMAGE, (Object)Float.valueOf(8.0f));
    }

    public float getExplosionPower() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXPLOSION)).floatValue();
    }

    public void setExplosionPower(float pExplosionPower) {
        this.f_19804_.m_135381_(DATA_EXPLOSION, (Object)Float.valueOf(pExplosionPower));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_DAMAGE)).floatValue();
    }

    public void setDamage(float pDamage) {
        this.f_19804_.m_135381_(DATA_DAMAGE, (Object)Float.valueOf(pDamage));
    }

    public float getExtraDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_EXTRA_DAMAGE)).floatValue();
    }

    public void setExtraDamage(float extra) {
        this.f_19804_.m_135381_(DATA_EXTRA_DAMAGE, (Object)Float.valueOf(extra));
    }

    public int getFiery() {
        return (Integer)this.f_19804_.m_135370_(DATA_FIERY);
    }

    public void setFiery(int fiery) {
        this.f_19804_.m_135381_(DATA_FIERY, (Object)fiery);
    }

    public boolean isUpgraded() {
        return (Boolean)this.f_19804_.m_135370_(DATA_UPGRADED);
    }

    public void setUpgraded(boolean upgraded) {
        this.f_19804_.m_135381_(DATA_UPGRADED, (Object)upgraded);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128350_("ExplosionPower", this.getExplosionPower());
        pCompound.m_128350_("Damage", this.getDamage());
        pCompound.m_128350_("ExtraDamage", this.getExtraDamage());
        pCompound.m_128405_("Fiery", this.getFiery());
        pCompound.m_128379_("Upgraded", this.isUpgraded());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ExplosionPower", 99)) {
            this.setExplosionPower(pCompound.m_128457_("ExplosionPower"));
        }
        if (pCompound.m_128425_("Damage", 99)) {
            this.setDamage(pCompound.m_128457_("Damage"));
        }
        if (pCompound.m_128425_("ExtraDamage", 99)) {
            this.setExtraDamage(pCompound.m_128457_("ExtraDamage"));
        }
        if (pCompound.m_128441_("Fiery")) {
            this.setFiery(pCompound.m_128451_("Fiery"));
        }
        if (pCompound.m_128441_("Upgraded")) {
            this.setUpgraded(pCompound.m_128471_("Upgraded"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= MathHelper.secondsToTicks(10)) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult p_37626_) {
        if (!this.f_19853_.f_46443_) {
            boolean flag;
            Entity entity = p_37626_.m_82443_();
            Entity entity1 = this.m_19749_();
            float enchantment = this.getExtraDamage();
            int duration = 1;
            if (entity1 instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity1;
                float damage = entity1 instanceof Player ? ((Double)SpellConfig.WitherSkullDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue() : this.getDamage();
                flag = entity.m_6469_(this.m_269291_().m_269383_((WitherSkull)this, (Entity)livingentity), damage + enchantment);
                if (flag) {
                    if (entity.m_6084_()) {
                        this.m_19970_(livingentity, entity);
                    } else {
                        livingentity.m_5634_(5.0f);
                    }
                }
            } else {
                flag = entity.m_6469_(this.m_269291_().m_269425_(), 5.0f);
            }
            if (flag && entity instanceof LivingEntity) {
                Player player;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof Player && WandUtil.enchantedFocus((LivingEntity)(player = (Player)livingEntity))) {
                    duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), (LivingEntity)player);
                }
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 200 * duration, 1), this.m_150173_());
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        HitResult.Type hitresult$type = pResult.m_6662_();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)pResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, pResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, (BlockState)null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)pResult;
            this.m_8060_(blockhitresult);
            BlockPos blockpos = blockhitresult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockpos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockpos)));
        }
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explodeMode;
            Entity owner = this.m_19749_();
            boolean flaming = this.getFiery() > 0;
            boolean loot = CuriosFinder.hasWanting(owner);
            Explosion.BlockInteraction blockInteraction = explodeMode = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
            if (this.m_19749_() instanceof Player) {
                explodeMode = (Boolean)SpellConfig.WitherSkullGriefing.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP;
            }
            LootingExplosion.Mode lootMode = loot ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
            ExplosionUtil.lootExplode(this.f_19853_, (Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getExplosionPower(), flaming, explodeMode, lootMode);
            this.m_146870_();
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.m_19749_() != null) {
            Mob mob;
            if (pEntity == this.m_19749_()) {
                return false;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies(this.m_19749_(), pEntity)) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)entity2;
                    return !MobUtil.ownerStack(owned0, owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }
}

