/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SThunderBoltPacket;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class KillingSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.KillingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.KillingDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.KillingCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public boolean conditionsMet(ServerLevel worldIn, LivingEntity caster) {
        return this.getTarget(caster) != null;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void useSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, int castTime, SpellStat spellStat) {
        LivingEntity target = this.getTarget(caster);
        if (target != null) {
            ColorUtil colorUtil = new ColorUtil(14226710);
            ServerParticleUtil.windParticle(worldIn, colorUtil, 1.0f, 0.0f, target.m_19879_(), target.m_20182_());
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Vec3 vec3 = caster.m_146892_();
        LivingEntity target = this.getTarget(caster);
        if (target != null) {
            ColorUtil colorUtil = new ColorUtil(14226710);
            Vec3 vec31 = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
            DamageSource damageSource = ModDamageSource.deathCurse((Entity)caster);
            float damage = target.m_21223_();
            float casterDamage = damage * ((Double)SpellConfig.KillingFeedback.get()).floatValue();
            if (caster.m_21223_() - MobUtil.hurtCalculation(caster, damageSource, casterDamage) <= 0.0f && EntitySelector.f_20406_.test(caster)) {
                damage = caster.m_21223_() - 1.0f;
                casterDamage = caster.m_21223_() - 1.0f;
            }
            if ((caster.m_6469_(damageSource, casterDamage) || !EntitySelector.f_20406_.test(caster)) && target.m_6469_(damageSource, damage)) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vector3d = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
                    Vec3 vector3d1 = vector3d.m_272010_(target.m_217043_(), 8.0f);
                    worldIn.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil, vector3d1), vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0, 0.0, 0.0, 0.0, 0.5);
                    ServerParticleUtil.windParticle(worldIn, colorUtil, 1.0f, 0.0f, target.m_19879_(), target.m_20182_());
                }
                ModNetwork.sendToALL(new SThunderBoltPacket(vec3, vec31, colorUtil, 10));
                this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.THUNDERBOLT.get(), 3.0f, 0.75f);
                this.playSound(worldIn, (Entity)caster, SoundEvents.f_12089_, 3.0f, 0.75f);
            }
        }
    }
}

