/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface PlayerDetector {
    public static final PlayerDetector NO_CREATIVE_PLAYERS = (serverLevel, entitySelector, blockPos, d, bl) -> entitySelector.getPlayers(serverLevel, player -> player.m_20183_().m_123314_((Vec3i)blockPos, d) && !player.m_7500_() && !player.m_5833_()).stream().filter(player -> !bl || PlayerDetector.inLineOfSight((Level)serverLevel, blockPos.m_252807_(), player.m_146892_())).map(Entity::m_20148_).toList();
    public static final PlayerDetector INCLUDING_CREATIVE_PLAYERS = (serverLevel, entitySelector, blockPos, d, bl) -> entitySelector.getPlayers(serverLevel, player -> player.m_20183_().m_123314_((Vec3i)blockPos, d) && !player.m_5833_()).stream().filter(player -> !bl || PlayerDetector.inLineOfSight((Level)serverLevel, blockPos.m_252807_(), player.m_146892_())).map(Entity::m_20148_).toList();
    public static final PlayerDetector SHEEP = (serverLevel, entitySelector, blockPos, d, bl) -> {
        AABB aABB = new AABB(blockPos).m_82400_(d);
        return entitySelector.getEntities(serverLevel, EntityType.f_20520_, aABB, LivingEntity::m_6084_).stream().filter(sheep -> !bl || PlayerDetector.inLineOfSight((Level)serverLevel, blockPos.m_252807_(), sheep.m_146892_())).map(Entity::m_20148_).toList();
    };

    public List<UUID> detect(ServerLevel var1, EntitySelector var2, BlockPos var3, double var4, boolean var6);

    private static boolean inLineOfSight(Level level, Vec3 vec3, Vec3 vec32) {
        BlockHitResult blockHitResult = level.m_45547_(new ClipContext(vec32, vec3, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return blockHitResult.m_82425_().equals((Object)BlockPos.m_274446_((Position)vec3)) || blockHitResult.m_6662_() == HitResult.Type.MISS;
    }

    public static interface EntitySelector {
        public static final EntitySelector SELECT_FROM_LEVEL = new EntitySelector(){

            public List<ServerPlayer> getPlayers(ServerLevel serverLevel, Predicate<? super Player> predicate) {
                return serverLevel.m_8795_(predicate);
            }

            @Override
            public <T extends Entity> List<T> getEntities(ServerLevel serverLevel, EntityTypeTest<Entity, T> entityTypeTest, AABB aABB, Predicate<? super T> predicate) {
                return serverLevel.m_142425_(entityTypeTest, aABB, predicate);
            }
        };

        public List<? extends Player> getPlayers(ServerLevel var1, Predicate<? super Player> var2);

        public <T extends Entity> List<T> getEntities(ServerLevel var1, EntityTypeTest<Entity, T> var2, AABB var3, Predicate<? super T> var4);

        public static EntitySelector onlySelectPlayer(Player player) {
            return EntitySelector.onlySelectPlayers(List.of(player));
        }

        public static EntitySelector onlySelectPlayers(final List<Player> list) {
            return new EntitySelector(){

                public List<Player> getPlayers(ServerLevel serverLevel, Predicate<? super Player> predicate) {
                    return list.stream().filter(predicate).toList();
                }

                @Override
                public <T extends Entity> List<T> getEntities(ServerLevel serverLevel, EntityTypeTest<Entity, T> entityTypeTest, AABB aABB, Predicate<? super T> predicate) {
                    return list.stream().map(arg_0 -> entityTypeTest.m_141992_(arg_0)).filter(Objects::nonNull).filter(predicate).toList();
                }
            };
        }
    }
}

