/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.breath;

import com.sfdesat.config.ColdBreathConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;

@Environment(value=EnvType.CLIENT)
public final class StateBlends {
    private double sprintBlend = 0.0;
    private double prevSprintBlend = 0.0;
    private double healthBlend = 0.0;
    private double prevHealthBlend = 0.0;

    public void tick(class_1657 player, ColdBreathConfig cfg) {
        this.prevSprintBlend = this.sprintBlend;
        this.prevHealthBlend = this.healthBlend;
        this.updateSprintBlend(player, cfg);
        this.updateHealthBlend(player, cfg);
    }

    private void updateSprintBlend(class_1657 player, ColdBreathConfig cfg) {
        double target;
        double downRate;
        boolean underwater = player.method_5869();
        double dt = 0.05;
        double upRate = cfg.sprintBuildUpSeconds <= 0.0 ? 1.0 : dt / cfg.sprintBuildUpSeconds;
        double d = downRate = cfg.sprintBuildDownSeconds <= 0.0 ? 1.0 : dt / cfg.sprintBuildDownSeconds;
        if (underwater && cfg.underwaterEnabled) {
            if (this.sprintBlend < 1.0) {
                this.sprintBlend = Math.min(1.0, this.sprintBlend + upRate);
            }
            return;
        }
        boolean sprinting = player.method_5624();
        double d2 = target = cfg.sprintingIntervalsEnabled && sprinting ? 1.0 : 0.0;
        if (target > this.sprintBlend) {
            this.sprintBlend = Math.min(1.0, this.sprintBlend + upRate);
        } else if (target < this.sprintBlend) {
            this.sprintBlend = Math.max(0.0, this.sprintBlend - downRate);
        }
    }

    private void updateHealthBlend(class_1657 player, ColdBreathConfig cfg) {
        if (!cfg.healthBasedBreathingEnabled) {
            this.healthBlend = 0.0;
            return;
        }
        float maxHealth = player.method_6063();
        float currentHealth = player.method_6032();
        float healthPercentage = 1.0f - currentHealth / maxHealth;
        double target = Math.max(0.0, Math.min(1.0, (double)healthPercentage));
        double alpha = 0.2;
        this.healthBlend += alpha * (target - this.healthBlend);
    }

    public double getSprintBlend() {
        return this.sprintBlend;
    }

    public double getPrevSprintBlend() {
        return this.prevSprintBlend;
    }

    public double getHealthBlend() {
        return this.healthBlend;
    }

    public double getPrevHealthBlend() {
        return this.prevHealthBlend;
    }
}

