/*
 * Decompiled with CFR 0.152.
 */
package com.sfdesat.coldbreath.debug;

import com.sfdesat.coldbreath.breath.BreathController;
import com.sfdesat.coldbreath.breath.EnvModel;
import com.sfdesat.coldbreath.breath.StateBlends;
import com.sfdesat.config.ColdBreathConfig;
import com.sfdesat.config.ConfigManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public final class BreathDebugHud {
    private final StateBlends blends;

    public BreathDebugHud(StateBlends blends) {
        this.blends = blends;
    }

    public void register() {
        HudRenderCallback.EVENT.register((context, tickDelta) -> {
            ColdBreathConfig cfg = ConfigManager.get();
            if (!cfg.debugEnabled) {
                return;
            }
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1772 == null) {
                return;
            }
            int x = 6;
            int y = 6;
            class_638 world = client.field_1687;
            int lines = 8;
            int lineHeight = 12;
            int padding = 10;
            int bgWidth = 260;
            int bgHeight = lines * lineHeight + padding;
            int bgColor = 0x66000000;
            context.method_25294(x - 3, y - 3, x - 3 + bgWidth, y - 3 + bgHeight, bgColor);
            String breathingText = "breathing: unknown";
            int breathingColor = -1;
            if (world != null && client.field_1724 != null) {
                boolean underwater = client.field_1724.method_5869();
                if (underwater && cfg.underwaterEnabled) {
                    breathingText = "breathing: bubbles";
                    breathingColor = -11623425;
                } else {
                    boolean eligible = EnvModel.isEligibleNow(world, (class_1657)client.field_1724, cfg);
                    breathingText = eligible ? "breathing: true" : "breathing: false";
                    breathingColor = eligible ? -16711936 : -65536;
                }
            }
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)breathingText), x, y, breathingColor, false);
            y += 12;
            double baseInterval = BreathController.INSTANCE.getCurrentBaseIntervalSeconds(cfg);
            if (world != null && client.field_1724 != null && client.field_1724.method_5869() && cfg.underwaterEnabled) {
                baseInterval = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
            }
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)String.format("interval: %.1fs", baseInterval)), x, y, -1, false);
            y += 12;
            double minInt = baseInterval;
            double maxInt = baseInterval;
            if (world != null && client.field_1724 != null && client.field_1724.method_5869() && cfg.underwaterEnabled) {
                double base = Math.max(0.1, cfg.underwaterBaseIntervalSeconds);
                double dev = Math.max(0.0, cfg.underwaterIntervalDeviationSeconds);
                minInt = Math.max(0.1, base - dev);
                maxInt = Math.max(minInt, base + dev);
            } else {
                double[] range = BreathController.INSTANCE.getCurrentIntervalMinMaxSeconds(cfg);
                minInt = range[0];
                maxInt = range[1];
            }
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)String.format("min/max: %.1fs / %.1fs", minInt, maxInt)), x, y, -1, false);
            y += 12;
            if (world != null && client.field_1724 != null) {
                class_2338 pos = client.field_1724.method_24515();
                float baseTemp = ((class_1959)world.method_23753(pos).comp_349()).method_8712();
                float effTemp = EnvModel.computeEffectiveTemperature(world, pos, cfg);
                int sea = world.method_8615();
                int alt = pos.method_10264() - sea;
                String tempLine = String.format("temp: %.3f (base: %.3f), alt: %+d", Float.valueOf(effTemp), Float.valueOf(baseTemp), alt);
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)tempLine), x, y, -1, false);
                y += 12;
            }
            String status = this.getDebugState(cfg);
            String blendsLine = String.format("status: %s | sprint: %.2f | health: %.2f", status, this.blends.getSprintBlend(), this.blends.getHealthBlend());
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)blendsLine), x, y, -1, false);
            y += 12;
            if (world != null && client.field_1724 != null) {
                long dayTime = world.method_8532() % 24000L;
                boolean inWindow = EnvModel.isWithinDayWindow(dayTime, cfg.morningBreathStartTick, cfg.morningBreathEndTick);
                float temp = EnvModel.computeEffectiveTemperature(world, client.field_1724.method_24515(), cfg);
                boolean okTemp = (double)temp > cfg.alwaysBreathTemperature && (double)temp <= cfg.maxMorningBreathTemperature;
                boolean morningActive = cfg.morningBreathEnabled && inWindow && okTemp;
                int morningColor = morningActive ? -16711936 : -65536;
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)("morning breath: " + (morningActive ? "true" : "false"))), x, y, morningColor, false);
                String range = String.format("time: %d | morning range: %d-%d", dayTime, cfg.morningBreathStartTick, cfg.morningBreathEndTick);
                context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)range), x, y += 12, -1, false);
                y += 12;
            }
            Object dimText = "dim: unknown";
            if (world != null) {
                EnvModel.DimensionKind kind = EnvModel.getDimensionKind(world);
                dimText = "dim: " + kind.name().toLowerCase() + " (" + String.valueOf(world.method_27983().method_29177()) + ")";
            }
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)dimText), x, y, -1, false);
        });
    }

    private String getDebugState(ColdBreathConfig cfg) {
        boolean sprintCtrl;
        if (!cfg.sprintingIntervalsEnabled && !cfg.healthBasedBreathingEnabled) {
            return "normal";
        }
        double baseNormal = Math.max(0.1, cfg.baseIntervalSeconds);
        double baseSprint = Math.max(0.1, cfg.sprintBaseIntervalSeconds);
        double baseHealth = Math.max(0.1, cfg.lowHealthIntervalSeconds);
        double afterSprint = BreathDebugHud.lerp(baseNormal, baseSprint, cfg.sprintingIntervalsEnabled ? this.blends.getSprintBlend() : 0.0);
        double afterHealth = BreathDebugHud.lerp(baseNormal, baseHealth, cfg.healthBasedBreathingEnabled ? this.blends.getHealthBlend() : 0.0);
        boolean healthCtrl = cfg.healthBasedBreathingEnabled && afterHealth <= afterSprint;
        boolean bl = sprintCtrl = cfg.sprintingIntervalsEnabled && afterSprint < afterHealth;
        if (healthCtrl) {
            if (this.blends.getHealthBlend() >= 0.7) {
                return "critical health";
            }
            if (this.blends.getHealthBlend() >= 0.3) {
                return "low health";
            }
            return "health priority";
        }
        if (sprintCtrl) {
            if (this.blends.getSprintBlend() >= 0.95) {
                return "sprinting";
            }
            if (this.blends.getSprintBlend() <= 0.05) {
                return "normal";
            }
            if (this.blends.getSprintBlend() > this.blends.getPrevSprintBlend() + 1.0E-6) {
                return "building up";
            }
            if (this.blends.getSprintBlend() < this.blends.getPrevSprintBlend() - 1.0E-6) {
                return "building down";
            }
            return "transitional";
        }
        return "normal";
    }

    private static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }
}

