/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul;

import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.thatgravyboat.winteroverhaul.common.entity.IUpgradeAbleSnowGolem;
import tech.thatgravyboat.winteroverhaul.common.entity.Robin;
import tech.thatgravyboat.winteroverhaul.common.items.GolemUpgradeSlot;
import tech.thatgravyboat.winteroverhaul.common.registry.ModEntities;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.registry.ModParticles;
import tech.thatgravyboat.winteroverhaul.common.registry.ModSounds;
import tech.thatgravyboat.winteroverhaul.common.util.BiomeSpawns;
import tech.thatgravyboat.winteroverhaul.common.util.EntityAttributesBuilder;
import tech.thatgravyboat.winteroverhaul.mixin.AccessorCauldronInteraction;

public class WinterOverhaul {
    public static final String MODID = "winteroverhaul";
    public static final Logger LOGGER = LogManager.getLogger();

    public void register() {
        ModItems.ITEMS.register();
        ModParticles.PARTICLES.register();
        ModEntities.ENTITIES.register();
        ModSounds.SOUNDS.register();
        ModItems.TAB_REGISTER.register();
        SpawnPlacementsRegistry.register(ModEntities.ROBIN, (SpawnPlacementType)SpawnPlacementTypes.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING, (entity, level, spawn, pos, random) -> {
            BlockState state = level.getBlockState(pos.below());
            boolean isLeaves = state.is(BlockTags.LEAVES);
            boolean isSnow = state.is(BlockTags.SNOW);
            boolean isGrass = state.is(Blocks.GRASS_BLOCK);
            return (isLeaves || isSnow || isGrass || state.isAir()) && level.getRawBrightness(pos, 0) > 8;
        });
    }

    public InteractionResult onEntityRightClick(Entity target, ItemStack stack, Player player) {
        SnowGolem snowGolem;
        if (!(target instanceof SnowGolem) || (snowGolem = (SnowGolem)target).hasPumpkin()) {
            return InteractionResult.PASS;
        }
        if (!(snowGolem instanceof IUpgradeAbleSnowGolem)) {
            return InteractionResult.PASS;
        }
        IUpgradeAbleSnowGolem upgradeAbleSnowGolem = (IUpgradeAbleSnowGolem)snowGolem;
        if (stack.is(Items.CARROT) || stack.is(Items.GOLDEN_CARROT)) {
            ItemStack oldItem = upgradeAbleSnowGolem.getGolemUpgradeInSlot(GolemUpgradeSlot.FACE);
            if (!oldItem.isEmpty()) {
                player.drop(oldItem, true);
            }
            ItemStack newStack = stack.copy();
            newStack.setCount(1);
            upgradeAbleSnowGolem.setGolemUpgradeInSlot(GolemUpgradeSlot.FACE, newStack);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && player.isShiftKeyDown()) {
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                ItemStack oldStack = upgradeAbleSnowGolem.setGolemUpgradeInSlot(value, ItemStack.EMPTY);
                if (oldStack.isEmpty()) continue;
                player.drop(oldStack, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void onEntitySpawn(LivingEntity entity, LevelReader level) {
        Holder biome;
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        EntityType type = mob.getType();
        boolean isSkeleton = type.equals(EntityType.SKELETON) || type.equals(EntityType.STRAY);
        boolean isZombie = type.equals(EntityType.ZOMBIE);
        if ((isSkeleton || isZombie) && !mob.isBaby() && (biome = level.getBiomeManager().getBiome(entity.blockPosition())).isBound() && ((Biome)biome.value()).hasPrecipitation() && ((Biome)biome.value()).getPrecipitationAt(entity.blockPosition(), level.getSeaLevel()).equals((Object)Biome.Precipitation.SNOW) && mob.getRandom().nextFloat() > 0.9f && mob.getRandom().nextFloat() > 0.5f) {
            Item item = WinterOverhaul.getRandomHatAndScarf(mob.getRandom().nextInt(8));
            mob.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)item));
        }
    }

    public void addSpawns(BiomeSpawns spawns) {
        spawns.addSpawn(biome -> biome.is(BiomeTags.IS_TAIGA) && ((Biome)biome.value()).getBaseTemperature() < 0.15f, MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ROBIN.get(), 1, 2), 25);
    }

    public void onMobDrops(LivingEntity livingEntity, Collection<ItemEntity> drops) {
        if (livingEntity instanceof IUpgradeAbleSnowGolem) {
            IUpgradeAbleSnowGolem golem = (IUpgradeAbleSnowGolem)livingEntity;
            for (GolemUpgradeSlot value : GolemUpgradeSlot.values()) {
                ItemStack stack = golem.getGolemUpgradeInSlot(value);
                BlockPos pos = livingEntity.blockPosition();
                if (stack.isEmpty()) continue;
                drops.add(new ItemEntity(livingEntity.level(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack.copy()));
            }
        }
    }

    public boolean onEntityDamage(Entity entity, DamageSource source) {
        return entity instanceof SnowGolem && source.getDirectEntity() instanceof Snowball;
    }

    public void addAttributes(EntityAttributesBuilder builder) {
        builder.register((EntityType<? extends LivingEntity>)((EntityType)ModEntities.ROBIN.get()), Robin.createAttributes().build());
    }

    public void onComplete() {
        CauldronInteraction.WATER.map().put((Item)ModItems.SKATES.get(), AccessorCauldronInteraction::callDyedItemIteration);
    }

    private static Item getRandomHatAndScarf(int randomInt) {
        return switch (randomInt) {
            case 0 -> (Item)ModItems.GREEN_HAT.get();
            case 1 -> (Item)ModItems.GREEN_SCARF.get();
            case 2 -> (Item)ModItems.YELLOW_HAT.get();
            case 3 -> (Item)ModItems.YELLOW_SCARF.get();
            case 4 -> (Item)ModItems.RED_HAT.get();
            case 5 -> (Item)ModItems.RED_SCARF.get();
            case 6 -> (Item)ModItems.CYAN_HAT.get();
            default -> (Item)ModItems.CYAN_SCARF.get();
        };
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

