/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.armor.skates;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.renderer.armor.skates.SkatesModel;
import tech.thatgravyboat.winteroverhaul.common.items.SkateItem;

public class SkatesRenderer<S extends HumanoidRenderState>
extends GeoArmorRenderer<SkateItem, S> {
    private static final DataTicket<Integer> DYED_COLOR = DataTicket.create((String)"dyed_color", Integer.class);

    public SkatesRenderer() {
        super((GeoModel)new SkatesModel());
    }

    protected void grabRelevantBones(BakedGeoModel bakedModel) {
        super.grabRelevantBones(bakedModel);
        this.rightLegBone = this.model.getBone("rightBoot").orElse(null);
        this.leftLegBone = this.model.getBone("leftBoot").orElse(null);
        this.rightBootBone = this.model.getBone("rightBoot").orElse(null);
        this.leftBootBone = this.model.getBone("leftBoot").orElse(null);
    }

    public void renderFinal(S renderState, PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
        this.renderWithColor(0.0f, poseStack, buffer, packedLight, renderColor, renderState, model);
    }

    public void addRenderData(SkateItem animatable, GeoArmorRenderer.RenderData relatedObject, S renderState) {
        ((GeoRenderState)renderState).addGeckolibData(DYED_COLOR, (Object)DyedItemColor.getOrDefault((ItemStack)relatedObject.itemStack(), (int)-6265536));
    }

    public void renderWithColor(float partialTicks, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int color, S renderState, BakedGeoModel model) {
        stack.pushPose();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        color = (Integer)((GeoRenderState)renderState).getGeckolibData(DYED_COLOR);
        ResourceLocation texture = WinterOverhaul.id("textures/entity/skates/base.png");
        RenderType renderType = this.getRenderType((HumanoidRenderState)renderState, texture);
        this.reRender((GeoRenderState)renderState, stack, model, (MultiBufferSource)bufferSource, renderType, bufferSource.getBuffer(renderType), packedLightIn, OverlayTexture.NO_OVERLAY, color);
        texture = WinterOverhaul.id("textures/entity/skates/overlay.png");
        renderType = this.getRenderType((HumanoidRenderState)renderState, texture);
        this.reRender((GeoRenderState)renderState, stack, model, (MultiBufferSource)bufferSource, renderType, bufferSource.getBuffer(renderType), packedLightIn, OverlayTexture.NO_OVERLAY, ARGB.color((int)ARGB.alpha((int)color), (int)255, (int)255, (int)255));
        stack.popPose();
    }
}

