/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity;

import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.SnowGolemRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.SnowGolem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.PumpkinLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomArmLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomButtonLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.RandomFaceLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers.UpgradeLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.model.ReplacedSnowGolemModel;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class ReplacedSnowGolemRenderer<S extends SnowGolemRenderState>
extends GeoReplacedEntityRenderer<ReplacedSnowGolem, SnowGolem, S> {
    public ReplacedSnowGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new ReplacedSnowGolemModel(), (GeoAnimatable)new ReplacedSnowGolem());
        this.addRenderLayer(new RandomButtonLayer(this));
        this.addRenderLayer(new RandomFaceLayer(this));
        this.addRenderLayer(new RandomArmLayer(this));
        this.addRenderLayer(new UpgradeLayer(this));
        this.addRenderLayer(new PumpkinLayer(this));
    }

    protected S createBaseRenderState(SnowGolem entity) {
        return (S)new SnowGolemRenderState();
    }

    public void extractRenderState(SnowGolem entity, S renderState, float partialTick) {
        super.extractRenderState((Entity)entity, renderState, partialTick);
        ((SnowGolemRenderState)renderState).hasPumpkin = entity.hasPumpkin();
    }

    public void addRenderData(ReplacedSnowGolem animatable, SnowGolem relatedObject, S renderState) {
        ((GeoRenderState)renderState).addGeckolibData(ReplacedSnowGolem.IS_PASSENGER, (Object)(relatedObject.isPassenger() && relatedObject.getVehicle() != null ? 1 : 0));
    }

    @Nullable
    public RenderType getRenderType(S renderState, ResourceLocation textureLocation) {
        return RenderType.entityTranslucent((ResourceLocation)textureLocation);
    }
}

