/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SnowGolemRenderState;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.thatgravyboat.winteroverhaul.client.renderer.entity.ReplacedSnowGolemRenderer;
import tech.thatgravyboat.winteroverhaul.common.entity.ReplacedSnowGolem;

public class PumpkinLayer<S extends SnowGolemRenderState>
extends GeoRenderLayer<ReplacedSnowGolem, SnowGolem, S> {
    public PumpkinLayer(ReplacedSnowGolemRenderer entityRendererIn) {
        super((GeoRenderer)entityRendererIn);
    }

    public void addPerBoneRender(S renderState, BakedGeoModel model, BiConsumer<GeoBone, PerBoneRender<S>> consumer) {
        super.addPerBoneRender(renderState, model, consumer);
        consumer.accept((GeoBone)model.getBone("head").orElseThrow(), (renderState1, stack, bone, renderType, bufferSource, packedLight, packedOverlay, renderColor) -> {
            if (renderState1.hasPumpkin) {
                Minecraft minecraft = Minecraft.getInstance();
                if (!renderState1.isInvisible || renderState1.appearsGlowing) {
                    stack.pushPose();
                    stack.translate(0.0, 1.6, 0.0);
                    stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                    stack.scale(0.6f, -0.6f, -0.6f);
                    BlockState blockstate = Blocks.CARVED_PUMPKIN.defaultBlockState();
                    BlockRenderDispatcher blockrenderdispatcher = minecraft.getBlockRenderer();
                    BlockStateModel bakedmodel = blockrenderdispatcher.getBlockModel(blockstate);
                    int i = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)renderState1, (float)0.0f);
                    stack.translate(-0.5, -0.5, -0.5);
                    VertexConsumer vertexConsumer = renderState1.appearsGlowing && renderState1.isInvisible ? bufferSource.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)) : bufferSource.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)blockstate));
                    ModelBlockRenderer.renderModel((PoseStack.Pose)stack.last(), (VertexConsumer)vertexConsumer, (BlockStateModel)bakedmodel, (float)0.0f, (float)0.0f, (float)0.0f, (int)packedLight, (int)i);
                    stack.popPose();
                }
            }
        });
    }
}

